/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Status;
import ix.ip2.ActionUnreadyReason;
import ix.ip2.ActivityItem;
import ix.ip2.AgendaItem;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.ip2.SimpleCompletionHandler;
import ix.ip2.SimpleUnreadyReason;
import ix.util.Collect;
import ix.util.Debug;

public class CompletionHandler
extends SimpleCompletionHandler {
    Ip2 ip2;

    public CompletionHandler(Ip2 ip2) {
        this.ip2 = ip2;
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        agendaItem.addAction(new NoAction(agendaItem));
        agendaItem.addAction(new DoneAction(agendaItem));
        agendaItem.addAction(new NotApplicableAction(agendaItem));
    }

    public class NotApplicableAction
    extends DoneAction {
        public NotApplicableAction(AgendaItem agendaItem) {
            super(agendaItem, "N/A");
        }
    }

    public class DoneAction
    extends HandlerAction.Manual {
        AgendaItem item;

        public DoneAction(AgendaItem agendaItem) {
            this(agendaItem, "Done");
        }

        public DoneAction(AgendaItem agendaItem, String string) {
            this.item = agendaItem;
            this.shortDescription = string;
        }

        public boolean isReady() {
            return Collect.isEmpty(CompletionHandler.this.ip2.getModelManager().getNodeConditions(this.item));
        }

        public ActionUnreadyReason getUnreadyReason() {
            return new SimpleUnreadyReason((HandlerAction)this, new String[]{"Cannot be used when there are conditions.", "Use \"Satisfy conditions\" instead."});
        }
    }

    public static class NoAction
    extends HandlerAction.NoAction {
        AgendaItem item;

        public NoAction(AgendaItem agendaItem) {
            this.shortDescription = this.makeDescription(agendaItem);
            this.item = agendaItem;
        }

        public void handle(AgendaItem agendaItem) {
            Debug.noteln("No action for", agendaItem);
            Debug.expect(agendaItem.getHandledBy() == this);
            agendaItem.setHandledBy(null);
        }

        public String getActionDescription() {
            this.shortDescription = this.makeDescription(this.item);
            return this.shortDescription;
        }

        String makeDescription(AgendaItem agendaItem) {
            Object object;
            String string;
            if (agendaItem instanceof ActivityItem && (string = ((ActivityItem)(object = (ActivityItem)agendaItem)).getExpansionRefinementName()) != null) {
                return "Refined by " + string;
            }
            object = agendaItem.getHowHandled();
            if (object != null) {
                return object;
            }
            if (agendaItem.getStatus() == Status.COMPLETE) {
                return "Done";
            }
            return "   ";
        }
    }
}

