/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Priority;
import ix.icore.Status;
import ix.icore.domain.Refinement;
import ix.iface.ui.DefaultColourField;
import ix.iface.ui.HTMLFrame;
import ix.iface.ui.NDRenderer;
import ix.iface.ui.table.IXTreeTable;
import ix.iface.ui.table.IXTreeTableNode;
import ix.iface.ui.table.TablePopupMenu;
import ix.iface.ui.util.UIUtil;
import ix.iface.util.CatchingActionListener;
import ix.ip2.AbstractAgendaItemPopupMenu;
import ix.ip2.AgendaItem;
import ix.ip2.AgendaItemTableModel;
import ix.ip2.AgendaManager;
import ix.ip2.AgendaViewer;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.ip2.ItemEditor;
import ix.ip2.event.AgendaEvent;
import ix.ip2.event.AgendaListener;
import ix.iview.util.EditablePriority;
import ix.iview.util.PriorityRenderer;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.TwoKeyHashMap;
import ix.util.Util;
import ix.util.lisp.LList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

public abstract class AgendaTableViewer
extends IXTreeTable
implements AgendaViewer,
AgendaListener,
MouseListener {
    protected Ip2 ip2;
    AgendaManager agendaManager;
    ItemEditor itemEditor;
    AgendaItemTableModel model;
    private static final ImageIcon editableIcon = Util.resourceImageIcon("ix-symbol-editable.gif");
    final PriorityPopupMenu priorityPopup = new PriorityPopupMenu();
    private DefaultCellEditor mouseableEditor;
    private JTextField noEditTF = new JTextField();
    private TwoKeyHashMap actionShadowingTable = new TwoKeyHashMap();

    public AgendaTableViewer(Ip2 ip2) {
        this.ip2 = ip2;
        this.setupAgendaTable();
        this.model.setParentsBold(true);
    }

    private void setupAgendaTable() {
        this.model = new AgendaItemTableModel(this);
        this.setModel(this.model);
        this.setAgendaRenderersNEditors();
        this.setPreferredScrollableViewportSize(new Dimension(500, 90));
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
    }

    private void setAgendaRenderersNEditors() {
        PriorityRenderer priorityRenderer = new PriorityRenderer(false);
        priorityRenderer.setToolTipText("Click for choices");
        this.setDefaultRenderer(Priority.class, priorityRenderer);
        this.setDefaultRenderer(EditablePriority.class, priorityRenderer);
        this.setDefaultRenderer(DefaultColourField.class, new NDRenderer(false));
        int n = ((AgendaItemTableModel)this.getModel()).DESCRIPTION_COL;
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        this.mouseableEditor = new DefaultCellEditor(this.noEditTF);
        tableColumn.setCellEditor(this.mouseableEditor);
        this.setDefaultEditor(String.class, this.mouseableEditor);
        this.noEditTF.setEditable(false);
        this.noEditTF.addMouseListener(this);
        this.noEditTF.setBackground(Color.white);
    }

    public void setItemEditor(ItemEditor itemEditor) {
        this.itemEditor = itemEditor;
    }

    public void ensureItemEditor() {
        if (this.itemEditor == null) {
            this.itemEditor = this.makeItemEditor();
        }
        this.itemEditor.setVisible(true);
    }

    protected abstract ItemEditor makeItemEditor();

    public synchronized void reset() {
        this.clearTable();
        this.invalidate();
    }

    public synchronized void clearTable() {
        this.model.clearData();
    }

    public HandlerAction findHandlerAction(AgendaItem agendaItem, String string) {
        HandlerAction handlerAction = (HandlerAction)this.actionShadowingTable.get(agendaItem, string);
        return handlerAction != null ? handlerAction : agendaItem.findAction(string);
    }

    protected void setShadowingAction(AgendaItem agendaItem, String string, HandlerAction handlerAction) {
        this.actionShadowingTable.put(agendaItem, string, handlerAction);
    }

    public void actionSelected(AgendaItem agendaItem, String string) {
        HandlerAction handlerAction = this.findHandlerAction(agendaItem, string);
        Debug.expect(handlerAction != null, "Can't find action", string);
        HandlerAction handlerAction2 = this.model.getHandlerAction(agendaItem);
        if (handlerAction.equals(handlerAction2) || (handlerAction2 == null || HandlerAction.NoAction.class.isInstance(handlerAction2)) && HandlerAction.NoAction.class.isInstance(handlerAction) || handlerAction2 != null && string.equals(handlerAction2.getActionDescription())) {
            return;
        }
        if (agendaItem.actionCanBeTakenNow(handlerAction)) {
            this.handleItem(agendaItem, handlerAction);
        } else {
            Debug.noteln("Ignoring action selection");
            JOptionPane.showMessageDialog(this, "The selected action cannot be taken now", "Action selection", 1);
            this.model.setHandlerAction(agendaItem, handlerAction2);
        }
    }

    public void handleItem(AgendaItem agendaItem, HandlerAction handlerAction) {
        HandlerAction handlerAction2 = this.model.getHandlerAction(agendaItem);
        this.model.setHandlerAction(agendaItem, handlerAction);
        try {
            this.agendaManager.handleItem(agendaItem, handlerAction);
        }
        catch (Throwable throwable) {
            Debug.noteln("Exception while handling item", agendaItem);
            Debug.noteException(throwable);
            JOptionPane.showMessageDialog(this, new Object[]{"Problem while handling item", Debug.foldException(throwable)}, "Problem while handling item", 0);
            this.model.setHandlerAction(agendaItem, handlerAction2);
        }
    }

    public void newHandlerAction(AgendaItem agendaItem, HandlerAction handlerAction) {
        Status status = agendaItem.getStatus();
        if (status == Status.COMPLETE || status == Status.EXECUTING || status == Status.IMPOSSIBLE) {
            return;
        }
        int n = this.getSelectedRow();
        int n2 = this.model.getObjectRow(agendaItem);
        try {
            this.setRowSelectionInterval(n2, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = handlerAction.getActionDescription();
        String string2 = null;
        List list = agendaItem.getActions();
        for (Object object : list) {
            if (object.equals(handlerAction) || !((HandlerAction)object).getActionDescription().equals(string)) continue;
            string2 = ((HandlerAction)object).getActionDescription();
            break;
        }
        if (string2 != null) {
            if (this.shouldReplaceAction(agendaItem, string2)) {
                this.setShadowingAction(agendaItem, handlerAction.getActionDescription(), handlerAction);
                Debug.expect(this.findHandlerAction(agendaItem, string2) == handlerAction);
            } else {
                Debug.expect(this.findHandlerAction(agendaItem, string2) != handlerAction);
            }
        } else {
            Object object;
            String string3 = handlerAction.getActionDescription();
            Debug.noteln("Item", Util.quote(agendaItem.getShortDescription()));
            Debug.noteln(" has new action", string3);
            object = new HandlerAction.NotApplicable().getActionDescription();
            String string4 = new HandlerAction.Manual().getActionDescription();
        }
        if (n >= 0) {
            this.setRowSelectionInterval(n, n);
        } else {
            this.clearSelection();
        }
    }

    boolean shouldReplaceAction(AgendaItem agendaItem, String string) {
        Object[] objectArray = new Object[]{"Replace existing action", "Ignore new action"};
        Object object = JOptionPane.showInputDialog(this, new Object[]{"Item " + Util.quote(agendaItem.getShortDescription()), "Already has an action " + Util.quote(string)}, "New Action", 1, null, objectArray, objectArray[0]);
        if (object == null) {
            return false;
        }
        return object.equals("Replace existing action");
    }

    public void getNewItemFromUser() {
        this.ensureItemEditor();
        this.itemEditor.showNewItem();
    }

    public AgendaItem makeItem(LList lList) {
        if (this.agendaManager == null) {
            Debug.noteln("Error: ***************** AgendaManager not set!");
            return null;
        }
        return this.agendaManager.makeItem(lList);
    }

    public void addItem(AgendaItem agendaItem) {
        this.agendaManager.addItem(agendaItem);
    }

    public void saveExpansion(Refinement refinement) {
        this.ip2.frame.getDomainEditor().saveExpansion(refinement);
    }

    public void expandItem(AgendaItem agendaItem, Refinement refinement) {
        this.agendaManager.expandItem(agendaItem, refinement);
    }

    public void addItem(String string) {
        this.addItem(this.agendaManager.makeItem(string));
    }

    public void addItem(Priority priority, String string) {
        AgendaItem agendaItem = this.agendaManager.makeItem(string);
        agendaItem.setPriority(priority);
        this.addItem(agendaItem);
    }

    public void setAgendaManager(AgendaManager agendaManager) {
        this.agendaManager = agendaManager;
    }

    public void itemAdded(AgendaEvent agendaEvent, AgendaItem agendaItem) {
        this.itemAdded(agendaItem);
    }

    public synchronized void itemAdded(AgendaItem agendaItem) {
        this.model.itemAdded(agendaItem);
    }

    public void itemRemoved(AgendaEvent agendaEvent, AgendaItem agendaItem) {
        this.model.itemRemoved(agendaItem);
    }

    public void itemHandled(AgendaEvent agendaEvent, AgendaItem agendaItem, HandlerAction handlerAction) {
        this.model.itemHandled(agendaEvent, agendaItem, handlerAction);
    }

    public void newBindings(AgendaEvent agendaEvent, Map map) {
        this.model.fireTableChanged();
    }

    public void editingCanceled(ChangeEvent changeEvent) {
        super.editingCanceled(changeEvent);
        this.model.fireTableChanged();
    }

    public void editingStopped(ChangeEvent changeEvent) {
        super.editingStopped(changeEvent);
        this.model.fireTableChanged();
    }

    public boolean isDummyEditing(int n, int n2) {
        return this.isEditing() && this.getCellEditor().equals(this.mouseableEditor) && n == this.getEditingRow() && n2 == this.getEditingColumn();
    }

    private void listenToNoEditTF() {
        MouseListener[] mouseListenerArray = this.noEditTF.getMouseListeners();
        List<MouseListener> list = Arrays.asList(mouseListenerArray);
        if (list == null || !list.contains(this)) {
            this.noEditTF.addMouseListener(this);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        AgendaItem agendaItem = (AgendaItem)this.model.getRowObject(n);
        if (agendaItem == null) {
            Debug.noteln("Pressed on empty item");
            return;
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            if (this.equals(mouseEvent.getComponent())) {
                ItemPopupMenu itemPopupMenu = new ItemPopupMenu(agendaItem);
                itemPopupMenu.noticeItemState();
                itemPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (this.isEditing()) {
                n = this.getEditingRow();
                n2 = this.getEditingColumn();
                agendaItem = (AgendaItem)this.model.getRowObject(n);
                ItemPopupMenu itemPopupMenu = new ItemPopupMenu(agendaItem);
                URL uRL = this.makeURLFromSelection();
                if (uRL != null) {
                    itemPopupMenu.noteURL(uRL);
                }
                itemPopupMenu.noticeItemState();
                itemPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (agendaItem != null && agendaItem.isNew()) {
                agendaItem.setIsNew(false);
            }
            if (!this.equals(mouseEvent.getComponent())) {
                return;
            }
            TableColumn tableColumn = this.getColumnModel().getColumn(n2);
            int n3 = tableColumn.getModelIndex();
            if (n3 == this.model.PRIORITY_COL) {
                if (this.model.takesPriority(n)) {
                    this.priorityPopup.show(mouseEvent, n, n2);
                    this.priorityPopup.setSelected(Strings.capitalize(agendaItem.getPriority().toString()));
                }
            } else if (n3 == this.model.ACTION_COL) {
                if (this.model.takesAction(n)) {
                    ActionPopupMenu actionPopupMenu = new ActionPopupMenu(this, n, n2);
                    actionPopupMenu.show(mouseEvent, n, n2);
                }
            } else if (!(n3 != this.model.DESCRIPTION_COL && n3 != this.model.COMMENTS_COL || this.isDummyEditing(n, n2))) {
                if (this.isEditing()) {
                    this.removeEditor();
                }
                this.listenToNoEditTF();
                this.editCellAt(n, n2);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private URL makeURLFromSelection() {
        Object object;
        if (!this.isEditing()) {
            return null;
        }
        int n = this.getEditingRow();
        int n2 = this.getEditingColumn();
        Component component = this.getEditorComponent();
        String string = "";
        if (component instanceof JTextComponent) {
            string = ((JTextComponent)component).getSelectedText();
        } else {
            object = this.model.getValueAt(n, n2);
            if (object != null) {
                string = object.toString();
            }
        }
        try {
            object = UIUtil.resourceURL(string);
            if (object == null) {
                object = new URL(string);
            }
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private class ItemPopupMenu
    extends AbstractAgendaItemPopupMenu
    implements ActionListener {
        private URL url;

        ItemPopupMenu(AgendaItem agendaItem) {
            super(AgendaTableViewer.this.ip2, agendaItem);
            this.url = null;
        }

        void showDetails() {
            AgendaTableViewer.this.ensureItemEditor();
            AgendaTableViewer.this.itemEditor.showItem(this.item);
        }

        void fold() {
            IXTreeTableNode iXTreeTableNode = (IXTreeTableNode)AgendaTableViewer.this.model.getTreeNode(this.item);
            int n = AgendaTableViewer.this.model.getObjectRow(this.item);
            AgendaTableViewer.this.model.unexpandNode(iXTreeTableNode, n);
        }

        void unfold() {
            IXTreeTableNode iXTreeTableNode = (IXTreeTableNode)AgendaTableViewer.this.model.getTreeNode(this.item);
            int n = AgendaTableViewer.this.model.getObjectRow(this.item);
            AgendaTableViewer.this.model.expandNode(iXTreeTableNode, n);
        }

        boolean isOpen() {
            IXTreeTableNode iXTreeTableNode = (IXTreeTableNode)AgendaTableViewer.this.model.getTreeNode(this.item);
            return iXTreeTableNode.expanded;
        }

        public void noteURL(URL uRL) {
            this.url = uRL;
            if (uRL != null) {
                this.makeMenuItem("Show URL");
                this.add(this.makeMenuItem("Show URL"));
            }
        }

        private boolean showURL() {
            if (this.url == null) {
                return false;
            }
            try {
                HTMLFrame hTMLFrame = new HTMLFrame(this.url);
                hTMLFrame.setVisible(true);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Show URL")) {
                Debug.noteln("Item popup command", string);
                if (this.showURL()) {
                    return;
                }
                JOptionPane.showMessageDialog(null, "Cannot show URL " + this.url.toString());
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    private class ActionPopupMenu
    extends TablePopupMenu
    implements ActionListener {
        AgendaItem agendaItem;
        String currentAction;

        public ActionPopupMenu(JTable jTable, int n, int n2) {
            Object object;
            super(jTable);
            this.currentAction = "No Action";
            AgendaItemTableModel agendaItemTableModel = (AgendaItemTableModel)jTable.getModel();
            this.agendaItem = (AgendaItem)agendaItemTableModel.getRowObject(n);
            AgendaItemTableModel.TreeAgendaItem treeAgendaItem = (AgendaItemTableModel.TreeAgendaItem)agendaItemTableModel.getTreeNode(this.agendaItem);
            if (treeAgendaItem.handlerAction != null) {
                this.currentAction = treeAgendaItem.handlerAction.getActionDescription();
            }
            ArrayList<HandlerAction> arrayList = new ArrayList<HandlerAction>();
            for (HandlerAction handlerAction : this.agendaItem.getActions()) {
                object = handlerAction.getActionDescription();
                if (arrayList.contains(handlerAction = ((AgendaTableViewer)jTable).findHandlerAction(this.agendaItem, (String)object))) continue;
                arrayList.add(handlerAction);
            }
            for (HandlerAction handlerAction : arrayList) {
                object = handlerAction.isReady() ? this.agendaItem.getStatus().getColor() : Color.gray;
                JMenuItem jMenuItem = this.add(new DefaultColourField(handlerAction.getActionDescription(), (Color)object));
                if (this.currentAction.equals(handlerAction.getActionDescription())) {
                    this.setSelected(jMenuItem);
                }
                jMenuItem.addActionListener(new CatchingActionListener(this));
            }
            this.pack();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            AgendaTableViewer.this.actionSelected(this.agendaItem, string);
        }
    }

    private class PriorityPopupMenu
    extends TablePopupMenu
    implements ActionListener {
        public PriorityPopupMenu() {
            super(AgendaTableViewer.this);
            ArrayList arrayList = new ArrayList(Priority.values());
            Collections.reverse(arrayList);
            for (Priority priority : arrayList) {
                JMenuItem jMenuItem = this.add(new DefaultColourField(Strings.capitalize(priority.toString()), priority.getColor()));
                jMenuItem.addActionListener(new CatchingActionListener(this));
            }
            this.pack();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("Priority popup command", string);
            if (string == null) {
                return;
            }
            AgendaTableViewer.this.model.setPriorityValue(string, this.row, this.column);
        }
    }
}

