/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.IXAgent;
import ix.icore.Priority;
import ix.icore.Report;
import ix.icore.ReportType;
import ix.icore.Status;
import ix.icore.TaskItem;
import ix.icore.Variable;
import ix.icore.YesNo;
import ix.icore.log.HistoryEvent;
import ix.icore.process.PNode;
import ix.iface.util.Reporting;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2ModelManager;
import ix.ip2.ItemHandler;
import ix.ip2.event.AgendaItemEvent;
import ix.ip2.event.AgendaItemListener;
import ix.ip2.log.ItemHandledEvent;
import ix.util.AbstractUndoAction;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.IPC;
import ix.util.Name;
import ix.util.PatternParser;
import ix.util.Strings;
import ix.util.Util;
import ix.util.context.ContextValue;
import ix.util.context.TypedContextValue;
import ix.util.lisp.LList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public abstract class AgendaItem
extends PNode {
    private ContextValue __about;
    protected List actions = new LinkedList();
    protected List reports = new LinkedList();
    protected List listeners = new LinkedList();
    protected HandlerAction handledBy = null;

    public AgendaItem(TaskItem taskItem) {
        this(null, taskItem);
    }

    public AgendaItem(AgendaItem agendaItem, TaskItem taskItem) {
        super(agendaItem);
        this.__about = new TypedContextValue<TaskItem>(TaskItem.class, taskItem);
        if (agendaItem != null && !taskItem.priorityWasSet()) {
            taskItem.setPriority(agendaItem.getPriority());
        }
    }

    public TaskItem getAbout() {
        return (TaskItem)this.__about.get();
    }

    public void setAbout(TaskItem taskItem) {
        this.__about.set(taskItem);
    }

    public LList getPattern() {
        return this.getAbout().getPattern();
    }

    public Set getPatternVars() {
        return this.getAbout().getPatternVars();
    }

    public Set getUnboundVars() {
        Set set = this.getAbout().getUnboundVars();
        if (this.getVarTable() != null) {
            set.addAll(Variable.unboundVarsIn(this.getVarTable().values()));
        }
        return set;
    }

    public void setPattern(LList lList) {
        this.getAbout().setPattern(lList);
    }

    public String getShortDescription() {
        return PatternParser.unparse(this.getPattern());
    }

    public boolean isNew() {
        return this.getAbout().getAnnotation("is new") != null;
    }

    public void setIsNew(boolean bl) {
        Debug.noteln("setIsNew of " + this + " = " + bl);
        if (bl) {
            this.getAbout().setAnnotation("is new", Boolean.TRUE);
        } else {
            this.getAbout().removeAnnotation("is new");
        }
        this.fireAgendaItemEdited();
    }

    public AgendaItem getParent() {
        return (AgendaItem)this.parent;
    }

    public Status getStatus() {
        return this.getAbout().getStatus();
    }

    public void setStatus(Status status) {
        if (this.getStatus() != status) {
            Ip2ModelManager ip2ModelManager;
            if (this.getAbout().getReportBack() == YesNo.YES) {
                this.handleReportBack(status);
            }
            if ((ip2ModelManager = (Ip2ModelManager)this.getModelManager()) != null) {
                ip2ModelManager.saveUndoAction(new UndoSetStatus());
            }
            this.getAbout().setStatus(status);
            super.setStatus(status);
            this.fireStatusChanged();
        }
    }

    public void assignStatus(Status status) {
        this.getAbout().setStatus(status);
        super.assignStatus(status);
        this.fireStatusChanged();
    }

    public Priority getPriority() {
        return this.getAbout().getPriority();
    }

    public void setPriority(Priority priority) {
        Debug.noteln("Changing priority of " + this + " to " + priority);
        ((Ip2ModelManager)this.getModelManager()).saveUndoAction(new UndoSetPriority());
        this.getAbout().setPriority(priority);
        this.firePriorityChanged();
    }

    public String getComments() {
        String string = this.getAbout().getComments();
        return string == null ? "" : string;
    }

    public void setComments(String string) {
        Ip2ModelManager ip2ModelManager = (Ip2ModelManager)this.getModelManager();
        if (ip2ModelManager != null) {
            ip2ModelManager.saveUndoAction(new UndoSetComments());
        }
        this.getAbout().setComments(string);
        this.fireAgendaItemEdited();
    }

    public List getActions() {
        return this.actions;
    }

    public void clearActions() {
        this.actions.clear();
    }

    public boolean wantsActionsFrom(ItemHandler itemHandler) {
        return true;
    }

    public void addAction(HandlerAction handlerAction) {
        Debug.noteln(this + " adding " + handlerAction);
        Debug.expect(!this.hasAction(handlerAction), "Action added twice", handlerAction);
        HandlerAction handlerAction2 = this.findAction(handlerAction.getActionDescription());
        if (handlerAction2 != null) {
            Debug.noteln("Action description not unique", Util.quote(handlerAction.getActionDescription()));
        }
        this.actions.add(handlerAction);
        handlerAction.computeStatus();
        this.fireNewHandlerAction(handlerAction);
    }

    public void insertAction(HandlerAction handlerAction) {
        Debug.noteln(this + " inserting " + handlerAction);
        Debug.expect(!this.hasAction(handlerAction), "Action added twice", handlerAction);
        String string = handlerAction.getActionDescription();
        String string2 = Strings.beforeFirst(" ", string);
        boolean bl = false;
        boolean bl2 = false;
        string2 = string2 + " ";
        ListIterator<HandlerAction> listIterator = this.actions.listIterator();
        while (listIterator.hasNext()) {
            HandlerAction handlerAction2 = (HandlerAction)listIterator.next();
            String string3 = handlerAction2.getActionDescription();
            if (string3.equals(string)) {
                Debug.noteln("Action description not unique", Strings.quote(string3));
                bl = true;
                continue;
            }
            if (string3.startsWith(string2)) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            listIterator.previous();
            listIterator.add(handlerAction);
            Debug.expect(listIterator.next() == handlerAction2);
            bl2 = true;
            break;
        }
        if (!bl2) {
            this.actions.add(handlerAction);
        }
        handlerAction.computeStatus();
        this.fireNewHandlerAction(handlerAction);
    }

    public boolean hasAction(HandlerAction handlerAction) {
        return this.actions.contains(handlerAction);
    }

    public HandlerAction findAction(Class clazz) {
        return (HandlerAction)Collect.findIf(this.actions, Fn.isInstanceOf(clazz));
    }

    public List findAllActions(Class clazz) {
        return (List)Collect.filter(this.actions, Fn.isInstanceOf(clazz));
    }

    public HandlerAction findAction(String string) {
        for (HandlerAction handlerAction : this.actions) {
            if (!handlerAction.getActionDescription().equals(string)) continue;
            return handlerAction;
        }
        return null;
    }

    public boolean actionCanBeTakenNow(HandlerAction handlerAction) {
        return handlerAction.canAlwaysBeTakenNow() || this.getStatus() == Status.POSSIBLE && handlerAction.isReady();
    }

    public HandlerAction getHandledBy() {
        return this.handledBy;
    }

    public void setHandledBy(HandlerAction handlerAction) {
        this.handledBy = handlerAction;
    }

    public String getHowHandled() {
        if (this.getHistory() != null) {
            for (HistoryEvent historyEvent : this.getHistory()) {
                String string;
                if (!(historyEvent instanceof ItemHandledEvent) || (string = ((ItemHandledEvent)historyEvent).getAction()) == null) continue;
                return string;
            }
        }
        return null;
    }

    public List getHistory() {
        return this.getAbout().getHistory();
    }

    public void addHistoryEvent(HistoryEvent historyEvent) {
        Ip2ModelManager ip2ModelManager = (Ip2ModelManager)this.getModelManager();
        if (ip2ModelManager != null) {
            ip2ModelManager.saveUndoAction(new UndoAddHistoryEvent(historyEvent));
        }
        this.getAbout().addHistoryEvent(historyEvent);
    }

    public boolean wantsReport(Report report) {
        Name name = report.getRef();
        return name != null && name.equals(this.getAbout().getId());
    }

    public void addReport(Report report) {
        Debug.expect(this.wantsReport(report), "unwanted report", report);
        Debug.noteln(this + " accepts " + report);
        String string = System.getProperty("line.separator");
        String string2 = this.getComments();
        string2 = string2 + (string2.equals("") || string2.endsWith(string) ? "" : string) + Reporting.reportDescription(report) + string;
        this.setComments(string2);
        this.reports.add(report);
        this.fireNewReport(report);
        this.setStatusBasedOn(report);
    }

    protected void setStatusBasedOn(Report report) {
        Status status = this.getStatus();
        if (status == Status.IMPOSSIBLE) {
            return;
        }
        if (report.isCompletion()) {
            if (report.isSuccess()) {
                this.setStatus(Status.COMPLETE);
            } else {
                Debug.expect(report.isFailure());
                this.setStatus(Status.IMPOSSIBLE);
            }
        } else if (report.isProgress()) {
            this.setStatus(Status.EXECUTING);
        }
    }

    public List getReports() {
        return this.reports;
    }

    protected void handleReportBack(Status status) {
        ReportType reportType;
        Debug.expect(this.getAbout().getReportBack() == YesNo.YES);
        if (status == Status.COMPLETE) {
            reportType = ReportType.SUCCESS;
        } else if (status == Status.IMPOSSIBLE) {
            reportType = ReportType.FAILURE;
        } else {
            return;
        }
        Report report = new Report("done - " + reportType);
        report.setReportType(reportType);
        report.setSenderId(Name.valueOf(IXAgent.getAgent().getAgentIPCName()));
        report.setRef(this.getAbout().getRef());
        IPC.sendObject(this.getAbout().getSenderId().toString(), report);
    }

    public void addItemListener(AgendaItemListener agendaItemListener) {
        if (!this.listeners.contains(agendaItemListener)) {
            this.listeners.add(agendaItemListener);
        }
    }

    public void fireStatusChanged() {
        AgendaItemEvent agendaItemEvent = new AgendaItemEvent(this);
        if (this.listeners != null) {
            for (AgendaItemListener agendaItemListener : this.listeners) {
                agendaItemListener.statusChanged(agendaItemEvent);
            }
        }
    }

    public void firePriorityChanged() {
        AgendaItemEvent agendaItemEvent = new AgendaItemEvent(this);
        for (AgendaItemListener agendaItemListener : this.listeners) {
            agendaItemListener.priorityChanged(agendaItemEvent);
        }
    }

    public void fireHandlerActionsChanged() {
        AgendaItemEvent agendaItemEvent = new AgendaItemEvent(this);
        for (AgendaItemListener agendaItemListener : this.listeners) {
            agendaItemListener.handlerActionsChanged(agendaItemEvent);
        }
    }

    public void fireNewHandlerAction(HandlerAction handlerAction) {
        AgendaItemEvent agendaItemEvent = new AgendaItemEvent(this);
        for (AgendaItemListener agendaItemListener : this.listeners) {
            agendaItemListener.newHandlerAction(agendaItemEvent, handlerAction);
        }
    }

    public void fireNewReport(Report report) {
        AgendaItemEvent agendaItemEvent = new AgendaItemEvent(this);
        for (AgendaItemListener agendaItemListener : this.listeners) {
            agendaItemListener.newReport(agendaItemEvent, report);
        }
    }

    public void fireAgendaItemEdited() {
        AgendaItemEvent agendaItemEvent = new AgendaItemEvent(this);
        Debug.noteln("fireAgendaItemEdited", agendaItemEvent);
        for (AgendaItemListener agendaItemListener : this.listeners) {
            agendaItemListener.agendaItemEdited(agendaItemEvent);
        }
    }

    public String toString() {
        if (this.__about == null) {
            return "Item[about <uninitialized>]";
        }
        return "Item[" + this.getAbout() + "]";
    }

    class UndoAddHistoryEvent
    extends AbstractUndoAction {
        HistoryEvent event;

        UndoAddHistoryEvent(HistoryEvent historyEvent) {
            super("add history event");
            this.event = historyEvent;
        }

        public void undo() {
            List list = AgendaItem.this.getHistory();
            if (!list.remove(this.event)) {
                Debug.noteln("History did not contain", this.event);
            }
            if (list.isEmpty()) {
                AgendaItem.this.getAbout().setHistory(null);
            }
        }
    }

    class UndoSetComments
    extends AbstractUndoAction {
        String saved;

        UndoSetComments() {
            super("set comments");
            this.saved = AgendaItem.this.getAbout().getComments();
        }

        public void undo() {
            AgendaItem.this.getAbout().setComments(this.saved);
            AgendaItem.this.fireAgendaItemEdited();
        }
    }

    class UndoSetPriority
    extends AbstractUndoAction {
        Priority saved;

        UndoSetPriority() {
            super("set priority");
            this.saved = AgendaItem.this.getAbout().getPriority();
        }

        public void undo() {
            AgendaItem.this.getAbout().setPriority(this.saved);
        }
    }

    class UndoSetStatus
    extends AbstractUndoAction {
        Status saved;

        UndoSetStatus() {
            super("set status");
            this.saved = AgendaItem.this.getAbout().getStatus();
        }

        public void undo() {
            AgendaItem.this.getAbout().setStatus(this.saved);
        }
    }
}

