/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.util;

import ix.util.Debug;
import ix.util.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class TranscriptTextPane
extends JTextPane {
    protected boolean foldLongLines = false;
    int excessLengthAllowed = 0;
    String NEWLINE = "\n";

    public TranscriptTextPane() {
        this.setEditable(false);
    }

    public void setFoldLongLines(int n) {
        this.foldLongLines = true;
        this.excessLengthAllowed = n;
    }

    public void append(String string) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.black);
        StyledDocument styledDocument = this.getStyledDocument();
        try {
            styledDocument.insertString(styledDocument.getLength(), string, simpleAttributeSet);
        }
        catch (BadLocationException badLocationException) {
            Debug.displayException(badLocationException);
        }
    }

    public void append(Color color, String string) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, color);
        StyledDocument styledDocument = this.getStyledDocument();
        try {
            styledDocument.insertString(styledDocument.getLength(), string, simpleAttributeSet);
        }
        catch (BadLocationException badLocationException) {
            Debug.displayException(badLocationException);
        }
    }

    public void appendLine(String string) {
        if (this.foldLongLines) {
            int n = 40;
            Debug.noteln("maxLen =", n);
            if (string.length() > n) {
                this.append(Strings.foldLongLine(string, n, "   ") + this.NEWLINE);
                return;
            }
        }
        this.append(string + this.NEWLINE);
    }

    public void appendLine(Color color, String string) {
        if (this.foldLongLines) {
            int n = 40;
            Debug.noteln("maxLen =", n);
            if (string.length() > n) {
                this.append(color, Strings.foldLongLine(string, n, "   ") + this.NEWLINE);
                return;
            }
        }
        this.append(color, string + this.NEWLINE);
    }

    protected double getEffectiveWidth() {
        return this.getSize().getWidth();
    }

    public void appendIndentedLines(int n, String string) {
        List list = Strings.breakIntoLines(string);
        for (String string2 : list) {
            this.appendLine(Strings.repeat(n, " ") + string2);
        }
    }

    public void appendIndentedLines(int n, Color color, String string) {
        List list = Strings.breakIntoLines(string);
        for (String string2 : list) {
            this.appendLine(color, Strings.repeat(n, " ") + string2);
        }
    }

    public static void main(final String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TranscriptTextPane.do_main(stringArray);
            }
        });
    }

    private static void do_main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        final TranscriptTextPane transcriptTextPane = new TranscriptTextPane();
        JTextField jTextField = new JTextField(40){
            {
                super(n);
                this.enableEvents(8L);
            }

            protected void processKeyEvent(KeyEvent keyEvent) {
                int n;
                super.processKeyEvent(keyEvent);
                if (keyEvent.getID() == 402 && ((n = keyEvent.getKeyCode()) == 10 || n == 13)) {
                    String string = this.getText();
                    transcriptTextPane.appendLine(string);
                    this.setText("");
                }
            }
        };
        jFrame.getContentPane().add((Component)new JScrollPane(transcriptTextPane), "Center");
        jFrame.getContentPane().add((Component)jTextField, "South");
        jFrame.setSize(400, 300);
        jFrame.setVisible(true);
    }
}

