/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.util;

import ix.util.Debug;
import ix.util.Strings;
import java.awt.Font;
import java.util.List;
import javax.swing.JTextArea;

public class TranscriptTextArea
extends JTextArea {
    protected boolean foldLongLines = false;
    int excessLengthAllowed = 0;

    public TranscriptTextArea(int n, int n2) {
        super(n, n2);
    }

    public void setFoldLongLines(int n) {
        this.foldLongLines = true;
        this.excessLengthAllowed = n;
        Debug.noteln("Have font", this.getFont());
        Font font = new Font("Monospaced", 0, 11);
        this.setFont(font);
    }

    public void append(String string) {
        super.append(string);
        this.setCaretPosition(this.getText().length());
    }

    public void appendLine(String string) {
        String string2 = System.getProperty("line.separator");
        if (this.foldLongLines) {
            double d = this.getEffectiveWidth();
            double d2 = d / (double)this.getColumnWidth();
            int n = (int)(d2 -= 3.0) + this.excessLengthAllowed;
            Debug.noteln("maxLen =", n);
            if (string.length() > n) {
                this.append(Strings.foldLongLine(string, n, "   ") + string2);
                return;
            }
        }
        this.append(string + string2);
    }

    protected double getEffectiveWidth() {
        return this.getSize().getWidth();
    }

    public void appendIndentedLines(int n, String string) {
        List list = Strings.breakIntoLines(string);
        for (String string2 : list) {
            this.appendLine(Strings.repeat(n, " ") + string2);
        }
    }
}

