/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.util;

import ix.iface.util.CatchingActionListener;
import ix.iface.util.KeyValueTable;
import ix.util.ConsistencyException;
import ix.util.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public abstract class SortingKVTable
extends KeyValueTable {
    public SortingKVTable(String string, String string2) {
        this(null, string, string2);
    }

    public SortingKVTable(Map map, String string, String string2) {
        super(map, string, string2);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.addMouseListener(new KeySortMouseListener());
    }

    protected class SortMenu
    extends JMenu
    implements ActionListener {
        public SortMenu(String string) {
            super(string);
            this.add(this.makeMenuItem("Most Recent Last"));
            this.add(this.makeMenuItem("Most Recent First"));
            this.add(this.makeMenuItem("Lexicographically"));
            this.add(this.makeMenuItem("By Object"));
        }

        protected JMenuItem makeMenuItem(String string) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(CatchingActionListener.listener(this));
            return jMenuItem;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("Sort menu command", string);
            if (string.equals("Most Recent Last")) {
                SortingKVTable.this.setKeySortComparator(new KeyValueTable.MostRecentLastComparator());
            } else if (string.equals("Most Recent First")) {
                SortingKVTable.this.setKeySortComparator(new KeyValueTable.MostRecentFirstComparator());
            } else if (string.equals("Lexicographically")) {
                SortingKVTable.this.setKeySortComparator(new KeyValueTable.LexicographicComparator());
            } else if (string.equals("By Object")) {
                SortingKVTable.this.setKeySortComparator(new KeyValueTable.PatternObjectComparator());
            } else {
                throw new ConsistencyException("Nothing to do for " + string);
            }
        }
    }

    protected class KeySortPopupMenu
    extends JPopupMenu {
        public KeySortPopupMenu() {
            this.add(new SortMenu("Sort"));
        }
    }

    protected class KeySortMouseListener
    extends MouseAdapter {
        KeySortPopupMenu popup;

        public KeySortMouseListener() {
            this.popup = new KeySortPopupMenu();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                TableColumnModel tableColumnModel = SortingKVTable.this.table.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = SortingKVTable.this.table.convertColumnIndexToModel(n);
                Debug.noteln("Table right press in column", n2);
                if (n2 == 0) {
                    this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }
}

