/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.util;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HtmlWriter {
    protected PrintWriter out;
    protected Map defaultAttributes = new HashMap();
    protected List tagStack = new ArrayList(100);

    public HtmlWriter(Writer writer) {
        this.out = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public HtmlWriter(OutputStream outputStream) {
        this(new OutputStreamWriter(outputStream));
    }

    public String getDefaultAttributes(String string) {
        return (String)this.defaultAttributes.get(string);
    }

    public void setDefaultAttributes(String string, String string2) {
        this.defaultAttributes.put(string, string2);
    }

    public void setDefaultAttributes(String string, String[][] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i][0];
            String string3 = stringArray[i][1];
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string2);
            stringBuffer.append("=\"");
            stringBuffer.append(string3);
            stringBuffer.append("\"");
        }
        this.defaultAttributes.put(string, stringBuffer.toString());
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }

    public void newLine() {
        this.out.write("\n");
    }

    public void write(String string) {
        this.out.write(string);
    }

    public List getTagStack() {
        return this.tagStack;
    }

    public int getTagDepth() {
        return this.tagStack.size();
    }

    public void indent(int n) {
        for (int i = 0; i < n; ++i) {
            this.out.write(" ");
        }
    }

    public void tagged(String string, String string2) {
        this.tag(string);
        this.write(string2);
        this.endTag(string);
    }

    public void tagged(String string, String string2, String string3) {
        this.tag(string, string2);
        this.write(string3);
        this.endTag(string);
    }

    public void tag(String string) {
        this.tag(string, this.getDefaultAttributes(string));
    }

    public void tag(String string, String string2) {
        this.write("<");
        this.write(string);
        if (string2 != null) {
            this.write(" ");
            this.write(string2);
        }
        this.write(">");
        this.tagStack.add(string);
    }

    public void tag(String string, String[][] stringArray) {
        this.write("<");
        this.write(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i][0];
            String string3 = stringArray[i][1];
            this.write(" ");
            this.write(string2);
            this.write("=\"");
            this.write(string3);
            this.write("\"");
        }
        this.write(">");
        this.tagStack.add(string);
    }

    public void endTag(String string) {
        if (this.tagStack.isEmpty()) {
            throw new IllegalStateException("Missing <" + string + "> tag.");
        }
        String string2 = (String)this.tagStack.remove(this.tagStack.size() - 1);
        if (!string2.equals(string)) {
            throw new IllegalStateException("Found <" + string2 + "> instead of <" + string + ">.");
        }
        this.write("</");
        this.write(string);
        this.write(">");
    }

    public void end(String string) {
        this.endTag(string);
    }
}

