/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.util;

import ix.util.Debug;
import java.util.Collection;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

public class HtmlTableWalker {
    protected Collection rowItems;
    protected Collection colItems;

    public HtmlTableWalker(Collection collection, Collection collection2) {
        this.rowItems = collection;
        this.colItems = collection2;
    }

    public void walkHTML(HTMLDocument hTMLDocument) {
        Element element = hTMLDocument.getDefaultRootElement();
        Element element2 = this.getChild(element, HTML.Tag.BODY);
        Element element3 = this.getChild(element2, HTML.Tag.TABLE);
        this.walkTable(element3);
    }

    public void walkTable(Element element) {
        Debug.expectSame(HTML.Tag.TABLE, this.getTag(element));
        int n = 1;
        for (Object e : this.rowItems) {
            Element element2 = element.getElement(n);
            this.walkRow(element2, e);
            ++n;
        }
        Debug.expect(n == element.getElementCount(), "too many rows");
    }

    public void walkRow(Element element, Object object) {
        Debug.expectSame(HTML.Tag.TR, this.getTag(element));
        Debug.expectSame(HTML.Tag.TH, this.getTag(element.getElement(0)));
        int n = 1;
        for (Object e : this.colItems) {
            Element element2 = element.getElement(n);
            this.walkTD(element2, object, e);
            ++n;
        }
        Debug.expect(n == element.getElementCount(), "too many columns");
    }

    public void walkTD(Element element, Object object, Object object2) {
        Debug.expectSame(HTML.Tag.TD, this.getTag(element));
    }

    protected HTML.Tag getTag(Element element) {
        return (HTML.Tag)element.getAttributes().getAttribute(StyleConstants.NameAttribute);
    }

    protected Element getChild(Element element, HTML.Tag tag) {
        HTMLDocument hTMLDocument = (HTMLDocument)element.getDocument();
        return hTMLDocument.getElement(element, StyleConstants.NameAttribute, tag);
    }
}

