/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.util;

import ix.iface.util.HtmlWriter;
import ix.util.RethrownException;
import ix.util.Strings;
import java.io.OutputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLDocument;

public class HtmlDescriber {
    protected HtmlWriter out;
    private Segment seg = new Segment();

    public HtmlDescriber(HtmlWriter htmlWriter) {
        this.out = htmlWriter;
    }

    public HtmlDescriber(OutputStream outputStream) {
        this(new HtmlWriter(outputStream));
    }

    public void describe(HTMLDocument hTMLDocument) {
        Element element = hTMLDocument.getDefaultRootElement();
        this.describe(element);
        this.flush();
    }

    public void flush() {
        this.out.flush();
    }

    public void describe(Element element) {
        String string = element.getAttributes().getAttribute(StyleConstants.NameAttribute).toString();
        this.out.indent(this.out.getTagDepth() * 2);
        this.out.tag(string);
        this.out.write("  " + element.getStartOffset() + ".." + element.getEndOffset());
        this.out.newLine();
        if (element.isLeaf()) {
            this.describeElementText(element);
        } else {
            for (int i = 0; i < element.getElementCount(); ++i) {
                Element element2 = element.getElement(i);
                this.describe(element2);
            }
        }
        this.out.indent((this.out.getTagDepth() - 1) * 2);
        this.out.end(string);
        this.out.newLine();
    }

    private void describeElementText(Element element) {
        Document document = element.getDocument();
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        try {
            document.getText(n, n2 - n, this.seg);
        }
        catch (BadLocationException badLocationException) {
            throw new RethrownException(badLocationException);
        }
        this.out.indent(this.out.getTagDepth() * 2 + 1);
        this.out.write(Strings.quote(this.seg.toString()));
        this.out.newLine();
    }
}

