/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui.util;

import ix.icore.domain.Named;
import ix.iface.ui.JObjectMenu;
import ix.iface.util.CatchingActionListener;
import ix.util.Debug;
import ix.util.ListOf;
import ix.util.TypedList;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuListener;

public class UIUtil {
    public static final String lineSeparator = System.getProperty("line.separator");

    public static void notImplemented(Component component, String string) {
        JOptionPane.showMessageDialog(component, string + " is not yet supported.");
    }

    public static void warning(Component component, String string) {
        JOptionPane.showMessageDialog(component, "Warning: " + string);
    }

    public static void addListener(JComponent jComponent, EventListener eventListener) {
        boolean bl = false;
        if (eventListener instanceof ActionListener) {
            bl = UIUtil.addActionListener(jComponent, (ActionListener)eventListener);
        }
        if (!bl && eventListener instanceof MouseListener) {
            jComponent.addMouseListener((MouseListener)eventListener);
        }
    }

    public static boolean addActionListener(JComponent jComponent, ActionListener actionListener) {
        boolean bl = false;
        if (jComponent instanceof AbstractButton) {
            ((AbstractButton)jComponent).addActionListener(actionListener);
            return true;
        }
        if (jComponent instanceof JTextField) {
            ((JTextField)jComponent).addActionListener(actionListener);
            return true;
        }
        if (jComponent instanceof JComboBox) {
            ((JComboBox)jComponent).addActionListener(actionListener);
            return true;
        }
        return false;
    }

    public static void populateMenu(ActionListener actionListener, JMenu jMenu, String string, List list) {
        String string2 = jMenu.getText();
        if (string2 == null || string2.equals("")) {
            UIUtil.populateMenu(actionListener, jMenu, string, string, list);
        } else {
            UIUtil.populateMenu(actionListener, jMenu, string2, string, list);
        }
    }

    public static void populateMenu(ActionListener actionListener, JMenu jMenu, String string, String string2, List list) {
        boolean bl = jMenu.isEnabled();
        jMenu.setEnabled(false);
        jMenu.removeAll();
        if (list != null && !list.isEmpty()) {
            int n = 20;
            int n2 = list.size();
            int n3 = 0;
            Object object = jMenu;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object2;
                if (n3 == n && n2 > 5) {
                    object2 = new JMenu("More");
                    ((JMenu)object).add((JMenuItem)object2);
                    object = object2;
                    n3 = 0;
                }
                object2 = (Named)iterator.next();
                UIUtil.makeMenuItem(actionListener, (JComponent)object, string2, object2.getName());
                --n2;
                ++n3;
            }
            if (string != null && string != "") {
                jMenu.setText(string);
            }
            jMenu.setEnabled(n3 > 0);
        }
    }

    public static void populateMenu(ActionListener actionListener, JObjectMenu jObjectMenu, Object object, String string, List list) {
        jObjectMenu.setObject(object);
        UIUtil.populateMenu(actionListener, jObjectMenu, string, list);
    }

    public static JMenuItem makeMenuItem(ActionListener actionListener, JComponent jComponent, String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string2);
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(new CatchingActionListener(actionListener));
        jComponent.add(jMenuItem);
        return jMenuItem;
    }

    public static String toCapitalised(String string) {
        char c = Character.toUpperCase(string.charAt(0));
        return c + string.substring(1);
    }

    public static String toUncapitalised(String string) {
        char c = Character.toLowerCase(string.charAt(0));
        return c + string.substring(1);
    }

    public static String ensureParenthesized(String string) {
        if (string.startsWith("(") && string.endsWith(")")) {
            return string;
        }
        return "(" + string + ")";
    }

    public static String[] breakStringAtFirst(String string, String string2) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return new String[]{string, ""};
        }
        return new String[]{string.substring(0, n), string.substring(n + string2.length())};
    }

    public static Symbol propertyToSymbol(String string) {
        return Symbol.intern(string);
    }

    public static int propertyToInt(String string) {
        return Integer.parseInt(string);
    }

    public static boolean propertyToBoolean(String string) {
        return new Boolean(string);
    }

    public static String booleanToProperty(boolean bl) {
        return new Boolean(bl).toString();
    }

    public static String symbolToProperty(Symbol symbol) {
        if (symbol == null) {
            return "";
        }
        return symbol.toString();
    }

    public static String intToProperty(int n) {
        return Integer.toString(n);
    }

    public static boolean isEmptyThing(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return "".equals(object);
        }
        if (object instanceof Collection) {
            return 0 == ((Collection)object).size();
        }
        return false;
    }

    public static Field stringToField(Class clazz, String string) throws NoSuchFieldException, IllegalAccessException {
        if (clazz == null) {
            return null;
        }
        return clazz.getField(string);
    }

    public static int findNameField(ArrayList arrayList) {
        int n = arrayList.indexOf("name");
        if (n != -1) {
            return n;
        }
        n = arrayList.indexOf("Name");
        if (n != -1) {
            return n;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = UIUtil.toCapitalised((String)arrayList.get(i));
            if (string.indexOf("NAME") == -1) continue;
            return i;
        }
        return -1;
    }

    public static Object getObjectFieldValue(Object object, String string) {
        if (object == null) {
            Debug.noteln("Util: Cannot get value for a null object.");
            return null;
        }
        try {
            Field field = UIUtil.stringToField(object.getClass(), string);
            return field.get(object);
        }
        catch (Exception exception) {
            Debug.noteln("Cannot get field " + string + " Trying get<Field>");
            String string2 = "get" + UIUtil.toCapitalised(string);
            try {
                Class[] classArray = new Class[]{};
                Object[] objectArray = new Object[]{};
                Method method = object.getClass().getMethod(string2, classArray);
                return method.invoke(object, objectArray);
            }
            catch (Exception exception2) {
                Debug.noteException(exception2);
                return null;
            }
        }
    }

    public static void setObjectFieldValue(Object object, String string, Class clazz, Object object2) {
        if (object == null) {
            Debug.noteln("Util: Cannot set value for a null object.");
            return;
        }
        if (string == null) {
            Debug.noteln("Util: Cannot set value for a null field.");
            return;
        }
        try {
            Field field = UIUtil.stringToField(object.getClass(), string);
            field.set(object, object2);
        }
        catch (Exception exception) {
            Debug.noteln("Cannot set field " + string + " Trying setField method");
            String string2 = "set" + UIUtil.toCapitalised(string);
            try {
                Class[] classArray = new Class[]{clazz};
                Method method = object.getClass().getMethod(string2, classArray);
                if (object2 == null) {
                    object2 = clazz.newInstance();
                } else {
                    Debug.noteln("Value is  ", object2.toString());
                }
                Object[] objectArray = new Object[]{object2};
                method.invoke(object, objectArray);
            }
            catch (Exception exception2) {
                Debug.noteln("setObjectFieldValue: problem with field " + string);
                Debug.note(" method " + string2);
                Debug.noteln(", value class" + object2.getClass().getName());
                Debug.noteException(exception2);
                return;
            }
        }
    }

    public static boolean isEmptyValue(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return (String)object == "";
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        return false;
    }

    public static String show(Collection collection) {
        String string = "";
        if (collection == null) {
            return string;
        }
        for (Object e : collection) {
            String string2 = e == null ? "null" : e.toString();
            string = string + string2 + " ";
        }
        return string.trim();
    }

    public static String showClass(Collection collection) {
        String string = "";
        if (collection == null) {
            return string;
        }
        for (Object e : collection) {
            String string2 = e == null ? "null" : e.getClass().toString();
            if (string2 == null) {
                string2 = "null";
            }
            string = string + string2 + " ";
        }
        return string.trim();
    }

    public static String show(Enumeration enumeration) {
        String string = "";
        if (enumeration == null) {
            return string;
        }
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            string = string + e.toString() + " ";
        }
        return string.trim();
    }

    public static String listToDisplay(Collection collection) {
        return UIUtil.show(collection);
    }

    public static String listToText(Collection collection) {
        String string = "";
        if (collection == null) {
            return string;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2 = "";
            Object e = iterator.next();
            string2 = Collection.class.isInstance(e) ? UIUtil.show((Collection)e) : e.toString();
            string = string + string2 + lineSeparator;
        }
        return string.trim();
    }

    public static String[] listToTextArray(Collection collection) {
        if (collection == null) {
            return new String[0];
        }
        String[] stringArray = new String[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = "";
            Object e = iterator.next();
            string = Collection.class.isInstance(e) ? UIUtil.show((Collection)e) : e.toString();
            stringArray[n++] = string.trim();
        }
        return stringArray;
    }

    public static String fieldsToNames(Field[] fieldArray) {
        String string = "";
        for (int i = 0; i < fieldArray.length; ++i) {
            string = string + fieldArray[i].getName() + " ";
        }
        return string;
    }

    public static LList removeDuplicates(LList lList) {
        if (lList == null || lList.isEmpty() || lList.isNull()) {
            return lList;
        }
        Object object = lList.car();
        LList lList2 = UIUtil.remove(object, lList.cdr());
        LList lList3 = UIUtil.removeDuplicates(lList2);
        return new Cons(object, lList3);
    }

    public static Collection without(Collection collection, Collection collection2) {
        AbstractCollection abstractCollection;
        if (collection == null || collection.isEmpty() || collection2 == null || collection2.isEmpty()) {
            return collection;
        }
        try {
            abstractCollection = (HashSet)collection.getClass().newInstance();
        }
        catch (Exception exception) {
            Debug.noteln("UIUtil without: cannot create class", collection.getClass());
            Debug.noteln(" using ArrayList or HashSet instead");
            abstractCollection = collection instanceof Set ? new HashSet() : new ArrayList();
        }
        for (Object e : collection) {
            if (e == null) continue;
            boolean bl = false;
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext() && !bl) {
                Object e2 = iterator.next();
                if (!e.equals(e2)) continue;
                bl = true;
            }
            if (bl) continue;
            abstractCollection.add(e);
        }
        return abstractCollection;
    }

    public static LList remove(Object object, LList lList) {
        if (lList == null || lList.isEmpty() || lList.isNull()) {
            return lList;
        }
        Object object2 = lList.car();
        if (object.equals(object2)) {
            return UIUtil.remove(object, lList.cdr());
        }
        return new Cons(object2, UIUtil.remove(object, lList.cdr()));
    }

    public static List getFlatValues(Map map) {
        LinkedList linkedList;
        ArrayList arrayList = new ArrayList();
        if (map != null && (linkedList = new LinkedList(map.values())) != null) {
            for (Object e : linkedList) {
                if (e instanceof Collection) {
                    arrayList.addAll((Collection)e);
                    continue;
                }
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    public static List enumerationToList(Enumeration enumeration) {
        LinkedList linkedList = new LinkedList();
        if (enumeration == null) {
            return linkedList;
        }
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            linkedList.add(e);
        }
        Debug.noteln("UIUtil: got list from enumeration");
        return linkedList;
    }

    public static TypedList newTypedList(Class clazz, Collection collection) {
        try {
            Class clazz2 = ListOf.findImplementationClass(clazz, LinkedList.class);
            TypedList typedList = (TypedList)clazz2.newInstance();
            typedList.addAll(collection);
            return typedList;
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            return null;
        }
    }

    public static TypedList newTypedList(Class clazz, Object[] objectArray) {
        return UIUtil.newTypedList(clazz, Arrays.asList(objectArray));
    }

    public static TypedList newTypedList(Class clazz, Object object) {
        if (object.getClass().isArray()) {
            return UIUtil.newTypedList(clazz, Arrays.asList((Object[])object));
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(object);
        return UIUtil.newTypedList(clazz, linkedList);
    }

    public static URL resourceURL(String string) {
        String string2 = "resources/html/" + string;
        URL uRL = UIUtil.class.getClassLoader().getResource(string2);
        return uRL;
    }

    public static void listenToCB(JComboBox jComboBox, PopupMenuListener popupMenuListener) {
        try {
            jComboBox.getClass().getMethod("addPopupMenuListener", PopupMenuListener.class).invoke((Object)jComboBox, popupMenuListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class ToStringComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            try {
                String string = object.toString();
                String string2 = object2.toString();
                return string.compareTo(string2);
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                return 0;
            }
        }
    }
}

