/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui.tree;

import ix.icore.domain.Named;
import ix.icore.event.ObjectChangeEvent;
import ix.iface.ui.EditableObject;
import ix.iface.ui.event.DataChangeListener;
import ix.iface.ui.tree.IXTreeNode;
import ix.iface.ui.tree.IXTrees;
import ix.iface.ui.util.UIUtil;
import ix.iview.domain.UIObject;
import ix.util.Debug;
import ix.util.lisp.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class EditableTreeModel
extends DefaultTreeModel
implements DataChangeListener {
    HashMap nodeMap = new HashMap();
    HashSet userNodes = new HashSet();
    boolean isUpdating = false;

    public EditableTreeModel() {
        this(null);
    }

    public EditableTreeModel(IXTreeNode iXTreeNode) {
        super(iXTreeNode);
        this.nodeMap = new HashMap();
    }

    public EditableTreeModel(IXTreeNode iXTreeNode, HashSet hashSet, HashMap hashMap) {
        super(iXTreeNode);
        this.nodeMap = hashMap;
        this.userNodes = hashSet;
    }

    public boolean isUserRoot(Object object) {
        IXTreeNode iXTreeNode = (IXTreeNode)this.getRoot();
        if (iXTreeNode == null) {
            return false;
        }
        if (object == null) {
            return false;
        }
        return object.equals(iXTreeNode.getUserObject());
    }

    public Object getUserRoot() {
        IXTreeNode iXTreeNode = (IXTreeNode)this.getRoot();
        if (iXTreeNode == null) {
            return null;
        }
        return iXTreeNode.getUserObject();
    }

    public void setUserRoot(Object object) {
        List list = this.getUserParents(object);
        if (list != null && list.size() > 0) {
            Debug.noteln("EdTM: trying to set root to node with parents", object);
            return;
        }
        IXTreeNode iXTreeNode = this.ensureIXTreeNode(object, "");
        this.setRoot(iXTreeNode);
    }

    public boolean hasTreeNode(Object object, String string) {
        return this.getTreeNode(object, string) != null;
    }

    public IXTreeNode getTreeNode(Object object, String string) {
        if (object == null) {
            return null;
        }
        Object v = this.nodeMap.get(object);
        if (v == null) {
            return null;
        }
        Collection collection = (Collection)v;
        if (collection.isEmpty()) {
            return null;
        }
        for (IXTreeNode iXTreeNode : collection) {
            Named named;
            String string2;
            if (string == null || string == "") {
                return iXTreeNode;
            }
            TreeNode treeNode = iXTreeNode.getParent();
            if (treeNode == null || !(treeNode instanceof IXTreeNode) || !string.equals(string2 = (named = (Named)((IXTreeNode)treeNode).getUserObject()).getName())) continue;
            return iXTreeNode;
        }
        return null;
    }

    public IXTreeNode ensureIXTreeNode(Object object, String string) {
        if (object == null) {
            return null;
        }
        IXTreeNode iXTreeNode = this.getTreeNode(object, string);
        if (iXTreeNode == null) {
            IXTreeNode iXTreeNode2 = this.newIXTreeNode(object);
            ((EditableObject)object).addDataChangeListener(this);
            this.addNodeMap(object, iXTreeNode2);
            return iXTreeNode2;
        }
        return iXTreeNode;
    }

    private void addNodeMap(Object object, IXTreeNode iXTreeNode) {
        Object v = this.nodeMap.get(object);
        HashSet<IXTreeNode> hashSet = null;
        hashSet = v != null ? (HashSet<IXTreeNode>)v : new HashSet<IXTreeNode>();
        hashSet.add(iXTreeNode);
        this.nodeMap.put(object, hashSet);
    }

    public IXTreeNode makeIXTreeNode(Object object, String string) {
        if (object == null) {
            return null;
        }
        IXTreeNode iXTreeNode = this.newIXTreeNode(object);
        ((EditableObject)object).addDataChangeListener(this);
        if ((string == null || string == "") && this.root == null) {
            this.setRoot(iXTreeNode);
        }
        this.addNodeMap(object, iXTreeNode);
        return iXTreeNode;
    }

    public void ensureMapEntry(IXTreeNode iXTreeNode, String string) {
        Named named;
        HashSet<IXTreeNode> hashSet;
        if (iXTreeNode == null) {
            return;
        }
        if (string == null || string == "") {
            string = "Root";
        }
        if ((hashSet = (HashSet<IXTreeNode>)this.nodeMap.get(named = (Named)iXTreeNode.getUserObject())) == null) {
            hashSet = new HashSet<IXTreeNode>();
            this.nodeMap.put(named, hashSet);
        }
        hashSet.add(iXTreeNode);
    }

    public void buildTree(Object object, String string) {
        if (object == null) {
            return;
        }
        if (object instanceof IXTreeNode) {
            IXTreeNode iXTreeNode = (IXTreeNode)object;
            Object object2 = iXTreeNode.getUserObject();
            if (!this.userNodes.contains(object2)) {
                this.userNodes.add(object2);
                this.ensureMapEntry(iXTreeNode, string);
                this.buildSubTree(iXTreeNode);
            }
        } else {
            Object object3 = object;
            if (!this.userNodes.contains(object3)) {
                IXTreeNode iXTreeNode;
                this.userNodes.add(object3);
                if (!this.hasTreeNode(object3, string) && (iXTreeNode = this.makeIXTreeNode(object3, string)) != null) {
                    this.buildSubTree(iXTreeNode);
                    this.fireNodeAdded(iXTreeNode);
                }
            }
        }
    }

    protected void buildSubTree(IXTreeNode iXTreeNode) {
        if (iXTreeNode == null) {
            return;
        }
        Object object = iXTreeNode.getUserObject();
        List list = this.getUserChildren(object);
        String string = ((Named)object).getName();
        for (Object e : list) {
            IXTreeNode iXTreeNode2;
            if (this.hasTreeNode(e, string) || (iXTreeNode2 = this.makeIXTreeNode(e, string)) == null) continue;
            this.insertNodeInto(iXTreeNode2, iXTreeNode, this.getChildCount(iXTreeNode));
            this.fireNodeAdded(iXTreeNode2);
            this.buildTree(iXTreeNode2, string);
        }
    }

    public IXTreeNode findStringTreeNode(String string) {
        Object object = this.findUserNode(string);
        return this.getTreeNode(object, null);
    }

    public IXTreeNode findTreeNode(Object object) {
        return this.getTreeNode(object, null);
    }

    private Collection findAllTreeNodes(Object object) {
        return this.findTreeNodes(object);
    }

    protected Collection findTreeNodes(Object object) {
        return (Collection)this.nodeMap.get(object);
    }

    public void startUpdate() {
        this.isUpdating = true;
    }

    public void stopUpdate() {
        this.isUpdating = false;
        this.reload();
    }

    public void ignoreUpdate() {
        this.isUpdating = false;
    }

    public void setRoot(IXTreeNode iXTreeNode) {
        this.startUpdate();
        this.clearModel();
        super.setRoot(iXTreeNode);
        this.ensureMapEntry(iXTreeNode, "");
        this.buildTree(iXTreeNode, "");
        this.stopUpdate();
    }

    public IXTreeNode newTreeChild(UIObject uIObject) {
        return this.newTreeChild(this.findTreeNode(uIObject));
    }

    public IXTreeNode newTreeChild(IXTreeNode iXTreeNode) {
        Object object = this.makeUserObject(" ");
        UIObject uIObject = (UIObject)iXTreeNode.getUserObject();
        this.addUserParent(object, uIObject);
        IXTreeNode iXTreeNode2 = this.makeIXTreeNode(object, uIObject.getName());
        if (iXTreeNode2 != null) {
            this.insertNodeInto(iXTreeNode2, iXTreeNode, this.getChildCount(iXTreeNode));
        }
        return iXTreeNode2;
    }

    public IXTreeNode addTreeParent(IXTreeNode iXTreeNode, UIObject uIObject) {
        return this.addTreeParent(iXTreeNode, this.findTreeNode(uIObject));
    }

    public IXTreeNode addTreeParent(IXTreeNode iXTreeNode, IXTreeNode iXTreeNode2) {
        Object object = iXTreeNode2.getUserObject();
        UIObject uIObject = (UIObject)iXTreeNode.getUserObject();
        this.addUserParent(object, uIObject);
        IXTreeNode iXTreeNode3 = this.makeIXTreeNode(object, uIObject.getName());
        if (iXTreeNode3 != null) {
            this.insertNodeInto(iXTreeNode3, iXTreeNode, this.getChildCount(iXTreeNode));
        }
        return iXTreeNode3;
    }

    public void reloadData() {
        this.clearModel();
        List list = this.findUserObjects();
        IXTrees.setupTreeModel(this, list);
    }

    public void clearModel() {
        this.userNodes.clear();
        this.nodeMap.clear();
    }

    public abstract IXTreeNode newIXTreeNode(Object var1);

    public abstract boolean isOwnUserObject(Object var1);

    public abstract List findUserObjects();

    public abstract Object findUserNode(String var1);

    public abstract Object makeUserObject(String var1);

    public abstract Object makeUserObject(String var1, List var2);

    public abstract List getUserChildren(Object var1);

    public abstract void addUserChild(Object var1, Object var2);

    public abstract void removeUserChild(Object var1, Object var2);

    public abstract List getUserParents(Object var1);

    public abstract void addUserParent(Object var1, Object var2);

    public abstract void removeUserParent(Object var1, Object var2);

    public void reload() {
        this.reload(this.root);
    }

    public void reload(IXTreeNode iXTreeNode) {
        if (iXTreeNode != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(iXTreeNode), null, null);
        }
    }

    public void dataChanged(EditableObject editableObject, String string, Object object, Object object2) {
        this.userNodeChanged(new ObjectChangeEvent(this, editableObject, string, object, object2));
    }

    private boolean handleNewParents(ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getField().equals("superClassNames")) {
            List list = (List)objectChangeEvent.getOldValue();
            if (list == null || list.size() == 0) {
                this.userNodeAdded(objectChangeEvent.getObject(), objectChangeEvent);
                return true;
            }
            List list2 = this.getUserParents(objectChangeEvent.getObject());
            if (list2.size() > list.size()) {
                if (list2 == null) {
                    return true;
                }
                ArrayList<Named> arrayList = new ArrayList<Named>();
                for (Named named : list2) {
                    Symbol symbol = Symbol.intern(named.getName());
                    if (list.contains(symbol)) continue;
                    arrayList.add(named);
                }
                this.addChildToParents(objectChangeEvent.getObject(), arrayList);
                return true;
            }
            UIUtil.without(list, list2);
            for (Named named : list2) {
                Symbol symbol = Symbol.intern(named.getName());
                list.remove(symbol);
            }
            this.removeChildFromParents(objectChangeEvent.getObject(), list);
            return true;
        }
        return false;
    }

    public void userNodeChanged(ObjectChangeEvent objectChangeEvent) {
        Collection collection;
        Object object = objectChangeEvent.getObject();
        if (this.isOwnUserObject(object) && !this.handleNewParents(objectChangeEvent) && (collection = this.findAllTreeNodes(object)) != null) {
            for (IXTreeNode iXTreeNode : collection) {
                this.fireNodeChanged(iXTreeNode, objectChangeEvent);
            }
        }
    }

    public void userNodeRemoved(Object object) {
        Collection collection;
        if (this.isOwnUserObject(object) && (collection = this.findAllTreeNodes(object)) != null) {
            ArrayList arrayList = new ArrayList(this.findAllTreeNodes(object));
            for (IXTreeNode iXTreeNode : arrayList) {
                if (iXTreeNode == null) continue;
                this.removeNodeFromMaps(iXTreeNode);
                TreeNode treeNode = iXTreeNode.getParent();
                if (treeNode == null) continue;
                this.removeNodeFromParent(iXTreeNode);
            }
        }
        this.userNodes.remove(object);
    }

    private void removeNodeFromMaps(IXTreeNode iXTreeNode) {
        Object object = iXTreeNode.getUserObject();
        Collection collection = (Collection)this.nodeMap.get(object);
        collection.remove(iXTreeNode);
    }

    public void userNodeAdded(Object object, ObjectChangeEvent objectChangeEvent) {
        if (this.isOwnUserObject(object)) {
            List list = this.getUserParents(object);
            this.addChildToParents(object, list);
        }
    }

    private void removeChildFromParents(Object object, List list) {
        for (Object e : list) {
            String string;
            IXTreeNode iXTreeNode;
            if (e == null || (iXTreeNode = this.getTreeNode(object, string = e.toString())) == null) continue;
            this.removeNodeFromParent(iXTreeNode);
        }
    }

    private boolean addChildToParents(Object object, List list) {
        if (list == null) {
            if (this.root == null) {
                this.setUserRoot(object);
                return true;
            }
            return false;
        }
        for (Object e : list) {
            String string;
            IXTreeNode iXTreeNode;
            if (e == null || (iXTreeNode = this.makeIXTreeNode(object, string = ((Named)e).getName())) == null) continue;
            Collection collection = this.findTreeNodes(e);
            if (collection == null) {
                return false;
            }
            for (IXTreeNode iXTreeNode2 : collection) {
                if (iXTreeNode2 == null) continue;
                this.insertNodeInto(iXTreeNode, iXTreeNode2, this.getChildCount(iXTreeNode2));
                this.fireNodeAdded(iXTreeNode);
                this.buildTree(iXTreeNode, string);
            }
        }
        return true;
    }

    public void insertNodeInto(MutableTreeNode mutableTreeNode, MutableTreeNode mutableTreeNode2, int n) {
        super.insertNodeInto(mutableTreeNode, mutableTreeNode2, n);
    }

    public IXTreeNode getTreeParent(IXTreeNode iXTreeNode) {
        TreeNode[] treeNodeArray = this.getPathToRoot(iXTreeNode);
        if (treeNodeArray == null) {
            Debug.noteln("EdTM: no path for finding parent", iXTreeNode);
            return null;
        }
        int n = treeNodeArray.length;
        if (n == 1) {
            return null;
        }
        return (IXTreeNode)treeNodeArray[n - 2];
    }

    public String printSubTree() {
        return this.printSubTree(this.getUserRoot());
    }

    public String printSubTree(Object object) {
        if (object == null) {
            return "";
        }
        Collection collection = this.findAllTreeNodes(object);
        if (collection == null) {
            return object.toString() + " has no tree node";
        }
        String string = "";
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            string = string + this.printSubTreeNode(iterator.next());
        }
        return string;
    }

    private String printSubTreeNode(Object object) {
        if (object == null) {
            return "null";
        }
        String string = object.toString();
        if (object instanceof IXTreeNode) {
            IXTreeNode iXTreeNode = (IXTreeNode)object;
            string = string + " " + iXTreeNode.getChildCount() + " children. ";
            for (int i = 0; i < iXTreeNode.getChildCount(); ++i) {
                string = string + ",  " + this.printSubTreeNode(iXTreeNode.getChildAt(i));
            }
        } else {
            string = string + " of class " + object.getClass();
        }
        return string;
    }

    public void fireNodeChanged(IXTreeNode iXTreeNode, ObjectChangeEvent objectChangeEvent) {
        if (this.isUpdating) {
            return;
        }
        if (iXTreeNode == null) {
            return;
        }
        IXTreeNode iXTreeNode2 = this.getTreeParent(iXTreeNode);
        if (iXTreeNode2 != null) {
            int[] nArray = new int[]{iXTreeNode2.getIndex(iXTreeNode)};
            Object[] objectArray = new Object[]{iXTreeNode};
            this.fireTreeNodesChanged(iXTreeNode2, iXTreeNode2.getPath(), nArray, objectArray);
        } else {
            this.reload();
        }
    }

    public void fireNodeAdded(IXTreeNode iXTreeNode) {
        if (this.isUpdating) {
            return;
        }
        if (iXTreeNode == null) {
            return;
        }
        IXTreeNode iXTreeNode2 = this.getTreeParent(iXTreeNode);
        if (iXTreeNode2 != null) {
            int[] nArray = new int[]{iXTreeNode2.getIndex(iXTreeNode)};
            Object[] objectArray = new Object[]{iXTreeNode};
            this.fireTreeNodesInserted(iXTreeNode2, iXTreeNode2.getPath(), nArray, objectArray);
        } else {
            this.reload();
        }
    }

    public void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        if (this.isUpdating) {
            return;
        }
        super.fireTreeNodesInserted(object, objectArray, nArray, objectArray2);
    }

    public void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        if (this.isUpdating) {
            return;
        }
        super.fireTreeNodesChanged(object, objectArray, nArray, objectArray2);
    }
}

