/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui.table;

import ix.iface.ui.FourField;
import ix.iface.ui.IconRenderer;
import ix.iface.ui.NDRenderer;
import ix.iface.ui.table.AbstractIXTableModel;
import ix.iface.ui.table.TableMouseListener;
import ix.util.ConsistencyException;
import ix.util.Debug;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class IXTable
extends JTable
implements MouseListener,
FocusListener {
    public Hashtable columnWidths;
    public Hashtable columnFixedWidths;
    public int defaultWidth = 50;
    public int minWidth = 15;
    private JPopupMenu popup;
    private ArrayList tmListeners = new ArrayList();
    protected LinkedList columnToolTips = new LinkedList();

    public IXTable() {
        this.setShowGrid(true);
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.getSelectionModel().setSelectionMode(0);
        NDRenderer nDRenderer = new NDRenderer(false);
        nDRenderer.setToolTipText("Click for choices");
        IconRenderer iconRenderer = new IconRenderer(false);
        this.setDefaultRenderer(FourField.class, nDRenderer);
        this.setDefaultRenderer(Icon.class, iconRenderer);
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowHeight(this.getRowHeight() + 5);
    }

    public IXTable(AbstractTableModel abstractTableModel) {
        this();
        this.setModel(abstractTableModel);
    }

    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        if (tableModel instanceof TableMouseListener) {
            this.addTableMouseListener((TableMouseListener)((Object)tableModel));
        }
        this.setWidths();
        this.adjustWidths();
    }

    public void setSelectedRow(int n) {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        if (n >= 0 && n < this.getModel().getRowCount()) {
            listSelectionModel.clearSelection();
            listSelectionModel.setSelectionInterval(n, n);
        }
    }

    public void setSelectedObject(Object object) {
        if (AbstractIXTableModel.class.isInstance(this.getModel())) {
            int n = ((AbstractIXTableModel)this.getModel()).getObjectRow(object);
            if (n != -1) {
                this.setSelectedRow(n);
            } else {
                this.clearSelection();
            }
        }
    }

    public Object getSelectedObject() {
        if (AbstractIXTableModel.class.isInstance(this.getModel())) {
            int n = this.getSelectedRow();
            try {
                return ((AbstractIXTableModel)this.getModel()).getRowObject(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public TableColumn findColumn(String string) {
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            if (!tableColumn.getHeaderValue().equals(string)) continue;
            return tableColumn;
        }
        throw new ConsistencyException("Can't find column", string);
    }

    public void setToolTipTexts(String[] stringArray) {
        this.columnToolTips = new LinkedList<String>(Arrays.asList(stringArray));
    }

    public void setToolTipTexts(Collection collection) {
        this.columnToolTips = new LinkedList(collection);
    }

    public void setToolTipText(int n, String string) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n2 = tableColumnModel.getColumnCount();
        if (n >= n2) {
            Debug.noteln("IXTable: max columns is", n2 + " not " + n);
            return;
        }
        if (this.columnToolTips == null) {
            this.columnToolTips = new LinkedList();
        }
        if (this.columnToolTips.size() <= n2) {
            for (int i = this.columnToolTips.size() + 1; i <= n2; ++i) {
                this.columnToolTips.add(null);
            }
        }
        this.columnToolTips.set(n, string);
    }

    protected JTableHeader createDefaultTableHeader() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        return new JTableHeader(tableColumnModel){

            public String getToolTipText(MouseEvent mouseEvent) {
                try {
                    Point point = mouseEvent.getPoint();
                    int n = this.columnModel.getColumnIndexAtX(point.x);
                    int n2 = this.columnModel.getColumn(n).getModelIndex();
                    return (String)IXTable.this.columnToolTips.get(n2);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        };
    }

    public boolean hasPopup() {
        return this.popup != null;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public void setPopup(JPopupMenu jPopupMenu) {
        this.popup = jPopupMenu;
    }

    public void setWidths() {
        this.setDefaultWidths();
    }

    public void setDefaultWidths() {
        if (this.columnWidths == null) {
            this.columnWidths = new Hashtable();
        }
        if (this.columnFixedWidths == null) {
            this.columnFixedWidths = new Hashtable();
        }
        this.setWidth(String.class, new Integer(100));
        this.setWidth(FourField.class, new Integer(100));
        this.setFixedWidth(Boolean.class, new Integer(15));
        this.setFixedWidth(Icon.class, new Integer(15));
        this.setFixedWidth(ImageIcon.class, new Integer(15));
        this.setFixedWidth(Character.class, new Integer(15));
    }

    public void setWidth(Class clazz, Integer n) {
        this.columnWidths.remove(clazz);
        this.columnWidths.put(clazz, n);
    }

    public void setWidth(String string, Integer n) {
        this.columnWidths.remove(string);
        this.columnWidths.put(string, n);
    }

    public void setFixedWidth(Class clazz, Integer n) {
        this.columnWidths.remove(clazz);
        this.columnFixedWidths.remove(clazz);
        this.columnFixedWidths.put(clazz, n);
    }

    public void setFixedWidth(String string, Integer n) {
        this.columnWidths.remove(string);
        this.columnFixedWidths.remove(string);
        this.columnFixedWidths.put(string, n);
    }

    public void adjustWidths() {
        if (this.columnWidths == null) {
            return;
        }
        boolean bl = false;
        TableModel tableModel = this.getModel();
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            String string = tableModel.getColumnName(i);
            Object object = this.columnFixedWidths.get(string);
            if (object != null) {
                bl = true;
            } else {
                object = this.columnWidths.get(string);
                if (object != null) {
                    bl = false;
                } else {
                    Class<?> clazz = tableModel.getColumnClass(i);
                    object = this.columnFixedWidths.get(clazz);
                    if (object != null) {
                        bl = true;
                    } else {
                        bl = false;
                        object = this.columnWidths.get(clazz);
                        if (object == null) {
                            object = new Integer(this.defaultWidth);
                        }
                    }
                }
            }
            int n = (Integer)object;
            tableColumn.setPreferredWidth(n);
            if (!bl) continue;
            tableColumn.setMinWidth(n);
            tableColumn.setMaxWidth(n);
            tableColumn.setResizable(false);
        }
    }

    public boolean isMarkable() {
        try {
            return ((AbstractIXTableModel)this.getModel()).isMarkable();
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            return false;
        }
    }

    public void markRow(int n) {
        if (this.isMarkable()) {
            ((AbstractIXTableModel)this.getModel()).markRow(n);
        }
    }

    public void unmarkRow(int n) {
        if (this.isMarkable()) {
            ((AbstractIXTableModel)this.getModel()).unmarkRow(n);
        }
    }

    public void clearMarks() {
        if (this.isMarkable()) {
            ((AbstractIXTableModel)this.getModel()).clearMarks();
        }
    }

    public void markAll() {
        if (this.isMarkable()) {
            ((AbstractIXTableModel)this.getModel()).markAll();
        }
    }

    public boolean isMarked(int n) {
        if (this.isMarkable()) {
            return ((AbstractIXTableModel)this.getModel()).isMarked(n);
        }
        return false;
    }

    public boolean isMarkedEmpty() {
        if (this.isMarkable()) {
            return ((AbstractIXTableModel)this.getModel()).isMarkedEmpty();
        }
        return false;
    }

    public void addTableMouseListener(TableMouseListener tableMouseListener) {
        this.tmListeners.add(tableMouseListener);
    }

    public void removeTableMouseListener(TableMouseListener tableMouseListener) {
        while (this.tmListeners.contains(tableMouseListener)) {
            this.tmListeners.remove(this.tmListeners.indexOf(tableMouseListener));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.getSelectedRow();
        int n2 = this.getSelectedColumn();
        Iterator iterator = this.tmListeners.iterator();
        while (iterator.hasNext()) {
            ((TableMouseListener)iterator.next()).cellClicked(mouseEvent, n, n2);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.isEditing()) {
            TableCellEditor tableCellEditor = this.getCellEditor();
            Component component = null;
            if (tableCellEditor instanceof DefaultCellEditor) {
                component = ((DefaultCellEditor)tableCellEditor).getComponent();
            } else {
                Debug.noteln("IXT: odd table cell editor of class", tableCellEditor.getClass());
            }
            Component component2 = focusEvent.getOppositeComponent();
            if (!(component2 == null || component2.equals(this) || component2.equals(tableCellEditor) || component2.equals(component))) {
                tableCellEditor.stopCellEditing();
            }
        }
    }
}

