/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.EditableObject;
import ix.iface.ui.JConstraintListener;
import ix.util.Debug;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public abstract class JConstraintEditor
extends JDialog
implements MouseListener {
    protected JPanel mainPanel = new JPanel();
    protected Component bitsBox;
    protected Component butBox;
    protected JComponent focusComponent;
    protected JButton okBut = new JButton("Ok");
    protected JButton cancelBut = new JButton("Cancel");
    protected JButton moreBut = new JButton("Add More");
    protected JLabel label;
    protected ArrayList constraintListeners = new ArrayList();
    public Object currentObject;
    protected Object original;

    public JConstraintEditor(Frame frame, String string, String string2) {
        super(frame, string, true);
        GridBagConstraints gridBagConstraints;
        this.setSize(405, 175);
        this.mainPanel.setLayout(new GridBagLayout());
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.setBounds(0, 0, 500, 300);
        this.bitsBox = this.makeBits();
        this.butBox = this.makeButs();
        if (!string2.equals("")) {
            this.label = new JLabel(string2);
            gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 18, 0, new Insets(0, 4, 0, 0), 0, 0);
            this.mainPanel.add((Component)this.label, gridBagConstraints);
        }
        this.mainPanel.add(new JSeparator());
        gridBagConstraints = new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 18, 1, new Insets(0, 4, 0, 0), 0, 0);
        this.mainPanel.add(this.bitsBox, gridBagConstraints);
        this.mainPanel.add(new JSeparator());
        gridBagConstraints = new GridBagConstraints(0, 2, 0, 1, 0.0, 0.0, 16, 2, new Insets(0, 4, 0, 0), 0, 0);
        this.mainPanel.add(this.butBox, gridBagConstraints);
        this.focusComponent = this.getFocusComponent();
        this.invalidate();
        this.pack();
        this.setVisible(false);
    }

    public JConstraintEditor(Frame frame, String string) {
        this(frame, "Constraint Editor", string);
    }

    public JConstraintEditor(Frame frame, String string, String string2, Object object) {
        this(frame, string, string2);
        try {
            this.setObject(object);
        }
        catch (NullPointerException nullPointerException) {
            Debug.noteException(nullPointerException);
            JOptionPane.showMessageDialog(this, "Constraint Editor: Cannot set object");
            return;
        }
        this.pack();
        this.setVisible(true);
    }

    private Component makeButs() {
        this.okBut.addMouseListener(this);
        this.cancelBut.addMouseListener(this);
        this.moreBut.addMouseListener(this);
        Box box = new Box(0);
        box.add(Box.createGlue());
        box.add(this.okBut);
        box.add(this.cancelBut);
        box.add(this.moreBut);
        box.add(Box.createGlue());
        return box;
    }

    public boolean isEditing() {
        return this.original != null;
    }

    public void setMessage(String string) {
        if (this.label != null) {
            this.label.setText(string);
        }
    }

    public void setObject(Object object) throws NullPointerException {
        if (object == null) {
            return;
        }
        this.currentObject = object;
        this.initFromObject();
    }

    public Object getObject() {
        return this.currentObject;
    }

    protected JComponent getFocusComponent() {
        return null;
    }

    protected void focus() {
        if (this.getFocusComponent() != null) {
            this.getFocusComponent().requestFocus();
        }
    }

    protected List getPreviousList(Object object) {
        Debug.noteln("Dummy getPreviousList(Constraint c) in JCE");
        return null;
    }

    protected String getField(Object object) {
        Debug.noteln("Dummy getField(Constraint c) in JCE");
        return "";
    }

    public void setOriginal(Object object) {
        this.original = object;
    }

    public void start(Point point) {
        this.setLocation(point);
        this.start();
    }

    public void start() {
        this.setVisible(true);
    }

    public void start(Object object, Point point) {
        this.setLocation(point);
        this.start(object);
    }

    public void start(Object object) {
        try {
            this.original = null;
            this.setObject(object);
            this.start();
        }
        catch (NullPointerException nullPointerException) {
            Debug.noteException(nullPointerException);
            JOptionPane.showMessageDialog(this, "Constraint Editor: Cannot start (" + nullPointerException.getMessage() + ")");
        }
    }

    public void start(Object object, Object object2, Point point) {
        this.setLocation(point);
        this.start(object, object2);
    }

    public void start(Object object, Object object2) {
        try {
            this.original = null;
            this.setObject(object);
            this.setOriginal(object2);
            this.setFromObject(object2);
            this.moreBut.setEnabled(false);
            this.start();
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            JOptionPane.showMessageDialog(this, "Constraint Editor: Cannot start (" + exception.getMessage() + ")");
        }
    }

    public void addConstraintListener(JConstraintListener jConstraintListener) {
        this.constraintListeners.add(jConstraintListener);
    }

    public void removeConstraintListener(JConstraintListener jConstraintListener) {
        while (this.constraintListeners.contains(jConstraintListener)) {
            this.constraintListeners.remove(jConstraintListener);
        }
    }

    protected boolean processConstraint() {
        Object object = this.collectConstraint();
        if (object == null) {
            return false;
        }
        Object object2 = this.noteNewValue(object);
        if (this.constraintListeners == null) {
            return true;
        }
        for (int i = 0; i < this.constraintListeners.size(); ++i) {
            JConstraintListener jConstraintListener = (JConstraintListener)this.constraintListeners.get(i);
            jConstraintListener.gotConstraint(this, this.currentObject, object2);
        }
        return true;
    }

    protected Object noteNewValue(Object object) {
        List list = this.getPreviousList(object);
        if (this.isEditing()) {
            int n;
            if (list != null && (n = list.indexOf(this.original)) >= 0) {
                list.remove(n);
                list.add(n, object);
                ((EditableObject)this.currentObject).setValue(this.getField(object), list);
            }
            return null;
        }
        if (list != null) {
            list.add(list.size(), object);
            ((EditableObject)this.currentObject).setValue(this.getField(object), list);
        }
        return object;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.cancelBut) {
            this.closeEditor();
            return;
        }
        if (mouseEvent.getSource() == this.okBut) {
            if (this.processConstraint()) {
                this.closeEditor();
            }
            return;
        }
        if (mouseEvent.getSource() == this.moreBut) {
            this.processConstraint();
            this.moreInitFromObject();
            return;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void closeEditor() {
        this.setVisible(false);
        this.original = null;
        this.currentObject = null;
        this.moreBut.setEnabled(true);
    }

    public void moreInitFromObject() {
        this.initFromObject();
    }

    protected abstract Component makeBits();

    protected abstract void initFromObject();

    protected abstract void setFromObject(Object var1);

    protected abstract Object collectConstraint();
}

