/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.util.UIUtil;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class IXButPanel
extends JPanel {
    public boolean groupFlag;
    public ButtonGroup group;
    public HashSet buttons = new HashSet();
    public int orientation = 1;

    public IXButPanel() {
        this(1);
    }

    public IXButPanel(int n) {
        if (n != 1 && n != 0) {
            n = 1;
        }
        this.setLayout(new BoxLayout(this, n));
        this.orientation = n;
    }

    public IXButPanel(EventListener eventListener, int n, Object[] objectArray) {
        this(n);
        int n2 = objectArray == null ? 0 : objectArray.length;
        for (int i = 0; i < n2; ++i) {
            AbstractButton abstractButton = this.addButton(eventListener, objectArray[i]);
        }
        this.invalidate();
    }

    public IXButPanel(EventListener eventListener, Object[] objectArray) {
        this(eventListener, 1, objectArray);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public AbstractButton addButton(EventListener eventListener, Object object) {
        AbstractButton abstractButton = object.getClass() == String.class ? new JButton((String)object) : (AbstractButton)object;
        if (abstractButton.getActionCommand() == "") {
            abstractButton.setActionCommand(abstractButton.getText());
        }
        Dimension dimension = abstractButton.getPreferredSize();
        double d = dimension.getHeight();
        dimension.setSize(79.0, d);
        abstractButton.setMinimumSize(dimension);
        UIUtil.addListener(abstractButton, eventListener);
        this.add(abstractButton);
        this.buttons.add(abstractButton);
        if (this.groupFlag) {
            this.group.add(abstractButton);
        }
        return abstractButton;
    }

    public void addListener(EventListener eventListener) {
        for (JComponent jComponent : this.buttons) {
            UIUtil.addListener(jComponent, eventListener);
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (this.buttons == null) {
            return;
        }
        for (AbstractButton abstractButton : this.buttons) {
            abstractButton.addMouseListener(mouseListener);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.buttons == null) {
            return;
        }
        for (AbstractButton abstractButton : this.buttons) {
            abstractButton.addActionListener(actionListener);
        }
    }

    public String getSelectionCommand() {
        if (this.groupFlag) {
            return this.group.getSelection().getActionCommand();
        }
        return "";
    }

    public void setButtonGroup(boolean bl) {
        this.groupFlag = bl;
        if (bl) {
            if (this.group == null) {
                this.group = new ButtonGroup();
            }
            this.fillButtonGroup();
        } else {
            this.group = null;
        }
    }

    public boolean isButtonGroup() {
        return this.groupFlag;
    }

    public ButtonGroup getButtonGroup() {
        return this.group;
    }

    protected void fillButtonGroup() {
        Iterator iterator = this.buttons.iterator();
        while (iterator.hasNext()) {
            this.group.add((AbstractButton)iterator.next());
        }
    }

    public void setEnabled(boolean bl) {
        for (AbstractButton abstractButton : this.buttons) {
            abstractButton.setEnabled(bl);
        }
    }
}

