/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.icore.event.ObjectChangeEvent;
import ix.iface.ui.AbstractEditorPanel;
import ix.iface.ui.EditableObject;
import ix.iface.ui.IFormModel;
import ix.iface.ui.IXEditorPanel;
import ix.iface.ui.IXRenderer;
import ix.iface.ui.ListEditorPanel;
import ix.iface.ui.ThingEditorPanel;
import ix.iface.ui.event.FormDataListener;
import ix.iface.ui.event.FormModelListener;
import ix.iface.ui.util.UIUtil;
import ix.util.Debug;
import ix.util.TypedList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class IFormPanel
extends JPanel
implements MouseListener,
FormModelListener {
    protected IFormModel model;
    protected HashMap nameBits = new HashMap();
    protected HashMap displayBits = new HashMap();
    protected HashMap fieldRenderers = new HashMap();
    protected HashSet simpleFields = new HashSet();
    protected HashSet listeners = new HashSet();
    protected Container parent;

    public IFormPanel() {
        super(new GridBagLayout());
        this.setRenderers();
    }

    public IFormPanel(IFormModel iFormModel) {
        super(new GridBagLayout());
        this.setModel(iFormModel);
        this.setRenderers();
    }

    public IFormPanel(IFormModel iFormModel, FormDataListener formDataListener) {
        super(new GridBagLayout());
        this.setModel(iFormModel, formDataListener);
        this.setRenderers();
    }

    public void setModel(IFormModel iFormModel, FormDataListener formDataListener) {
        this.setModel(iFormModel);
        this.model.addDataListener(formDataListener);
    }

    public void setModel(IFormModel iFormModel) {
        IFormModel iFormModel2 = this.model;
        this.model = iFormModel;
        if (iFormModel2 != null && this.model != null) {
            Iterator iterator = iFormModel2.getModelListeners().iterator();
            while (iterator.hasNext()) {
                this.model.addModelListener((FormModelListener)iterator.next());
            }
            iterator = iFormModel2.getDataListeners().iterator();
            while (iterator.hasNext()) {
                this.model.addDataListener((FormDataListener)iterator.next());
            }
        }
        this.ensurePanelBits(iFormModel);
        this.displayModelData();
        iFormModel.addModelListener(this);
    }

    public IFormModel getModel() {
        return this.model;
    }

    public void setRenderer(String string, IXRenderer iXRenderer) {
        this.fieldRenderers.put(string, iXRenderer);
        IXEditorPanel iXEditorPanel = this.getFieldBit(string);
        if (iXEditorPanel != null) {
            iXEditorPanel.setRenderer(iXRenderer);
        }
    }

    public boolean isListField(String string) {
        Class clazz = this.model.getFieldClass(string);
        return List.class.isAssignableFrom(clazz);
    }

    public void setSimpleField(String string) {
        this.simpleFields.add(new String(string));
    }

    public void unsetSimpleField(String string) {
        this.simpleFields.remove(new String(string));
    }

    public boolean isSimpleField(String string) {
        return this.simpleFields.contains(new String(string));
    }

    public void ensurePanelBits(IFormModel iFormModel) {
        if (iFormModel == null) {
            return;
        }
        this.model = iFormModel;
        iFormModel.startUpdate();
        Dimension dimension = this.getSize();
        if (!this.checkNameBits()) {
            this.makeNameBits();
        }
        if (!this.checkDisplayBits()) {
            this.makeDisplayBits();
        }
        this.setSize(dimension);
        iFormModel.ignoreUpdate();
    }

    private boolean checkNameBits() {
        return this.checkBits(this.model.getNameFields(), this.nameBits);
    }

    private boolean checkDisplayBits() {
        return this.checkBits(this.model.getDisplayFields(), this.displayBits);
    }

    private boolean checkBits(List list, HashMap hashMap) {
        if (list == null && hashMap == null) {
            return true;
        }
        if (list == null && hashMap.size() == 0) {
            return true;
        }
        if (list.size() == 0 && hashMap == null) {
            return true;
        }
        if (list == null || hashMap == null) {
            return false;
        }
        if (hashMap.size() != list.size()) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (hashMap.containsKey((String)iterator.next())) continue;
            return false;
        }
        return true;
    }

    private void makeNameBits() {
        IFormPanel.clearBits(this.nameBits);
        List list = this.model.getNameFields();
        if (list.isEmpty()) {
            return;
        }
        int n = 0;
        for (String string : list) {
            this.makeNameBit(string, n);
            ++n;
        }
    }

    private void makeNameBit(final String string, int n) {
        JTextField jTextField = new JTextField();
        ThingEditorPanel thingEditorPanel = new ThingEditorPanel((EventListener)this, this.model.getFieldName(string), jTextField);
        jTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                IFormPanel.this.saveFieldData(string);
            }
        });
        this.nameBits.put(string, thingEditorPanel);
        this.addNameBit(string, thingEditorPanel, n);
    }

    private void makeDisplayBits() {
        IFormPanel.clearBits(this.displayBits);
        int n = this.model.getNameFields().size();
        List list = this.model.getDisplayFields();
        if (list.isEmpty()) {
            return;
        }
        int n2 = 1;
        for (String string : list) {
            IXEditorPanel iXEditorPanel = this.makeDisplayBit(string);
            IXRenderer iXRenderer = (IXRenderer)this.fieldRenderers.get(string);
            if (iXRenderer != null) {
                iXEditorPanel.setRenderer(iXRenderer);
            }
            this.displayBits.put(string, iXEditorPanel);
            this.addDisplayBit(string, (JPanel)((Object)iXEditorPanel), n2, n);
            ++n2;
        }
    }

    private void addRenderer(String string, IXEditorPanel iXEditorPanel) {
        IXRenderer iXRenderer = (IXRenderer)this.fieldRenderers.get(string);
        if (iXRenderer != null) {
            iXEditorPanel.setRenderer(iXRenderer);
        }
    }

    protected static void clearBits(HashMap hashMap) {
        Collection collection = hashMap.values();
        if (collection.isEmpty()) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((JComponent)iterator.next()).setVisible(false);
        }
        hashMap.clear();
    }

    private void addNameBit(String string, JComponent jComponent, int n) {
        Insets insets = new Insets(4, 0, 4, 0);
        double d = this.model.getFieldWeight(string);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(n, 0, 1, 1, d, 0.0, 11, 2, insets, 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
    }

    private void addDisplayBit(String string, JComponent jComponent, int n, int n2) {
        Insets insets = new Insets(4, 0, 4, 0);
        double d = this.model.getFieldWeight(string);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n, n2, 1, 1.0, d, 17, 1, insets, 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
    }

    protected IXEditorPanel makeDisplayBit(final String string) {
        AbstractEditorPanel abstractEditorPanel;
        String string2 = this.model.getFieldName(string);
        Class clazz = this.model.getFieldClass(string);
        if (Number.class.isAssignableFrom(clazz) || Symbol.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz)) {
            JTextField jTextField = new JTextField();
            abstractEditorPanel = new ThingEditorPanel((EventListener)this, string2, jTextField);
            jTextField.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    IFormPanel.this.saveFieldData(string);
                }
            });
        } else if ((Collection.class.isAssignableFrom(clazz) || Array.class.isAssignableFrom(clazz)) && !this.isSimpleField(string)) {
            String[] stringArray = new String[]{"Add", "Edit", "Delete"};
            JList jList = new JList();
            jList.setVisibleRowCount(3);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add(jList);
            abstractEditorPanel = new ListEditorPanel((EventListener)this, string2, jScrollPane, stringArray);
        } else {
            JScrollPane jScrollPane = new JScrollPane();
            JTextArea jTextArea = new JTextArea();
            jTextArea.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    IFormPanel.this.saveFieldData(string);
                }
            });
            jScrollPane.getViewport().add(jTextArea);
            abstractEditorPanel = new ThingEditorPanel((EventListener)this, string2, jScrollPane);
        }
        abstractEditorPanel.setEnabled(this.model.isEditable(string));
        return abstractEditorPanel;
    }

    public void displayModelData() {
        if (this.model == null) {
            return;
        }
        this.clearFields();
        if (this.model.getObject() == null) {
            return;
        }
        Iterator iterator = this.getAllFields();
        while (iterator.hasNext()) {
            this.displayFieldData((String)iterator.next());
        }
    }

    public void displayFieldData(String string) {
        this.clearField(string);
        Object object = this.model.getValue(string);
        if (object == null) {
            return;
        }
        this.setFieldData(string, object);
    }

    public void setFieldData(String string, Object object) {
        IXEditorPanel iXEditorPanel = this.getFieldBit(string);
        if (iXEditorPanel != null) {
            Object object2 = this.renderValue(string, object);
            iXEditorPanel.setData(object2);
            ((JComponent)((Object)iXEditorPanel)).paintImmediately(((JComponent)((Object)iXEditorPanel)).getBounds());
        }
    }

    public void clearFields() {
        Iterator iterator = this.getAllFields();
        while (iterator.hasNext()) {
            this.clearField((String)iterator.next());
        }
    }

    public void clearField(String string) {
        IXEditorPanel iXEditorPanel = this.getFieldBit(string);
        if (iXEditorPanel == null) {
            return;
        }
        iXEditorPanel.removeData();
    }

    protected Object renderValue(String string, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof AbstractCollection) {
            return ((AbstractCollection)object).toArray();
        }
        return object;
    }

    protected Object deRenderValue(String string, Object object) {
        Class<?> clazz;
        if (object == null) {
            if (this.isListField(string)) {
                return Lisp.NIL;
            }
            return null;
        }
        Class clazz2 = this.model.getFieldClass(string);
        if (clazz2.isAssignableFrom(clazz = object.getClass())) {
            return object;
        }
        if (clazz.isArray()) {
            try {
                if (TypedList.class.isAssignableFrom(clazz2)) {
                    return UIUtil.newTypedList(clazz2, object);
                }
                if (Collection.class.isAssignableFrom(clazz2)) {
                    Collection collection = (Collection)clazz2.newInstance();
                    collection.addAll(Arrays.asList((Object[])object));
                    return collection;
                }
            }
            catch (Exception exception) {
                Debug.noteln("deRenderValue: caught problem with field " + string);
                Debug.noteln("Data is of type " + object.getClass());
                Debug.noteException(exception);
                return object;
            }
        }
        return object;
    }

    protected void setRenderers() {
    }

    public IXEditorPanel getFieldBit(String string) {
        IXEditorPanel iXEditorPanel = (IXEditorPanel)this.nameBits.get(string);
        if (iXEditorPanel == null) {
            iXEditorPanel = (IXEditorPanel)this.displayBits.get(string);
        }
        return iXEditorPanel;
    }

    public Object getFieldData(String string) {
        IXEditorPanel iXEditorPanel = this.getFieldBit(string);
        if (iXEditorPanel == null) {
            return null;
        }
        return iXEditorPanel.getData();
    }

    public void saveFieldData(String string) {
        Object object = this.getFieldData(string);
        Object object2 = this.deRenderValue(string, object);
        this.model.setValue(string, object2);
    }

    public void saveToObject() {
        EditableObject editableObject = this.model.getObject();
        LListCollector lListCollector = new LListCollector(this.model.getNameFields());
        lListCollector.addAll(this.model.getDisplayFields());
        for (String string : lListCollector) {
            Object object = this.getFieldData(string);
            Object object2 = this.deRenderValue(string, object);
            this.model.setValue(string, object2);
        }
    }

    public void saveToObject(EditableObject editableObject) {
        LListCollector lListCollector = new LListCollector(this.model.getNameFields());
        lListCollector.addAll(this.model.getDisplayFields());
        for (String string : lListCollector) {
            Object object = this.getFieldData(string);
            Object object2 = this.deRenderValue(string, object);
            this.model.setValue(editableObject, string, object2);
        }
    }

    private Iterator getAllFields() {
        LListCollector lListCollector = new LListCollector(this.model.getNameFields());
        lListCollector.addAll(this.model.getDisplayFields());
        return lListCollector.iterator();
    }

    public void clear() {
        this.model.clearData();
    }

    public void formModelChanged(String string, ObjectChangeEvent objectChangeEvent) {
        if (string.equals("object") || string.equals("allFields")) {
            this.displayModelData();
        } else if (string.equals("fieldNames")) {
            List list = this.model.getNameFields();
            this.updateNames(list, this.nameBits);
            list = this.model.getDisplayFields();
            this.updateNames(list, this.displayBits);
        } else if (string.equals("Field")) {
            String string2 = objectChangeEvent.getField();
            this.displayFieldData(string2);
        } else {
            this.model.startUpdate();
            this.setModel(this.model);
            this.model.ignoreUpdate();
        }
    }

    public void updateNames(List list, HashMap hashMap) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (String string : list) {
            String string2 = this.model.getFieldName(string);
            if (string2 == null) continue;
            IXEditorPanel iXEditorPanel = (IXEditorPanel)hashMap.get(string);
            if (iXEditorPanel == null) {
                Debug.noteln("Cannot find bit for " + string2);
                continue;
            }
            iXEditorPanel.setLabel(string2);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (MouseListener mouseListener : this.listeners) {
            mouseListener.mouseClicked(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (MouseListener mouseListener : this.listeners) {
            mouseListener.mouseEntered(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (MouseListener mouseListener : this.listeners) {
            mouseListener.mouseExited(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (MouseListener mouseListener : this.listeners) {
            mouseListener.mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (MouseListener mouseListener : this.listeners) {
            mouseListener.mouseReleased(mouseEvent);
        }
    }

    public void addFormMouseListener(MouseListener mouseListener) {
        if (mouseListener != null) {
            this.listeners.add(mouseListener);
        }
    }
}

