/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.icore.event.ObjectChangeEvent;
import ix.iface.ui.EditableObject;
import ix.iface.ui.IFormModel;
import ix.iface.ui.event.DataChangeListener;
import ix.iface.ui.event.FormDataListener;
import ix.iface.ui.event.FormModelListener;
import ix.iface.ui.util.UIUtil;
import ix.util.Debug;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractIFormModel
implements IFormModel,
DataChangeListener {
    protected List nameFields = Lisp.NIL;
    protected List displayFields = Lisp.NIL;
    protected HashMap fieldNames = new HashMap();
    protected HashMap fieldClasses = new HashMap();
    protected EditableObject baseObject;
    protected Class baseObjectClass;
    protected HashSet listeners = new HashSet();
    protected HashSet dataListeners = new HashSet();
    protected boolean isUpdating = false;
    protected boolean settingData = false;

    public AbstractIFormModel(Class clazz) {
        this.baseObjectClass = clazz;
        this.setFields();
    }

    public AbstractIFormModel(EditableObject editableObject) {
        this(editableObject.getClass());
        this.baseObject = editableObject;
        editableObject.addDataChangeListener(this);
    }

    public void clearData() {
        this.setObject(null);
    }

    public String getFieldName(String string) {
        return (String)this.fieldNames.get(string);
    }

    public Class getFieldClass(String string) {
        return (Class)this.fieldClasses.get(string);
    }

    public double getFieldWeight(String string) {
        return 1.0;
    }

    public void setNameFields(List list) {
        this.nameFields = list;
        this.fieldNames.clear();
        this.fieldClasses.clear();
        this.deriveNames();
        this.deriveClasses();
        this.fireModelChanged("nameFields");
    }

    public void setNameFields(String[] stringArray) {
        LListCollector lListCollector = new LListCollector(Arrays.asList(stringArray));
        this.setNameFields(lListCollector);
    }

    public void setDisplayFields(List list) {
        this.displayFields = list;
        this.fieldNames.clear();
        this.fieldClasses.clear();
        this.deriveNames();
        this.deriveClasses();
        this.fireModelChanged("displayFields");
    }

    public void setDisplayFields(String[] stringArray) {
        LListCollector lListCollector = new LListCollector(Arrays.asList(stringArray));
        this.setDisplayFields(lListCollector);
    }

    public List getNameFields() {
        return this.nameFields;
    }

    public List getNameNames() {
        return this.getFieldNames(this.nameFields);
    }

    public List getNameClasses() {
        return this.getFieldClasses(this.nameFields);
    }

    public List getDisplayFields() {
        return this.displayFields;
    }

    public List getDisplayNames() {
        return this.getFieldNames(this.displayFields);
    }

    public List getDisplayClasses() {
        return this.getFieldClasses(this.displayFields);
    }

    public void setObjectClass(Class clazz) {
        if (this.baseObjectClass.equals(clazz)) {
            return;
        }
        if (this.baseObjectClass != null) {
            this.clearFields();
        }
        this.baseObjectClass = clazz;
        this.setFields();
    }

    public Class getObjectClass() {
        if (this.baseObjectClass == null && this.baseObject != null) {
            this.baseObjectClass = this.baseObject.getClass();
        }
        return this.baseObjectClass;
    }

    public void setObject(EditableObject editableObject) {
        EditableObject editableObject2 = this.baseObject;
        boolean bl = false;
        if (editableObject != null && !editableObject.getClass().equals(this.baseObjectClass)) {
            this.setObjectClass(editableObject.getClass());
            bl = true;
        }
        if (!(editableObject == null && this.baseObject == null || editableObject != null && editableObject.equals(this.baseObject))) {
            bl = true;
        }
        this.baseObject = editableObject;
        if (editableObject2 != null) {
            editableObject2.removeDataChangeListener(this);
        }
        if (editableObject != null) {
            editableObject.addDataChangeListener(this);
        }
        if (bl) {
            this.fireModelChanged("object");
        } else if (this.baseObject != null) {
            this.fireModelChanged("allFields");
        }
    }

    public EditableObject getObject() {
        return this.baseObject;
    }

    public Object getValue(String string) {
        return UIUtil.getObjectFieldValue(this.baseObject, string);
    }

    public Object getValue(EditableObject editableObject, String string) {
        return UIUtil.getObjectFieldValue(editableObject, string);
    }

    public void setValue(String string, Object object) {
        this.settingData = true;
        Object object2 = this.getValue(this.baseObject, string);
        if (this.baseObject == null) {
            Debug.noteln("AIFormModel: Trying to set value for null object");
            return;
        }
        if (this.baseObject.sameValue(string, object2, object)) {
            return;
        }
        if (this.setValue(this.baseObject, string, object)) {
            this.fireDataChanged(string, this.baseObject, object2, object);
        }
        this.settingData = false;
    }

    public boolean setValue(EditableObject editableObject, String string, Object object) {
        return editableObject.setValue(string, object);
    }

    public Field stringToField(String string) throws NoSuchFieldException, IllegalAccessException {
        return UIUtil.stringToField(this.getObjectClass(), string);
    }

    public void setFields() {
        if (this.baseObjectClass == null) {
            Debug.noteln("Cannot set fields for a null base object class.");
            return;
        }
        this.isUpdating = true;
        if (this.nameFields.isEmpty()) {
            this.nameFields = this.deriveNameFields();
        }
        if (this.displayFields.isEmpty()) {
            this.displayFields = this.deriveDisplayFields();
        }
        LListCollector lListCollector = new LListCollector(this.nameFields);
        lListCollector.addAll(this.displayFields);
        if (this.fieldNames.isEmpty()) {
            this.deriveNames(lListCollector);
        }
        if (this.fieldClasses.isEmpty()) {
            this.deriveClasses(lListCollector);
        }
        this.isUpdating = false;
        this.fireModelChanged("allFields");
    }

    private void clearFields() {
        this.nameFields = Lisp.NIL;
        this.displayFields = Lisp.NIL;
        this.fieldNames.clear();
        this.fieldClasses.clear();
        if (this.baseObject != null) {
            this.baseObject.removeDataChangeListener(this);
        }
        this.baseObject = null;
    }

    protected List lookupFieldNames(List list) {
        return AbstractIFormModel.lookupFieldMaps(list, this.fieldNames);
    }

    protected List lookupFieldClasses(List list) {
        return AbstractIFormModel.lookupFieldMaps(list, this.fieldClasses);
    }

    public boolean isFieldShowing(String string) {
        return this.fieldNames.containsKey(string);
    }

    private static List lookupFieldMaps(List list, HashMap hashMap) {
        if (list.isEmpty()) {
            return Lisp.NIL;
        }
        LListCollector lListCollector = new LListCollector();
        for (String string : list) {
            lListCollector.addElement(hashMap.get(string));
        }
        return lListCollector;
    }

    private List getFieldNames(List list) {
        return this.lookupFieldNames(list);
    }

    private List getFieldClasses(List list) {
        return this.lookupFieldClasses(list);
    }

    protected void deriveNames() {
        LListCollector lListCollector = new LListCollector(this.nameFields);
        lListCollector.addAll(this.displayFields);
        this.deriveNames(lListCollector);
    }

    protected void deriveClasses() {
        LListCollector lListCollector = new LListCollector(this.nameFields);
        lListCollector.addAll(this.displayFields);
        this.deriveClasses(lListCollector);
    }

    protected abstract void deriveNames(List var1);

    protected abstract void deriveClasses(List var1);

    protected abstract List deriveNameFields();

    protected abstract List deriveDisplayFields();

    public static Collection addIfField(Collection collection, Class clazz, String string) {
        try {
            Field field = clazz.getField(string);
            collection.add(string);
            return collection;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return collection;
        }
    }

    public boolean isEditable(String string) {
        return true;
    }

    public void startUpdate() {
        this.isUpdating = true;
    }

    public void endUpdate() {
        this.isUpdating = false;
        this.fireModelChanged("allFields");
    }

    public void ignoreUpdate() {
        this.isUpdating = false;
    }

    public void fireModelChanged(String string, ObjectChangeEvent objectChangeEvent) {
        if (this.isUpdating) {
            return;
        }
        for (FormModelListener formModelListener : this.listeners) {
            formModelListener.formModelChanged(string, objectChangeEvent);
        }
    }

    public void fireModelChanged(String string) {
        if (this.isUpdating) {
            return;
        }
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectChangeEvent objectChangeEvent = new ObjectChangeEvent(this, this.getObject());
        for (FormModelListener formModelListener : this.listeners) {
            formModelListener.formModelChanged(string, objectChangeEvent);
        }
    }

    public void fireDataChanged(String string, Object object, Object object2, Object object3) {
        ObjectChangeEvent objectChangeEvent = new ObjectChangeEvent(this, object, string, object2, object3);
        this.fireModelChanged("Field " + string);
        if (this.isUpdating) {
            return;
        }
        for (FormDataListener formDataListener : this.dataListeners) {
            formDataListener.formDataChanged(objectChangeEvent);
        }
    }

    public void dataChanged(ObjectChangeEvent objectChangeEvent) {
        if (this.settingData) {
            return;
        }
        if (objectChangeEvent.getObject() == null) {
            return;
        }
        if (objectChangeEvent.getObject() == this.baseObject) {
            this.fireModelChanged("Field", objectChangeEvent);
        } else {
            Debug.noteln("AbIFM: Form Model is listening to the wrong object!", objectChangeEvent.getObject().toString());
            new Throwable().printStackTrace();
        }
    }

    public void dataChanged(EditableObject editableObject, String string, Object object, Object object2) {
        if (this.settingData) {
            return;
        }
        if (editableObject == null) {
            return;
        }
        if (editableObject == this.baseObject) {
            this.fireModelChanged("Field " + string);
        } else {
            Debug.noteln("AbIFM: Form Model is listening to the wrong object!", editableObject.toString());
            new Throwable().printStackTrace();
        }
    }

    public void addModelListener(FormModelListener formModelListener) {
        this.listeners.remove(formModelListener);
        this.listeners.add(formModelListener);
    }

    public void addDataListener(FormDataListener formDataListener) {
        this.dataListeners.remove(formDataListener);
        this.dataListeners.add(formDataListener);
    }

    public HashSet getModelListeners() {
        return this.listeners;
    }

    public HashSet getDataListeners() {
        return this.dataListeners;
    }
}

