/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.IXButPanel;
import ix.iface.ui.IXEditorPanel;
import ix.iface.ui.util.UIUtil;
import ix.util.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;

public abstract class AbstractEditorPanel
extends JPanel
implements IXEditorPanel {
    public boolean isBordered = false;
    public IXButPanel butPanel;
    public JLabel nameLabel;
    public TitledBorder border;
    public JComponent itemComponent;

    public AbstractEditorPanel() {
        super(new GridBagLayout());
        this.makePanel();
    }

    public AbstractEditorPanel(boolean bl) {
        super(new GridBagLayout());
        this.isBordered = bl;
        this.makePanel();
    }

    public AbstractEditorPanel(EventListener eventListener, boolean bl, String string, JComponent jComponent) {
        this(bl);
        this.makePanelComponent(eventListener, jComponent);
        this.setLabel(string);
        this.setName(string);
    }

    public AbstractEditorPanel(EventListener eventListener, String string, JComponent jComponent) {
        this();
        this.makePanelComponent(eventListener, jComponent);
        this.setLabel(string);
        this.setName(string);
    }

    public AbstractEditorPanel(EventListener eventListener, String string, String[] stringArray) {
        this();
        this.setLabel(string);
        this.makeButtons(eventListener, stringArray);
    }

    public AbstractEditorPanel(EventListener eventListener, boolean bl, String string, JComponent jComponent, String[] stringArray) {
        this(eventListener, bl, string, jComponent);
        this.makeButtons(eventListener, stringArray);
    }

    public AbstractEditorPanel(EventListener eventListener, String string, JComponent jComponent, String[] stringArray) {
        this(eventListener, string, jComponent);
        this.makeButtons(eventListener, stringArray);
    }

    private void makePanel() {
        if (this.isBordered) {
            this.border = BorderFactory.createTitledBorder("some label");
            this.setBorder(this.border);
        } else {
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 0, new Insets(0, 4, 0, 0), 0, 0);
            this.nameLabel = new JLabel("some label");
            this.add((Component)this.nameLabel, gridBagConstraints);
        }
    }

    protected void makePanelComponent(EventListener eventListener, JComponent jComponent) {
        JComponent jComponent2;
        GridBagConstraints gridBagConstraints;
        boolean bl = false;
        int n = 1;
        if (JTextField.class.isInstance(jComponent)) {
            bl = true;
            n = 2;
        } else if (JCheckBox.class.isInstance(jComponent)) {
            bl = true;
            n = 0;
        } else if (jComponent instanceof IXButPanel) {
            if (((IXButPanel)jComponent).getOrientation() != 1) {
                bl = true;
            }
            n = 0;
        }
        if (this.isBordered) {
            gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 2.0, 1.0, 18, n, new Insets(0, 2, 0, 2), 1, 0);
        } else if (bl) {
            gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 4, 0, 0), 0, 0);
            this.add((Component)this.nameLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 2.0, 1.0, 18, n, new Insets(0, 2, 0, 2), 1, 0);
        } else {
            gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 2.0, 1.0, 17, n, new Insets(0, 2, 0, 2), 1, 0);
        }
        if (AbstractEditorPanel.isScrollItem(jComponent)) {
            jComponent2 = new JScrollPane();
            jComponent2.getViewport().add(jComponent);
            this.add((Component)jComponent2, gridBagConstraints);
        } else {
            this.add((Component)jComponent, gridBagConstraints);
        }
        jComponent2 = null;
        if (JScrollPane.class.isInstance(jComponent)) {
            try {
                jComponent2 = (JComponent)((JScrollPane)jComponent).getViewport().getComponent(0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.itemComponent = jComponent2 == null ? jComponent : jComponent2;
        this.addComponentListener(eventListener);
    }

    private void makeButtons(EventListener eventListener, String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            this.butPanel = new IXButPanel(eventListener, stringArray);
            GridBagConstraints gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 0, 2), 0, 0);
            this.add((Component)this.butPanel, gridBagConstraints);
        }
    }

    public void addComponentListener(EventListener eventListener) {
        UIUtil.addListener(this.itemComponent, eventListener);
    }

    public void setLabel(String string) {
        if (this.isBordered) {
            this.border.setTitle(string);
        } else {
            this.nameLabel.setText(string);
        }
    }

    public JComponent getItemComponent() {
        return this.itemComponent;
    }

    public boolean isListItem() {
        return AbstractEditorPanel.isListItem(this.itemComponent);
    }

    public static boolean isListItem(JComponent jComponent) {
        return jComponent instanceof JList || jComponent instanceof JComboBox || jComponent instanceof JTable;
    }

    public static boolean isScrollItem(JComponent jComponent) {
        return jComponent instanceof JList || jComponent instanceof JTextArea || jComponent instanceof JTable;
    }

    public String getName() {
        return this.nameLabel.getText();
    }

    public void setEnabled(boolean bl) {
        if (this.butPanel != null) {
            this.butPanel.setEnabled(bl);
        }
    }

    public void minimise() {
        Class<?> clazz = this.itemComponent.getClass();
        Dimension dimension = this.itemComponent.getSize();
        Debug.noteln("item size before minimise", dimension);
        if (this.itemComponent instanceof JList) {
            this.minimiseList();
        }
        if (this.itemComponent instanceof JTextArea) {
            this.minimiseText();
        } else if (this.itemComponent instanceof JTable) {
            this.minimiseTable();
        } else if (this.itemComponent instanceof JTree) {
            this.minimiseTree();
        }
        Dimension dimension2 = this.itemComponent.getSize();
        Debug.noteln("item size after minimise", dimension2);
        if (dimension2.getHeight() < dimension.getHeight()) {
            dimension2.setSize(dimension2.getWidth(), dimension2.getHeight() * 2.0);
        }
        this.setSize(dimension2);
    }

    private void minimiseList() {
        ((JList)this.getItemComponent()).setVisibleRowCount(1);
    }

    private void minimiseText() {
        JTextArea jTextArea = (JTextArea)this.getItemComponent();
        jTextArea.setRows(1);
        jTextArea.invalidate();
    }

    private void minimiseTree() {
        ((JTree)this.getItemComponent()).setVisibleRowCount(1);
    }

    private void minimiseTable() {
        JTable jTable = (JTable)this.getItemComponent();
        Dimension dimension = jTable.getPreferredScrollableViewportSize();
        dimension.setSize(dimension.getWidth(), (double)jTable.getRowHeight());
        jTable.setPreferredScrollableViewportSize(dimension);
    }

    public boolean hasData() {
        Object object = this.getData();
        if (object == null) {
            return false;
        }
        Object[] objectArray = new Object[0];
        if (object == objectArray) {
            return false;
        }
        if (object instanceof Collection) {
            return !((Collection)object).isEmpty();
        }
        return true;
    }

    public abstract Object getData();

    public abstract void setData(Object var1);

    public abstract void removeData();

    public abstract boolean setRenderer(ListCellRenderer var1);
}

