/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.domain;

import ix.icore.Annotations;
import ix.icore.Issue;
import ix.icore.domain.Constraint;
import ix.icore.domain.ListOfVariableDeclaration;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.ObjectClass;
import ix.icore.domain.Ordering;
import ix.icore.domain.Refinement;
import ix.icore.domain.VariableDeclaration;
import ix.iface.domain.LTF_Writer;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.Strings;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TF_Writer
extends LTF_Writer {
    public static final Symbol S_WORLD_STATE = Symbol.intern("world-state");
    public static final Symbol S_CONDITION = Symbol.intern("condition");
    public static final Symbol S_EFFECT = Symbol.intern("effect");

    public TF_Writer(File file) {
        super(file);
    }

    void outDomainAnnotation(Object object, Object object2) {
    }

    void outObjectClass(ObjectClass objectClass) {
    }

    void outRefinementHeader(Refinement refinement) {
        this.out("schema ");
        this.out(this.safeName(refinement.getName()));
        this.out(";");
        ListOfVariableDeclaration listOfVariableDeclaration = refinement.getVariableDeclarations();
        if (listOfVariableDeclaration != null) {
            this.outClauseStart("vars ");
            Iterator iterator = listOfVariableDeclaration.iterator();
            while (iterator.hasNext()) {
                VariableDeclaration variableDeclaration = (VariableDeclaration)iterator.next();
                this.out(variableDeclaration.getName());
                if (!iterator.hasNext()) continue;
                this.out(", ");
            }
            this.outClauseFinish();
        }
        this.outClauseStart("expands ");
        this.out(refinement.getPattern());
        this.outClauseFinish();
    }

    void outRefinementClose() {
        this.outln("");
        this.outln("end_schema;");
    }

    void outClauseStart(String string) {
        this.out(2, string);
    }

    void outClauseFinish() {
        this.out(";");
    }

    void outBigSeparator() {
        this.out(",");
    }

    void outSmallSeparator() {
        this.out(", ");
    }

    void outVarDcls(List list) {
    }

    void outNode(NodeSpec nodeSpec) {
        this.out(4, nodeSpec.getId());
        this.out(" action ");
        this.out(nodeSpec.getPattern());
    }

    void outOrdering(Ordering ordering) {
        NodeEndRef nodeEndRef = ordering.getFrom();
        NodeEndRef nodeEndRef2 = ordering.getTo();
        this.outNodeEndRef(nodeEndRef);
        this.out(" ---> ");
        this.outNodeEndRef(nodeEndRef2);
    }

    void outConstraints(List list) {
        LinkedList<Constraint> linkedList = new LinkedList<Constraint>();
        LinkedList<Constraint> linkedList2 = new LinkedList<Constraint>();
        for (Constraint constraint : list) {
            Debug.expect(constraint.getType() == S_WORLD_STATE, "Can't handle constraint", constraint);
            Symbol symbol = constraint.getRelation();
            if (symbol == S_CONDITION) {
                linkedList.add(constraint);
                continue;
            }
            if (symbol == S_EFFECT) {
                linkedList2.add(constraint);
                continue;
            }
            throw new ConsistencyException("Unknown condition type: world-state", symbol);
        }
        if (!linkedList.isEmpty()) {
            this.outConstraints("conditions", linkedList);
        }
        if (!linkedList2.isEmpty()) {
            this.outConstraints("effects", linkedList2);
        }
    }

    void outConstraints(String string, List list) {
        this.outClauseStart(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Constraint constraint = (Constraint)iterator.next();
            this.outConstraint(constraint);
            if (!iterator.hasNext()) continue;
            this.outBigSeparator();
        }
        this.outClauseFinish();
    }

    void outConstraint(Constraint constraint) {
        this.out(4, "");
        if (constraint.getRelation() == S_CONDITION) {
            this.out("unsupervised ");
        }
        Iterator iterator = constraint.getParameters().iterator();
        while (iterator.hasNext()) {
            this.outConstraintParameter(iterator.next());
            if (!iterator.hasNext()) continue;
            throw new ConsistencyException("Can't handle", constraint);
        }
    }

    void outIssues(List list) {
        this.outClauseStart(";;; issues");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Issue issue = (Issue)iterator.next();
            this.outIssue(issue);
            if (!iterator.hasNext()) continue;
            this.outBigSeparator();
        }
        this.outClauseFinish();
    }

    void outIssue(Issue issue) {
        this.out(2, ";;;   ");
        this.out(issue.getPattern());
    }

    void outComments(String string) {
        List list = Strings.breakIntoLines(string);
        for (String string2 : list) {
            this.out(2, ";;; ");
            this.out(string2);
        }
    }

    void outAnnotations(Annotations annotations) {
    }

    String toString(Object object) {
        return object instanceof LList ? this.patternText((LList)object) : object.toString();
    }

    String patternText(LList lList) {
        lList = lList.mapTree(new Function1(){

            public Object funcall(Object object) {
                if (object instanceof Symbol && object.toString().indexOf(45) >= 0) {
                    return Symbol.intern(TF_Writer.this.safeName(object.toString()));
                }
                return object;
            }
        });
        return Strings.replaceChars("()", "{}", lList.toString());
    }

    String safeName(String string) {
        return Strings.replaceChars("- ", "__", string);
    }
}

