/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.domain;

import ix.icore.Annotations;
import ix.icore.Issue;
import ix.icore.ListOfIssue;
import ix.icore.domain.Constraint;
import ix.icore.domain.Domain;
import ix.icore.domain.ListOfConstraint;
import ix.icore.domain.ListOfNodeSpec;
import ix.icore.domain.ListOfOrdering;
import ix.icore.domain.ListOfVariableDeclaration;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.ObjectClass;
import ix.icore.domain.ObjectProperty;
import ix.icore.domain.Ordering;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.domain.TimeWindow;
import ix.icore.domain.VariableDeclaration;
import ix.iface.domain.DomainWriter;
import ix.util.Collect;
import ix.util.Name;
import ix.util.RethrownException;
import ix.util.StableHashMap;
import ix.util.Strings;
import ix.util.Util;
import ix.util.WithCleanup;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LTF_Writer
extends DomainWriter {
    File domainName;
    Writer out;

    public LTF_Writer(File file) {
        this.domainName = file;
    }

    public LTF_Writer() {
    }

    public void writeDomain(final Domain domain) throws IOException {
        this.out = new BufferedWriter(new FileWriter(this.domainName));
        Util.run(new WithCleanup(){

            public void body() throws IOException {
                LTF_Writer.this.outDomain(domain);
                LTF_Writer.this.out.flush();
            }

            public void cleanup() throws IOException {
                LTF_Writer.this.out.close();
            }
        });
    }

    public void writeDomain(Domain domain, Writer writer) throws IOException {
        this.out = writer;
        this.outDomain(domain);
        this.out.flush();
    }

    public void writeRefinement(Refinement refinement, Writer writer) throws IOException {
        this.out = writer;
        this.outRefinement(refinement);
        this.out.flush();
    }

    void outDomain(Domain domain) {
        Object object;
        Object object2 = Collect.iterator(domain.getObjectClasses());
        while (object2.hasNext()) {
            object = (ObjectClass)object2.next();
            this.outObjectClass((ObjectClass)object);
            this.outln("");
        }
        object2 = domain.getRefinements().iterator();
        while (object2.hasNext()) {
            object = (Refinement)object2.next();
            this.outRefinement((Refinement)object);
            if (!object2.hasNext()) continue;
            this.outln("");
        }
        object2 = domain.getAnnotations();
        if (object2 != null) {
            for (Map.Entry entry : ((StableHashMap)object2).entrySet()) {
                this.outDomainAnnotation(entry.getKey(), entry.getValue());
            }
        }
    }

    void outDomainAnnotation(Object object, Object object2) {
        if (!this.isFullyPrintable(object) || !this.isFullyPrintable(object2)) {
            this.outln("");
            this.outln("; Cannot output annotation with key " + object);
            return;
        }
        this.out(0, "(annotations");
        this.out(2, "(");
        this.outObject(3, object);
        this.out(" = ");
        this.outAnnotationValue(object2);
        this.out(")");
        this.outln(")");
    }

    void outAnnotationValue(Object object) {
        this.outObject(4, object);
    }

    void outObject(int n, Object object) {
        if (object instanceof Map) {
            this.outMap(n, (Map)object);
        } else if (object instanceof String) {
            this.out(Lisp.quotedAndEscaped('\"', (String)object));
        } else if (object instanceof Name) {
            this.outObject(n, Symbol.intern(object.toString()));
        } else {
            this.out(Lisp.printToString(object));
        }
    }

    void outMap(int n, Map map) {
        this.out(n, "(Map");
        for (Map.Entry entry : map.entrySet()) {
            this.out(n + 2, "(");
            this.outObject(n + 3, entry.getKey());
            this.out(" = ");
            this.outObject(n + 4, entry.getValue());
            this.out(")");
        }
        this.out(")");
    }

    void outObjectClass(ObjectClass objectClass) {
        this.out("(object-class ");
        this.out(this.safeName(objectClass.getName()));
        this.out(" ");
        this.out(LList.newLList(objectClass.getSuperClassNames()));
        for (ObjectProperty objectProperty : objectClass.getObjectProperties()) {
            this.out(2, "(");
            this.out(objectProperty.getName());
            this.out(" ");
            this.out(objectProperty.getValueClassName());
            this.out(")");
        }
        this.outln(")");
    }

    void outRefinement(Refinement refinement) {
        this.outRefinementHeader(refinement);
        ListOfVariableDeclaration listOfVariableDeclaration = refinement.getVariableDeclarations();
        ListOfNodeSpec listOfNodeSpec = refinement.getNodes();
        ListOfOrdering listOfOrdering = refinement.getOrderings();
        ListOfConstraint listOfConstraint = refinement.getConstraints();
        ListOfIssue listOfIssue = refinement.getIssues();
        String string = refinement.getComments();
        Annotations annotations = refinement.getAnnotations();
        if (listOfVariableDeclaration != null) {
            this.outVarDcls(listOfVariableDeclaration);
        }
        if (listOfNodeSpec != null) {
            this.outNodes(listOfNodeSpec);
        }
        if (listOfOrdering != null) {
            this.outOrderings(listOfOrdering);
        }
        if (listOfConstraint != null) {
            this.outConstraints(listOfConstraint);
        }
        if (listOfIssue != null) {
            this.outIssues(listOfIssue);
        }
        if (string != null && !string.equals("")) {
            this.outComments(string);
        }
        if (annotations != null) {
            this.outAnnotations(annotations);
        }
        this.outRefinementClose();
    }

    void outRefinementHeader(Refinement refinement) {
        this.out("(refinement ");
        this.out(this.safeName(refinement.getName()));
        this.out(" ");
        this.out(refinement.getPattern());
    }

    void outRefinementClose() {
        this.outln(")");
    }

    private String safeName(String string) {
        return this.isSafeAsSymbolName(string) ? string : Lisp.quotedAndEscaped('\"', string);
    }

    private boolean isSafeAsSymbolName(String string) {
        char c = string.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (Character.isJavaIdentifierPart(c2) || c2 == '-') continue;
            return false;
        }
        return true;
    }

    void outClauseStart(String string) {
        this.out(2, "(");
        this.out(string);
    }

    void outClauseFinish() {
        this.out(")");
    }

    void outBigSeparator() {
    }

    void outSmallSeparator() {
        this.out(" ");
    }

    void outVarDcls(List list) {
        this.outClauseStart("variables");
        for (VariableDeclaration variableDeclaration : list) {
            this.outSmallSeparator();
            this.out(variableDeclaration.getName());
        }
        this.outClauseFinish();
    }

    void outNodes(List list) {
        this.outClauseStart("nodes");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NodeSpec nodeSpec = (NodeSpec)iterator.next();
            this.outNode(nodeSpec);
            if (!iterator.hasNext()) continue;
            this.outBigSeparator();
        }
        this.outClauseFinish();
    }

    void outNode(NodeSpec nodeSpec) {
        this.out(4, "(");
        this.out(nodeSpec.getId());
        this.out(" ");
        this.out(nodeSpec.getPattern());
        this.out(")");
    }

    void outOrderings(List list) {
        this.outClauseStart("orderings");
        this.out(4, "");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Ordering ordering = (Ordering)iterator.next();
            this.outOrdering(ordering);
            if (!iterator.hasNext()) continue;
            this.outSmallSeparator();
        }
        this.outClauseFinish();
    }

    void outOrdering(Ordering ordering) {
        NodeEndRef nodeEndRef = ordering.getFrom();
        NodeEndRef nodeEndRef2 = ordering.getTo();
        this.out("(");
        this.outNodeEndRef(nodeEndRef);
        this.out(" ");
        this.outNodeEndRef(nodeEndRef2);
        this.out(")");
    }

    void outNodeEndRef(NodeEndRef nodeEndRef) {
        this.out(nodeEndRef.getNode());
    }

    void outConstraints(List list) {
        this.outClauseStart("constraints");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Constraint constraint = (Constraint)iterator.next();
            this.outConstraint(constraint);
            if (!iterator.hasNext()) continue;
            this.outBigSeparator();
        }
        this.outClauseFinish();
    }

    void outConstraint(Constraint constraint) {
        this.out(4, "(");
        this.out(constraint.getType());
        if (constraint.getRelation() != null) {
            this.out(" ");
            this.out(constraint.getRelation());
        }
        Iterator iterator = constraint.getParameters().iterator();
        while (iterator.hasNext()) {
            this.out(" ");
            this.outConstraintParameter(iterator.next());
        }
        this.out(")");
    }

    void outConstraintParameter(Object object) {
        if (object instanceof PatternAssignment) {
            this.outPV((PatternAssignment)object);
        } else if (object instanceof TimeWindow) {
            this.outTimeWindow((TimeWindow)object);
        } else {
            this.outObject(6, object);
        }
    }

    void outPV(PatternAssignment patternAssignment) {
        this.out(patternAssignment.getPattern());
        this.out(" = ");
        this.out(Lisp.printToString(patternAssignment.getValue()));
    }

    void outTimeWindow(TimeWindow timeWindow) {
        this.out("= " + timeWindow.getMin().toISOString() + " .. " + timeWindow.getMax().toISOString());
    }

    void outIssues(List list) {
        this.outClauseStart("issues");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Issue issue = (Issue)iterator.next();
            this.outIssue(issue);
            if (!iterator.hasNext()) continue;
            this.outBigSeparator();
        }
        this.outClauseFinish();
    }

    void outIssue(Issue issue) {
        this.out(4, Lisp.list(Symbol.intern("issue"), issue.getPattern()));
    }

    void outComments(String string) {
    }

    void outAnnotations(Annotations annotations) {
        this.outClauseStart("annotations");
        for (Map.Entry entry : annotations.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (k == null) continue;
            if (this.isFullyPrintable(k) && this.isFullyPrintable(v)) {
                this.out(4, "(");
                this.outObject(5, k);
                this.out(" = ");
                this.outObject(6, v);
                this.out(")");
                continue;
            }
            this.out(4, "; Cannot output annotation with key " + k);
            this.outln("");
        }
        this.outClauseFinish();
    }

    boolean isFullyPrintable(Object object) {
        return Lisp.isFullyPrintable(object) || object instanceof Map && this.isFullyPrintableMap((Map)object);
    }

    private boolean isFullyPrintableMap(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            if (this.isFullyPrintable(entry.getKey()) && this.isFullyPrintable(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    void out(String string) {
        try {
            this.out.write(string);
        }
        catch (IOException iOException) {
            throw new RethrownException(iOException);
        }
    }

    void out(Object object) {
        this.out(this.toString(object));
    }

    void out(int n, String string) {
        this.outln("");
        this.out(Strings.repeat(n, " "));
        this.out(string);
    }

    void out(int n, Object object) {
        this.out(n, this.toString(object));
    }

    void outln(String string) {
        this.out(string);
        this.out("\n");
    }

    String toString(Object object) {
        return object.toString();
    }
}

