/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.domain;

import ix.icore.domain.Domain;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.Util;
import ix.util.xml.FileSyntax;
import ix.util.xml.FileSyntaxManager;
import ix.util.xml.XML;
import ix.util.xml.XMLLoader;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public abstract class DomainParser {
    protected DomainParser() {
    }

    public abstract Domain readDomain();

    public abstract Domain readDomain(Domain var1);

    public static File getLibraryDirectory() {
        return new File(Parameters.getParameter("library-directory", Parameters.getParameter("domain-library", "domain-library")));
    }

    protected static DomainParser makeParser(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException("Can't find " + file);
        }
        FileSyntaxManager fileSyntaxManager = XML.fileSyntaxManager();
        FileSyntax fileSyntax = fileSyntaxManager.getSyntax(file);
        Debug.noteln("Using file syntax", fileSyntax);
        if (fileSyntaxManager.canRead(fileSyntax, Domain.class)) {
            return new DomainParserWrapper(file, fileSyntax);
        }
        throw new IllegalArgumentException("Do not know how to parse " + file);
    }

    public static File loadDomain(Component component, Domain domain) {
        File file;
        File file2;
        File file3 = DomainParser.getLibraryDirectory();
        do {
            if ((file = DomainParser.chooseDomain(component, file3)) != null) continue;
            return null;
        } while ((file2 = DomainParser.loadDomain(component, domain, file)) == null);
        return file2;
    }

    private static File loadDomain(Component component, Domain domain, File file) {
        try {
            Domain domain2 = new Domain();
            DomainParser.makeParser(file).readDomain(domain2);
            if (domain2.getName() != null) {
                Debug.noteln("Domain has name", domain2.getName());
            }
            domain.takeFrom(domain2);
            return file;
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(component, "Can't find file " + Util.quote(file.getPath()), "File not found", 0);
            return null;
        }
        catch (Throwable throwable) {
            Debug.noteException(throwable);
            JOptionPane.showMessageDialog(component, new Object[]{"Exception while trying to parse " + Util.quote(file.getPath()), Debug.foldException(throwable)}, "Exception in Domain-Parser", 0);
            return null;
        }
    }

    private static File chooseDomain(Component component, File file) {
        JFileChooser jFileChooser = new XMLLoader(null, Domain.class).makeFileChooser();
        int n = jFileChooser.showOpenDialog(component);
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    protected static class DomainParserWrapper
    extends DomainParser {
        protected File domainFile;
        protected FileSyntax parser;

        protected DomainParserWrapper(File file, FileSyntax fileSyntax) {
            this.domainFile = file;
            this.parser = fileSyntax;
        }

        public Domain readDomain() {
            return this.readDomain(new Domain());
        }

        public Domain readDomain(Domain domain) {
            Object object;
            try {
                object = this.parser.readObject(this.domainFile.toURL());
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                throw new RethrownException(exception, "Cannot load from " + this.domainFile + ": " + Debug.describeException(exception));
            }
            if (!(object instanceof Domain)) {
                throw new ClassCastException("File " + this.domainFile + " contains a " + XML.nameForClass(object.getClass()) + " not a domain.");
            }
            domain.takeFrom((Domain)object);
            return domain;
        }
    }
}

