/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.plan.inspect;

import ix.icore.TaskItem;
import ix.icore.domain.Constrainer;
import ix.icore.domain.ConstrainerIterator;
import ix.icore.domain.ListOfConstrainer;
import ix.icore.domain.Ordering;
import ix.icore.plan.AbstractPlanItem;
import ix.icore.plan.AbstractRefinement;
import ix.icore.plan.ListOfPlanRefinement;
import ix.icore.plan.Plan;
import ix.icore.plan.PlanRefinementIterator;
import ix.icore.plan.inspect.OrderingVisitor;
import ix.icore.plan.inspect.PlanItemVisitor;
import ix.icore.plan.inspect.TaskItemVisitor;
import ix.util.Collect;
import ix.util.ConsistencyException;
import ix.util.Function1;
import ix.util.Name;
import ix.util.lisp.Lisp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class PlanInspector {
    protected Plan plan;
    protected boolean isAutoRecursive = true;
    private Map taskItemToPlanItemMap;
    private WeakHashMap taskItemToPlanItemVisitorCache = new WeakHashMap();

    public PlanInspector(Plan plan) {
        this.plan = plan;
    }

    public PlanInspector setIsAutoRecursive(boolean bl) {
        this.isAutoRecursive = bl;
        if (!bl && this.taskItemToPlanItemMap == null) {
            this.taskItemToPlanItemMap = new HashMap();
        }
        return this;
    }

    public Set getIssueIdSet() {
        return this.getIdSet(this.plan.getPlanIssues());
    }

    public Set getActivityIdSet() {
        return this.getIdSet(this.plan.getPlanNodes());
    }

    protected Set getIdSet(List list) {
        final HashSet hashSet = new HashSet();
        this.walkTaskItems(list, new TaskItemVisitor(){

            public void visit(TaskItem taskItem, TaskItem taskItem2, List list) {
                if (taskItem.getId() != null) {
                    hashSet.add(taskItem.getId());
                }
                if (!PlanInspector.this.isAutoRecursive) {
                    PlanInspector.this.walkTaskItemChildren(taskItem, this);
                }
            }
        });
        return hashSet;
    }

    public void walkIssues(TaskItemVisitor taskItemVisitor) {
        this.walkTaskItems(this.plan.getPlanIssues(), taskItemVisitor);
    }

    public void walkActivities(TaskItemVisitor taskItemVisitor) {
        this.walkTaskItems(this.plan.getPlanNodes(), taskItemVisitor);
    }

    protected void walkTaskItems(List list, TaskItemVisitor taskItemVisitor) {
        this.walkPlanItems(list, null, this.planItemVisitor(taskItemVisitor));
    }

    public void walkTaskItemChildren(TaskItem taskItem, TaskItemVisitor taskItemVisitor) {
        AbstractPlanItem abstractPlanItem = this.toPlanItem(taskItem);
        this.walkPlanItems(this.getSubitems(abstractPlanItem), abstractPlanItem, this.planItemVisitor(taskItemVisitor));
    }

    public AbstractPlanItem toPlanItem(TaskItem taskItem) {
        AbstractPlanItem abstractPlanItem = (AbstractPlanItem)this.taskItemToPlanItemMap.get(taskItem);
        if (abstractPlanItem == null) {
            throw new ConsistencyException("Could not find plan-item for task-item", taskItem);
        }
        return abstractPlanItem;
    }

    private PlanItemVisitor planItemVisitor(TaskItemVisitor taskItemVisitor) {
        PlanItemVisitor planItemVisitor = (PlanItemVisitor)this.taskItemToPlanItemVisitorCache.get(taskItemVisitor);
        if (planItemVisitor == null) {
            planItemVisitor = new PIVisitorWrapper(taskItemVisitor);
            this.taskItemToPlanItemVisitorCache.put(taskItemVisitor, planItemVisitor);
        }
        return planItemVisitor;
    }

    private TaskItem toTaskItem(AbstractPlanItem abstractPlanItem) {
        TaskItem taskItem = abstractPlanItem.getItem();
        if (this.taskItemToPlanItemMap != null) {
            this.taskItemToPlanItemMap.put(taskItem, abstractPlanItem);
        }
        return taskItem;
    }

    private List toTaskItems(List list) {
        return (List)Collect.map(new LinkedList(), list, new Function1(){

            public Object funcall(Object object) {
                return PlanInspector.this.toTaskItem((AbstractPlanItem)object);
            }
        });
    }

    public void walkPlanNodes(PlanItemVisitor planItemVisitor) {
        this.walkPlanItems(this.plan.getPlanNodes(), null, planItemVisitor);
    }

    protected void walkPlanItems(List list, AbstractPlanItem abstractPlanItem, PlanItemVisitor planItemVisitor) {
        Iterator iterator = Collect.iterator(list);
        while (iterator.hasNext()) {
            AbstractPlanItem abstractPlanItem2 = (AbstractPlanItem)iterator.next();
            List list2 = this.getSubitems(abstractPlanItem2);
            planItemVisitor.visit(abstractPlanItem2, abstractPlanItem, list2);
            if (!this.isAutoRecursive) continue;
            this.walkPlanItems(list2, abstractPlanItem2, planItemVisitor);
        }
    }

    protected List getSubitems(AbstractPlanItem abstractPlanItem) {
        Name name = abstractPlanItem.getExpansion();
        if (name == null) {
            return Lisp.NIL;
        }
        return Collect.ensureList(this.getRefinement(name).getSubitems());
    }

    protected AbstractRefinement getRefinement(Name name) {
        try {
            return this.plan.getPlanIssueRefinement(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return this.plan.getPlanRefinement(name);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                throw new IllegalArgumentException("No Plan or Plan Issue Refinement named " + name);
            }
        }
    }

    public void walkOrderings(OrderingVisitor orderingVisitor) {
        this.walkOrderings(this.plan.getConstraints(), orderingVisitor);
        ListOfPlanRefinement listOfPlanRefinement = this.plan.getPlanRefinements();
        if (listOfPlanRefinement != null) {
            PlanRefinementIterator planRefinementIterator = listOfPlanRefinement.elements();
            while (planRefinementIterator.hasNext()) {
                this.walkOrderings(planRefinementIterator.next().getConstraints(), orderingVisitor);
            }
        }
    }

    protected void walkOrderings(ListOfConstrainer listOfConstrainer, OrderingVisitor orderingVisitor) {
        if (listOfConstrainer != null) {
            ConstrainerIterator constrainerIterator = listOfConstrainer.elements();
            while (constrainerIterator.hasNext()) {
                Constrainer constrainer = constrainerIterator.next();
                if (!(constrainer instanceof Ordering)) continue;
                orderingVisitor.visit((Ordering)constrainer);
            }
        }
    }

    private class PIVisitorWrapper
    implements PlanItemVisitor {
        TaskItemVisitor tiVisitor;

        PIVisitorWrapper(TaskItemVisitor taskItemVisitor) {
            this.tiVisitor = taskItemVisitor;
        }

        public void visit(AbstractPlanItem abstractPlanItem, AbstractPlanItem abstractPlanItem2, List list) {
            this.tiVisitor.visit(PlanInspector.this.toTaskItem(abstractPlanItem), abstractPlanItem2 == null ? null : PlanInspector.this.toTaskItem(abstractPlanItem2), PlanInspector.this.toTaskItems(list));
        }
    }
}

