/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.info;

import ix.icore.AbstractIXObject;
import ix.icore.Annotations;
import ix.icore.domain.Named;
import ix.icore.info.IObject;
import ix.icore.info.IType;
import ix.icore.info.IValue;
import ix.iface.ui.EditableObject;
import ix.iface.ui.event.DataChangeListener;
import ix.iface.ui.util.UIUtil;
import ix.util.Debug;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractIObject
extends AbstractIXObject
implements IObject,
Named,
EditableObject {
    public String name;
    protected HashMap attVals = new HashMap();
    protected IType type;
    HashSet dataChangeListeners = new HashSet();

    public AbstractIObject() {
    }

    public AbstractIObject(IType iType) {
        this();
        this.type = iType;
    }

    public boolean setValue(IValue iValue) {
        if (iValue == null) {
            return false;
        }
        return this.setValue(iValue.getAttribute(), iValue);
    }

    public boolean setValue(String string, Object object) {
        if (string == null || string == "") {
            return false;
        }
        try {
            if (string.equals("name")) {
                this.setName((String)object);
            } else if (string.equals("comments")) {
                this.setComments((String)object);
            } else if (string.equals("annotations")) {
                this.setAnnotations((Annotations)object);
            } else if (string.equals("annotation")) {
                this.takeAnnotations((Map)object);
            } else {
                if (this.setAttributeValue(string, object)) {
                    return true;
                }
                Debug.noteln("AbstractIObject cannot set value for field", string + " (" + this.type + ")");
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            Debug.describeException(exception);
            return false;
        }
    }

    public boolean setAttributeValue(String string, Object object) {
        if (this.getAttributes().contains(string)) {
            this.attVals.put(string, object);
            return true;
        }
        return false;
    }

    public Object getValue(String string) {
        if (string == null || string == "") {
            return null;
        }
        try {
            if (string.equals("name")) {
                return this.getName();
            }
            if (string.equals("comments")) {
                return this.getComments();
            }
            return this.getAttributeValue(string);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            return null;
        }
    }

    public Collection getAttributes() {
        return this.getType().getAttributes();
    }

    public Object getAttributeValue(String string) {
        return this.attVals.get(string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.fireDataChange("name", string2, string);
    }

    public IType getType() {
        return this.type;
    }

    public void setType(IType iType) {
        IType iType2 = this.type;
        this.type = iType;
        this.fireDataChange("type", iType2, iType);
    }

    public boolean isEmpty() {
        Debug.noteln("IThing: dummy", "isEmpty");
        if ((this.name == null || this.name.equals("")) && (this.getComments() == null || this.getComments().equals(""))) {
            return this.isAttributesEmpty();
        }
        return false;
    }

    public boolean nameHasChanged(Object object) {
        String string = (String)object;
        return (this.name != null && !this.name.equals("") || string != null && !string.equals("")) && (this.name == null || !this.name.equals(string));
    }

    public boolean sameValue(String string, Object object, Object object2) {
        if (string == null) {
            return false;
        }
        if (object == null) {
            return this.isEmptyValue(object2);
        }
        if (object2 == null) {
            return false;
        }
        if (string.equals("name") || string.equals("comments")) {
            return object.equals(object2);
        }
        return this.sameAttributeValue(string, object, object2);
    }

    public boolean isAttributesEmpty() {
        if (UIUtil.isEmptyValue(this.attVals)) {
            return true;
        }
        Iterator iterator = this.attVals.values().iterator();
        while (iterator.hasNext()) {
            if (this.isEmptyValue(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmptyValue(Object object) {
        return UIUtil.isEmptyValue(object);
    }

    public abstract boolean sameAttributeValue(String var1, Object var2, Object var3);

    public abstract boolean checkConsistency();

    public void addDataChangeListener(DataChangeListener dataChangeListener) {
        this.dataChangeListeners.add(dataChangeListener);
    }

    public void removeDataChangeListener(DataChangeListener dataChangeListener) {
        this.dataChangeListeners.remove(dataChangeListener);
    }

    private void fireDataChange(String string, Object object, Object object2) {
        if (this.sameValue(string, object, object2)) {
            return;
        }
        for (DataChangeListener dataChangeListener : this.dataChangeListeners) {
            dataChangeListener.dataChanged(this, string, object, object2);
        }
    }
}

