/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.domain;

import ix.util.EnumeratedValue;
import ix.util.lisp.Symbol;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ObjectProperty {
    protected Symbol name;
    protected Symbol valueClassName;
    protected Syntax syntax;

    public ObjectProperty() {
    }

    public ObjectProperty(Symbol symbol, Symbol symbol2) {
        this.name = symbol;
        this.valueClassName = symbol2;
    }

    public Symbol getName() {
        return this.name;
    }

    public void setName(Symbol symbol) {
        this.name = symbol;
    }

    public Symbol getValueClassName() {
        return this.valueClassName;
    }

    public void setValueClassName(Symbol symbol) {
        this.valueClassName = symbol;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public void setSyntax(Syntax syntax) {
        this.syntax = syntax;
    }

    public Syntax getDefaultedSyntax() {
        return this.getSyntax() != null ? this.getSyntax() : Syntax.DEFAULT;
    }

    public String toString() {
        return "ObjectViewProperty[" + this.name + ", " + this.syntax + "]";
    }

    public static class Syntax
    extends EnumeratedValue {
        private static List values = new LinkedList();
        public static final Syntax NUMBER = new Syntax("number");
        public static final Syntax SYMBOL = new Syntax("symbol");
        public static final Syntax STRING = new Syntax("string");
        public static final Syntax LIST = new Syntax("list");
        public static final Syntax OBJECT = new Syntax("object");
        public static final Syntax DEFAULT = new Syntax("default");

        Syntax() {
        }

        private Syntax(String string) {
            this.name = string;
            Syntax.recordValue(values, this);
        }

        public String toString() {
            return this.name;
        }

        public static List values() {
            return Collections.unmodifiableList(values);
        }

        public static Syntax valueOf(String string) {
            return (Syntax)Syntax.getValueElseError(values, string);
        }
    }
}

