/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.domain;

import ix.icore.AbstractIXObject;
import ix.icore.domain.LinkedListOfObjectClass;
import ix.icore.domain.LinkedListOfRefinement;
import ix.icore.domain.ListOfObjectClass;
import ix.icore.domain.ListOfRefinement;
import ix.icore.domain.ListOfVariableDeclaration;
import ix.icore.domain.Named;
import ix.icore.domain.ObjectClass;
import ix.icore.domain.Refinement;
import ix.icore.domain.event.DomainListener;
import ix.icore.domain.event.RefinementEvent;
import ix.iface.domain.SyntaxException;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.lisp.LListCollector;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Domain
extends AbstractIXObject
implements Named,
Cloneable {
    protected String name;
    protected ListOfVariableDeclaration variableDeclarations;
    protected ListOfRefinement refinements = new LinkedListOfRefinement();
    protected ListOfObjectClass objectClasses;
    protected List listeners = new LListCollector();
    protected Map refinementNameMap = new HashMap();
    protected Map classNameMap = new HashMap();

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isEmpty() {
        return this.refinements.isEmpty();
    }

    public void clear() {
        Debug.noteln(this + " cleared");
        this.refinements.clear();
        this.refinementNameMap.clear();
        if (this.objectClasses != null) {
            this.objectClasses.clear();
        }
        this.classNameMap.clear();
    }

    public ListOfVariableDeclaration getVariableDeclarations() {
        return this.variableDeclarations;
    }

    public void setVariableDeclarations(ListOfVariableDeclaration listOfVariableDeclaration) {
        this.variableDeclarations = listOfVariableDeclaration;
    }

    public ListOfRefinement getRefinements() {
        return this.refinements;
    }

    public void setRefinements(ListOfRefinement listOfRefinement) {
        Debug.expect(listOfRefinement != null, "trying to set null refinements");
        this.refinements = listOfRefinement;
        this.refinementNameMap.clear();
        for (Refinement refinement : listOfRefinement) {
            this.refinementNameMap.put(refinement.getName(), refinement);
        }
    }

    public void setRefinements(List list) {
        this.setRefinements(list == null ? null : new LinkedListOfRefinement((Collection)list));
    }

    public Refinement getNamedRefinement(String string) {
        return (Refinement)this.refinementNameMap.get(string);
    }

    public void addRefinement(Refinement refinement) {
        Debug.expect(this.getNamedRefinement(refinement.getName()) == null, "Two refinements named", refinement.getName());
        Debug.noteln(this + " adds " + refinement);
        this.refinementNameMap.put(refinement.getName(), refinement);
        this.refinements.add(refinement);
        this.fireRefinementAdded(refinement);
    }

    public void deleteNamedRefinement(String string) {
        this.deleteRefinement(this.getNamedRefinement(string));
    }

    public void deleteRefinement(Refinement refinement) {
        if (!this.refinements.contains(refinement)) {
            throw new IllegalArgumentException("Attempt to delete " + refinement + " when it is not in " + this);
        }
        Debug.noteln(this + " deletes " + refinement);
        this.refinements.remove(refinement);
        this.refinementNameMap.remove(refinement.getName());
    }

    public void replaceNamedRefinement(String string, Refinement refinement) {
        this.replaceRefinement(this.getNamedRefinement(string), refinement);
    }

    public void replaceRefinement(Refinement refinement, Refinement refinement2) {
        int n = this.refinements.indexOf(refinement);
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to replace " + refinement + " when it is not in " + this);
        }
        Debug.noteln(this + " replaces " + refinement + " with " + refinement2);
        this.refinements.remove(n);
        this.refinements.add(n, refinement2);
        this.refinementNameMap.put(refinement.getName(), refinement2);
    }

    public ListOfObjectClass getObjectClasses() {
        return this.objectClasses;
    }

    public void setObjectClasses(ListOfObjectClass listOfObjectClass) {
        Debug.expect(listOfObjectClass != null, "trying to set null object classes");
        this.objectClasses = listOfObjectClass;
        this.classNameMap.clear();
        for (ObjectClass objectClass : this.objectClasses) {
            this.classNameMap.put(objectClass.getName(), objectClass);
        }
    }

    public void setObjectClasses(List list) {
        this.setObjectClasses(list == null ? null : new LinkedListOfObjectClass((Collection)list));
    }

    public ObjectClass getNamedObjectClass(String string) {
        return (ObjectClass)this.classNameMap.get(string);
    }

    public void addObjectClass(ObjectClass objectClass) {
        Debug.expect(this.getNamedObjectClass(objectClass.getName()) == null, "The object classes named", objectClass.getName());
        Debug.noteln(this + " adds " + objectClass);
        if (this.objectClasses == null) {
            this.objectClasses = new LinkedListOfObjectClass();
        }
        this.classNameMap.put(objectClass.getName(), objectClass);
        this.objectClasses.add(objectClass);
    }

    public void deleteNamedObjectClass(String string) {
        this.deleteObjectClass(this.getNamedObjectClass(string));
    }

    public void deleteObjectClass(ObjectClass objectClass) {
        if (!this.objectClasses.contains(objectClass)) {
            throw new IllegalArgumentException("Attempt to delete " + objectClass + " when it is not in " + this);
        }
        Debug.noteln(this + " deletes " + objectClass);
        this.objectClasses.remove(objectClass);
        this.classNameMap.remove(objectClass.getName());
    }

    public void replaceObjectClass(ObjectClass objectClass, ObjectClass objectClass2) {
        int n = this.objectClasses.indexOf(objectClass);
        if (n <= 0) {
            throw new IllegalArgumentException("Attempt to replace " + objectClass + " when it is not in " + this);
        }
        Debug.noteln(this + " replaces " + objectClass + " with " + objectClass2);
        this.objectClasses.remove(n);
        this.objectClasses.add(n, objectClass2);
        this.classNameMap.put(objectClass.getName(), objectClass2);
    }

    public void addDomainListener(DomainListener domainListener) {
        this.listeners.add(domainListener);
    }

    public void fireRefinementAdded(Refinement refinement) {
        RefinementEvent refinementEvent = new RefinementEvent(this, refinement);
        for (DomainListener domainListener : this.listeners) {
            domainListener.refinementAdded(refinementEvent);
        }
    }

    public void takeFrom(Domain domain) {
        Refinement refinement;
        Object object;
        Debug.noteln(this + " takes from " + domain);
        if (domain.name != null) {
            if (this.name != null) {
                object = Strings.breakAt("+", this.name);
                if (!object.contains(domain.name)) {
                    this.name = this.name + "+" + domain.name;
                    Debug.noteln("Extended name of", this);
                }
            } else {
                this.name = domain.name;
                Debug.noteln("New name for", this);
            }
        }
        for (Refinement object2 : domain.getRefinements()) {
            refinement = this.getNamedRefinement(object2.getName());
            if (refinement == null) {
                this.addRefinement(object2);
                continue;
            }
            this.replaceRefinement(refinement, object2);
        }
        object = Collect.iterator(domain.getObjectClasses());
        while (object.hasNext()) {
            ObjectClass objectClass = (ObjectClass)object.next();
            refinement = null;
            if (refinement == null) {
                this.addObjectClass(objectClass);
                continue;
            }
            this.replaceObjectClass((ObjectClass)((Object)refinement), objectClass);
        }
        for (Map.Entry entry : Collect.ensureMap(domain.getAnnotations()).entrySet()) {
            refinement = entry.getKey();
            Object v = entry.getValue();
            Object object2 = this.getAnnotation(refinement);
            if (object2 == null) {
                this.setAnnotation(refinement, v);
                continue;
            }
            if (object2.equals(v)) continue;
            throw new IllegalArgumentException("Conflicting annotation values: " + this + " cannot take value " + v + " for key " + refinement + " from " + domain + ", because it already has value " + object2);
        }
    }

    public void analyseDomain() {
    }

    public void checkConsistency() {
        Debug.noteln("Checking consistency of", this);
        LinkedList<SyntaxException> linkedList = new LinkedList<SyntaxException>();
        for (Object object : this.refinements) {
            try {
                ((Refinement)object).checkConsistency();
            }
            catch (SyntaxException syntaxException) {
                linkedList.add(syntaxException);
            }
        }
        switch (linkedList.size()) {
            case 0: {
                return;
            }
            case 1: {
                throw (SyntaxException)linkedList.get(0);
            }
        }
        LinkedList linkedList2 = new LinkedList();
        linkedList2.add("Problems:");
        for (SyntaxException syntaxException : linkedList) {
            linkedList2.add(Debug.describeException(syntaxException));
        }
        throw new SyntaxException(Strings.joinLines(linkedList2));
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "Domain[" + this.name + ", " + this.refinements.size() + " refinements]";
    }
}

