/*
 * Decompiled with CFR 0.152.
 */
package ix.icore;

import ix.icore.process.PNode;
import ix.util.Debug;
import ix.util.DeepCopier;
import ix.util.Function1;
import ix.util.ObjectWalker;
import ix.util.context.ContextInt;
import ix.util.context.ContextValue;
import ix.util.context.LLQueue;
import ix.util.lisp.Cons;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Variable
implements Comparable {
    protected Object name;
    private ContextValue __value = new ContextValue<Object>(null);
    private static LLQueue __allVariables = new LLQueue();
    private static ContextInt __count = new ContextInt(0);
    protected int number = __count.incrBefore();
    protected PNode sourceNode = null;

    public Variable(Object object) {
        this.name = object;
        __allVariables.add(this);
    }

    public Object getName() {
        return this.name;
    }

    public void setName(Object object) {
        this.name = object;
    }

    public Object getValue() {
        return this.__value.get();
    }

    public void setValue(Object object) {
        Debug.noteln("Setting value of " + this + " to " + object);
        Debug.expect(this.getValue() == null, this + " given value " + object + " when it already has value " + this.getValue());
        Debug.expect(!(object instanceof ItemVar));
        Debug.expect(!(object instanceof Variable));
        this.__value.set(object);
    }

    public PNode getSourceNode() {
        return this.sourceNode;
    }

    public void setSourceNode(PNode pNode) {
        this.sourceNode = pNode;
    }

    public boolean isBound() {
        return this.getValue() != null;
    }

    public boolean isGlobal() {
        return this.sourceNode == null;
    }

    public static List getAllVariables() {
        return __allVariables.contents();
    }

    public int compareTo(Object object) {
        Variable variable = (Variable)object;
        int n = ((Comparable)this.name).compareTo(variable.name);
        return n == 0 ? this.number - variable.number : n;
    }

    public String displayString() {
        if (this.getValue() != null) {
            return Lisp.printToString(this.getValue());
        }
        return this.name + "." + this.number;
    }

    public String toString() {
        return this.displayString();
    }

    public static Set varsIn(Object object) {
        if (object instanceof Variable) {
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.add(object);
            return hashSet;
        }
        if (object instanceof LList) {
            return Variable.varsIn((LList)object);
        }
        return new HashSet();
    }

    public static Set varsIn(LList lList) {
        final HashSet hashSet = new HashSet();
        lList.walkTree(new Function1(){

            public Object funcall(Object object) {
                if (object instanceof Variable) {
                    hashSet.add(object);
                }
                return null;
            }
        });
        return hashSet;
    }

    public static Set varsAnywhereIn(Object object) {
        final HashSet hashSet = new HashSet();
        new ObjectWalker(){

            public void walk(Object object) {
                if (object instanceof Variable) {
                    hashSet.add(object);
                } else {
                    super.walk(object);
                }
            }
        }.walk(object);
        return hashSet;
    }

    public static Set unboundVarsAnywhereIn(Object object) {
        final HashSet hashSet = new HashSet();
        new ObjectWalker(){

            public void walk(Object object) {
                if (object instanceof Variable && ((Variable)object).getValue() == null) {
                    hashSet.add(object);
                } else {
                    super.walk(object);
                }
            }
        }.walk(object);
        return hashSet;
    }

    public static Set unboundVarsIn(Collection collection) {
        HashSet<Variable> hashSet = new HashSet<Variable>();
        for (Variable variable : collection) {
            if (variable.getValue() != null) continue;
            hashSet.add(variable);
        }
        return hashSet;
    }

    public static boolean isFullyBound(Object object) {
        if (object instanceof Variable) {
            return ((Variable)object).getValue() != null;
        }
        if (object instanceof Cons) {
            Cons cons = (Cons)object;
            return Variable.isFullyBound(cons.car()) && Variable.isFullyBound(cons.cdr());
        }
        return true;
    }

    public static Object revertVars(Object object) {
        if (object instanceof Variable) {
            Variable variable = (Variable)object;
            return variable.getName();
        }
        if (object instanceof Cons) {
            Cons cons = (Cons)object;
            return new Cons(Variable.revertVars(cons.car()), (LList)Variable.revertVars(cons.cdr()));
        }
        return object;
    }

    public static Object revertAllVars(Object object) {
        return new DeepCopier(){

            public Object copy(Object object) {
                if (object instanceof Variable) {
                    Variable variable = (Variable)object;
                    return variable.getName();
                }
                return super.copy(object);
            }
        }.copy(object);
    }

    public static Object removeVars(Object object) {
        if (object instanceof Variable) {
            Variable variable = (Variable)object;
            Object object2 = variable.getValue();
            return object2 == null ? variable.getName() : object2;
        }
        if (object instanceof Cons) {
            Cons cons = (Cons)object;
            return new Cons(Variable.removeVars(cons.car()), (LList)Variable.removeVars(cons.cdr()));
        }
        return object;
    }

    public static Object removeAllVars(Object object) {
        return new DeepCopier(){

            public Object copy(Object object) {
                if (object instanceof Variable) {
                    Variable variable = (Variable)object;
                    Object object2 = variable.getValue();
                    return object2 == null ? variable.getName() : object2;
                }
                return super.copy(object);
            }
        }.copy(object);
    }
}

