/*
 * Decompiled with CFR 0.152.
 */
package ix.ichat;

import ix.ichat.ChatMessage;
import ix.ichat.IChat;
import ix.icore.Activity;
import ix.icore.IXAgent;
import ix.icore.Issue;
import ix.icore.ReportType;
import ix.icore.Sendable;
import ix.icore.Status;
import ix.icore.TaskItem;
import ix.icore.YesNo;
import ix.iface.util.IFUtil;
import ix.iface.util.IconImage;
import ix.iface.util.ToolFrame;
import ix.ip2.WaitForReportsActivity;
import ix.itest.ReceivePanel;
import ix.itest.SendPanel;
import ix.util.Debug;
import ix.util.Name;
import ix.util.Util;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JSplitPane;

public class ChatFrame
extends ToolFrame
implements ActionListener {
    IXAgent agent;
    protected Container contentPane = this.getContentPane();
    ReceivePanel receivePanel;
    SendPanel sendPanel;
    JMenu styleMenu;

    public ChatFrame(IXAgent iXAgent, String string) {
        super(string);
        this.agent = iXAgent;
        this.setIconImage(IconImage.getIconImage(this));
        this.receivePanel = new ReceivePanel(iXAgent);
        this.sendPanel = new ChatSendPanel(iXAgent);
        this.setJMenuBar(this.makeMenuBar());
        JSplitPane jSplitPane = new JSplitPane(0, this.receivePanel, this.sendPanel);
        jSplitPane.setResizeWeight(1.0);
        this.contentPane.add(jSplitPane);
        this.pack();
    }

    protected JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        if (this.agent instanceof IChat) {
            jMenu.add(IFUtil.makeMenuItem("Exit", this));
        } else {
            jMenu.add(IFUtil.makeMenuItem("Close", this));
        }
        this.styleMenu = new JMenu("Style");
        jMenuBar.add(this.styleMenu);
        this.styleMenu.add(IFUtil.makeMenuItem("Message Color", this));
        return jMenuBar;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("ChatFrame action:", string);
        if (string.equals("Close")) {
            this.setVisible(false);
        } else if (string.equals("Exit")) {
            if (Util.dialogConfirms(this, "Are you sure you want to exit I-Chat?")) {
                System.exit(0);
            }
        } else if (string.equals("Message Color")) {
            this.sendPanel.editMessageColor();
            this.styleMenu.setForeground(this.agent.getContactManager().getAgentColor(this.agent.getAgentSymbolName()));
        } else {
            Debug.noteln("Nothing to do for", string);
        }
    }

    public void newMessage(ChatMessage chatMessage) {
        this.receivePanel.newMessage(chatMessage);
    }

    public void initReportBackReport(TaskItem taskItem) {
        Name name = taskItem.getRef();
        Name name2 = taskItem.getSenderId();
        Status status = taskItem.getStatus();
        ReportType reportType = status == Status.BLANK || status == Status.EXECUTING || status == Status.POSSIBLE ? ReportType.PROGRESS : ReportType.INFORMATION;
        this.sendPanel.initReport(taskItem, name2, name, reportType);
    }

    public void initForwardReport(TaskItem taskItem) {
        Name name = taskItem.getId();
        Name name2 = taskItem.getForwardedTo();
        ReportType reportType = ReportType.INFORMATION;
        this.sendPanel.initReport(taskItem, name2, name, reportType);
    }

    public SendPanel getSendPanel() {
        return this.sendPanel;
    }

    class ChatSendPanel
    extends SendPanel {
        ChatSendPanel(IXAgent iXAgent) {
            super(iXAgent);
        }

        public void send(String string, Sendable sendable) {
            if (sendable instanceof Issue || sendable instanceof Activity) {
                TaskItem taskItem = (TaskItem)sendable;
                if (!string.equalsIgnoreCase("me") && taskItem.getReportBack() == YesNo.YES && taskItem.getRef() == null) {
                    WaitForReportsActivity waitForReportsActivity = new WaitForReportsActivity(string, taskItem.getPattern());
                    waitForReportsActivity.ensureId();
                    taskItem.setRef(waitForReportsActivity.getId());
                    waitForReportsActivity.setPriority(taskItem.getPriority());
                    ChatFrame.this.agent.handleNewActivity(waitForReportsActivity);
                }
            }
            super.send(string, sendable);
        }

        public void sending(String string, Sendable sendable) {
            if (sendable instanceof ChatMessage) {
                ChatFrame.this.receivePanel.newMessage((ChatMessage)sendable);
            }
        }
    }
}

