/*
 * Decompiled with CFR 0.152.
 */
package ix.examples;

import ix.examples.PicoISim;
import ix.examples.PicoIX;
import ix.util.Debug;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.util.Enumeration;
import java.util.Hashtable;

public class SimResource {
    static final Symbol S_RESOURCE = Symbol.intern("resource");
    static final Symbol S_PRODUCE = Symbol.intern("produce");
    static final Symbol S_CONSUME = Symbol.intern("consume");

    static class CM
    extends PicoIX.ConstraintManager {
        Hashtable resourceTable = new Hashtable();

        CM() {
            super(S_RESOURCE);
        }

        Object addConstraint(PicoIX.Constraint constraint) {
            Constraint constraint2 = (Constraint)constraint;
            if (constraint2.subtype == S_CONSUME) {
                long l = this.getAmount(constraint2.pattern);
                if (l >= constraint2.amount) {
                    this.setAmount(constraint2.pattern, l - constraint2.amount);
                    this.noteSuccess(constraint2);
                    return Boolean.TRUE;
                }
                this.noteFailure(constraint2);
                return Boolean.FALSE;
            }
            Debug.expect(constraint2.subtype == S_PRODUCE, "invalid subtype in", constraint2);
            this.setAmount(constraint2.pattern, this.getAmount(constraint2.pattern) + constraint2.amount);
            this.noteSuccess(constraint2);
            return Boolean.TRUE;
        }

        Object tryConstraint(PicoIX.Constraint constraint) {
            Constraint constraint2 = (Constraint)constraint;
            if (constraint2.subtype == S_CONSUME) {
                return new Boolean(this.getAmount(constraint2.pattern) >= constraint2.amount);
            }
            Debug.expect(constraint2.subtype == S_PRODUCE, "invalid subtype in", constraint2);
            return Boolean.TRUE;
        }

        long getAmount(Object object) {
            Long l = (Long)this.resourceTable.get(object);
            return l == null ? 0L : l;
        }

        void setAmount(Object object, long l) {
            this.resourceTable.put(object, new Long(l));
        }

        void noteSuccess(Constraint constraint) {
            Debug.noteln(constraint.subtype + " " + constraint.amount + " " + constraint.pattern);
        }

        void noteFailure(Constraint constraint) {
            Debug.noteln("Could not " + constraint.subtype + " " + constraint.amount + " " + constraint.pattern);
        }

        void printStatusReport() {
            System.out.println("");
            System.out.println("Resource state");
            System.out.println("-------------");
            Enumeration enumeration = this.resourceTable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                System.out.println(k + " = " + this.resourceTable.get(k));
            }
            System.out.println("");
        }
    }

    static class Constraint
    extends PicoIX.Constraint {
        Symbol subtype;
        Object pattern;
        long amount;

        Constraint(Symbol symbol, long l, Object object) {
            super(S_RESOURCE);
            this.subtype = symbol;
            this.pattern = object;
            this.amount = l;
            this.args = Lisp.list(new Long(l), object);
        }
    }

    static class ISim
    extends PicoISim {
        ISim() {
        }
    }
}

