/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.FinderUtil;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.BBRuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingVector;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPBRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPRuleStore;
import com.hp.hpl.jena.reasoner.rulesys.impl.TempNodeCache;
import com.hp.hpl.jena.util.OneToManyMap;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class LPBackwardRuleInfGraph
extends BaseInfGraph
implements BackwardRuleInfGraphI {
    protected LPBRuleEngine engine;
    protected OneToManyMap derivations;
    protected FGraph fschema;
    protected FGraph fdeductions;
    protected Finder dataFind;
    protected TempNodeCache tempNodecache;
    static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$reasoner$rulesys$LPBackwardRuleInfGraph == null ? (class$com$hp$hpl$jena$reasoner$rulesys$LPBackwardRuleInfGraph = LPBackwardRuleInfGraph.class$("com.hp.hpl.jena.reasoner.rulesys.LPBackwardRuleInfGraph")) : class$com$hp$hpl$jena$reasoner$rulesys$LPBackwardRuleInfGraph));
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$LPBackwardRuleInfGraph;

    public LPBackwardRuleInfGraph(Reasoner reasoner, LPRuleStore lPRuleStore, Graph graph, Graph graph2) {
        super(graph, reasoner);
        if (graph2 != null) {
            this.fschema = new FGraph(graph2);
        }
        this.engine = new LPBRuleEngine(this, lPRuleStore);
        this.tempNodecache = new TempNodeCache(this);
    }

    public Graph getSchemaGraph() {
        return this.fschema.getGraph();
    }

    public void prepare() {
        if (!this.isPrepared) {
            this.fdeductions = new FGraph(new GraphMem());
            this.extractAxioms();
            this.dataFind = this.fdata;
            if (this.fdeductions != null) {
                this.dataFind = FinderUtil.cascade(this.dataFind, this.fdeductions);
            }
            if (this.fschema != null) {
                this.dataFind = FinderUtil.cascade(this.dataFind, this.fschema);
            }
        }
        this.isPrepared = true;
    }

    public void rebind(Graph graph) {
        this.engine.checkSafeToUpdate();
        this.fdata = new FGraph(graph);
        this.isPrepared = false;
    }

    public void rebind() {
        this.engine.checkSafeToUpdate();
        this.isPrepared = false;
    }

    public void reset() {
        this.engine.checkSafeToUpdate();
        this.engine.reset();
    }

    public synchronized ExtendedIterator findWithContinuation(TriplePattern triplePattern, Finder finder) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        ExtendedIterator extendedIterator = this.engine.find(triplePattern);
        if (finder != null) {
            extendedIterator = extendedIterator.andThen(finder.find(triplePattern));
        }
        return extendedIterator.filterDrop(Functor.acceptFilter);
    }

    public ExtendedIterator find(Node node, Node node2, Node node3) {
        return this.findWithContinuation(new TriplePattern(node, node2, node3), null);
    }

    public ExtendedIterator find(TriplePattern triplePattern) {
        return this.findWithContinuation(triplePattern, null);
    }

    public synchronized void performAdd(Triple triple) {
        this.engine.checkSafeToUpdate();
        this.fdata.getGraph().add(triple);
        this.isPrepared = false;
    }

    public void performDelete(Triple triple) {
        this.engine.checkSafeToUpdate();
        this.fdata.getGraph().delete(triple);
        this.isPrepared = false;
    }

    public void setTabled(Node node) {
        this.engine.tablePredicate(node);
        if (this.isTraceOn()) {
            logger.info((Object)("LP TABLE " + node));
        }
    }

    public void setDerivationLogging(boolean bl) {
        this.engine.setDerivationLogging(bl);
        this.derivations = bl ? new OneToManyMap() : null;
    }

    public Iterator getDerivation(Triple triple) {
        if (this.derivations == null) {
            return new NullIterator();
        }
        return this.derivations.getAll(triple);
    }

    public void setTraceOn(boolean bl) {
        this.engine.setTraceOn(bl);
    }

    public boolean isTraceOn() {
        return this.engine.isTraceOn();
    }

    public void logDerivation(Triple triple, Object object) {
        this.derivations.put(triple, object);
    }

    public ExtendedIterator findDataMatches(TriplePattern triplePattern) {
        return this.dataFind.find(triplePattern);
    }

    public boolean processBuiltin(ClauseEntry clauseEntry, Rule rule, BindingEnvironment bindingEnvironment) {
        throw new ReasonerException("Internal error in FBLP rule engine, incorrect invocation of building in rule " + rule);
    }

    public void silentAdd(Triple triple) {
        this.fdeductions.getGraph().add(triple);
    }

    public Node getTemp(Node node, Node node2, Node node3) {
        return this.tempNodecache.getTemp(node, node2, node3);
    }

    protected void extractAxioms() {
        Graph graph = this.fdeductions.getGraph();
        BBRuleContext bBRuleContext = null;
        Iterator iterator = this.engine.getRuleStore().getAllRules().iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (rule.bodyLength() != 0) continue;
            for (int i = 0; i < rule.headLength(); ++i) {
                Functor functor;
                Builtin builtin;
                ClauseEntry clauseEntry = rule.getHeadElement(i);
                if (clauseEntry instanceof TriplePattern) {
                    graph.add(((TriplePattern)clauseEntry).asTriple());
                    continue;
                }
                if (!(clauseEntry instanceof Functor)) continue;
                if (bBRuleContext == null) {
                    bBRuleContext = new BBRuleContext(this);
                }
                if ((builtin = (functor = (Functor)clauseEntry).getImplementor()) == null) {
                    throw new ReasonerException("Attempted to invoke undefined functor: " + functor);
                }
                Node[] nodeArray = functor.getArgs();
                bBRuleContext.setEnv(new BindingVector(nodeArray));
                bBRuleContext.setRule(rule);
                builtin.headAction(nodeArray, nodeArray.length, bBRuleContext);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

