/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.TripleMatchFilter;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.graph.impl.AllCapabilities;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.StandardValidityReport;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;

public abstract class BaseInfGraph
extends GraphBase
implements InfGraph {
    protected Reasoner reasoner;
    protected FGraph fdata;
    protected boolean recordDerivations;
    protected boolean isPrepared = false;

    public BaseInfGraph(Graph graph, Reasoner reasoner) {
        this.fdata = new FGraph(graph);
        this.reasoner = reasoner;
    }

    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new InfCapabilities();
        }
        return this.capabilities;
    }

    public Graph getRawGraph() {
        return this.fdata.getGraph();
    }

    public Reasoner getReasoner() {
        return this.reasoner;
    }

    public void rebind(Graph graph) {
        this.fdata = new FGraph(graph);
        this.isPrepared = false;
    }

    public void rebind() {
        this.isPrepared = false;
    }

    public void reset() {
    }

    public void prepare() {
        this.isPrepared = true;
    }

    public Graph getDeductionsGraph() {
        return null;
    }

    public Node getGlobalProperty(Node node) {
        throw new ReasonerException("Global property not implemented: " + node);
    }

    public boolean testGlobalProperty(Node node) {
        Object object;
        Node node2 = this.getGlobalProperty(node);
        if (node2.isLiteral() && (object = node2.getLiteral().getValue()) instanceof Boolean) {
            return (Boolean)object;
        }
        throw new ReasonerException("Global property test returned non-boolean value\nTest was: " + node + "\nResult was: " + node2);
    }

    public ValidityReport validate() {
        this.checkOpen();
        return new StandardValidityReport();
    }

    public ExtendedIterator find(Node node, Node node2, Node node3, Graph graph) {
        return this.cloneWithPremises(graph).find(node, node2, node3);
    }

    public ExtendedIterator find(TripleMatch tripleMatch) {
        return this.find(tripleMatch.getMatchSubject(), tripleMatch.getMatchPredicate(), tripleMatch.getMatchObject()).filterKeep(new TripleMatchFilter(tripleMatch.asTriple()));
    }

    public abstract ExtendedIterator findWithContinuation(TriplePattern var1, Finder var2);

    public ExtendedIterator find(Node node, Node node2, Node node3) {
        this.checkOpen();
        return this.findWithContinuation(new TriplePattern(node, node2, node3), this.fdata);
    }

    public ExtendedIterator find(TriplePattern triplePattern) {
        this.checkOpen();
        return this.findWithContinuation(triplePattern, this.fdata);
    }

    public boolean contains(Triple triple) {
        this.checkOpen();
        ExtendedIterator extendedIterator = this.find(triple.getSubject(), triple.getPredicate(), triple.getObject());
        boolean bl = extendedIterator.hasNext();
        extendedIterator.close();
        return bl;
    }

    public boolean contains(Node node, Node node2, Node node3) {
        this.checkOpen();
        ExtendedIterator extendedIterator = this.find(node, node2, node3);
        boolean bl = extendedIterator.hasNext();
        extendedIterator.close();
        return bl;
    }

    public void setDerivationLogging(boolean bl) {
        this.recordDerivations = bl;
    }

    public Iterator getDerivation(Triple triple) {
        return null;
    }

    public int size() {
        this.checkOpen();
        return this.fdata.getGraph().size();
    }

    public boolean isEmpty() {
        return this.fdata.getGraph().isEmpty();
    }

    public void close() {
        if (!this.closed) {
            this.fdata.getGraph().close();
            this.fdata = null;
            super.close();
        }
    }

    public synchronized void performAdd(Triple triple) {
        if (!this.isPrepared) {
            this.prepare();
        }
        this.fdata.getGraph().add(triple);
    }

    public void performDelete(Triple triple) {
        if (!this.isPrepared) {
            this.prepare();
        }
        this.fdata.getGraph().delete(triple);
    }

    public abstract Graph getSchemaGraph();

    public InfGraph cloneWithPremises(Graph graph) {
        return this.getReasoner().bindSchema(this.getSchemaGraph()).bind(new Union(this.getRawGraph(), graph));
    }

    static class InfCapabilities
    extends AllCapabilities {
        InfCapabilities() {
        }

        public boolean sizeAccurate() {
            return false;
        }

        public boolean deleteAllowed(boolean bl) {
            return !bl;
        }
    }
}

