/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.RDQL_InternalErrorException;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.rdql.Value;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import com.hp.hpl.jena.rdql.parser.SimpleNode;
import java.io.PrintWriter;

public class Q_PatternLiteral
extends SimpleNode
implements Expr {
    String patternString = null;
    String modifiers = "";
    int mask;

    Q_PatternLiteral(int n) {
        super(n);
    }

    Q_PatternLiteral(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public void setPattern(String string) {
        this.patternString = string;
    }

    public void setModifiers(String string) {
        this.modifiers = this.modifiers + string;
        block6: for (int i = 0; i < this.modifiers.length(); ++i) {
            switch (this.modifiers.charAt(i)) {
                case 'i': {
                    this.mask |= 1;
                    continue block6;
                }
                case 'm': {
                    this.mask |= 8;
                    continue block6;
                }
                case 's': {
                    this.mask |= 0x10;
                    continue block6;
                }
                case 'x': {
                    this.mask |= 0x20;
                }
            }
        }
    }

    public String toString() {
        if (this.patternString.indexOf(47) == -1) {
            return "/" + this.patternString + "/" + this.modifiers;
        }
        if (this.patternString.indexOf(33) == -1) {
            return "m!" + this.patternString + "!" + this.modifiers;
        }
        if (this.patternString.indexOf(37) == -1) {
            return "m%" + this.patternString + "%" + this.modifiers;
        }
        char c = '!';
        return "m" + c + this.quote(this.patternString, c) + c + this.modifiers;
    }

    private String quote(String string, char c) {
        int n;
        int n2 = 0;
        while ((n = string.indexOf(c, n2)) != -1) {
            string = string.substring(0, n) + "\\" + string.substring(n);
            n2 = n + 2;
        }
        return string;
    }

    public void print(PrintWriter printWriter, int n) {
        printWriter.print(this.toString());
    }

    public Value eval(Query query, ResultBinding resultBinding) {
        throw new RDQL_InternalErrorException("Q_PatternLiteral.eval called!");
    }

    public String asPrefixString() {
        return this.toString();
    }

    public String asInfixString() {
        return this.toString();
    }
}

