/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import java.net.MalformedURLException;
import java.net.URL;

public class URI
extends com.hp.hpl.jena.rdf.arp.URI {
    private String relative;

    static URI create(String string) {
        try {
            return new URI(string);
        }
        catch (MalformedURIException malformedURIException) {
            if (malformedURIException.toString().indexOf("No scheme") != -1) {
                try {
                    return new URI(string, false);
                }
                catch (MalformedURIException malformedURIException2) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException(malformedURIException.toString());
        }
    }

    private URI(String string, boolean bl) throws MalformedURIException {
        super("http://foo");
        this.relative = string;
    }

    private URI(String string) throws MalformedURIException {
        super(string);
    }

    private URI(URI uRI, URI uRI2) throws MalformedURIException {
        super(uRI, uRI2.toString());
    }

    boolean isAbsolute() {
        return this.relative == null;
    }

    URI resolve(URI uRI) {
        try {
            return new URI(this, uRI);
        }
        catch (MalformedURIException malformedURIException) {
            throw new IllegalArgumentException(malformedURIException.toString());
        }
    }

    URL toURL() throws MalformedURLException {
        return new URL(this.getURIString());
    }

    URI relativize(URI uRI) {
        String string = this.toString();
        String string2 = uRI.toString();
        if (!string2.startsWith(string)) {
            throw new IllegalArgumentException(string2 + " is not relative to " + string);
        }
        String string3 = string2.substring(string.length());
        return URI.create(string3.charAt(0) == '/' ? string3.substring(1) : string3);
    }

    public String getURIString() {
        return this.relative == null ? super.getURIString() : this.relative;
    }

    public String toString() {
        return this.getURIString();
    }
}

