/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.path.impl;

import com.hp.hpl.jena.ontology.path.Path;
import com.hp.hpl.jena.ontology.path.PathExpr;
import com.hp.hpl.jena.ontology.path.PathIterator;
import com.hp.hpl.jena.ontology.path.impl.AbstractPathExpr;
import com.hp.hpl.jena.ontology.path.impl.PathImpl;
import com.hp.hpl.jena.ontology.path.impl.PathIteratorImpl;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;

public class ComposePathExpr
extends AbstractPathExpr {
    protected PathExpr m_left;
    protected PathExpr m_right;

    public ComposePathExpr(PathExpr pathExpr, PathExpr pathExpr2) {
        this.m_left = pathExpr;
        this.m_right = pathExpr2;
    }

    public PathIterator evaluate(Resource resource) {
        return new ComposePathIterator(resource);
    }

    protected class ComposePathIterator
    extends PathIteratorImpl {
        protected PathIterator m_leftIter;
        protected PathIterator m_rightIter = null;
        protected Path m_head;

        protected ComposePathIterator(Resource resource) {
            this.m_leftIter = ComposePathExpr.this.m_left.evaluate(resource);
        }

        public boolean hasNext() {
            this.checkRightIter();
            return this.m_rightIter != null && this.m_rightIter.hasNext();
        }

        public Object next() {
            this.checkRightIter();
            return new PathImpl(this.m_head, this.m_rightIter.nextPath());
        }

        protected void checkRightIter() {
            if (this.m_rightIter == null || !this.m_rightIter.hasNext()) {
                if (this.m_leftIter.hasNext()) {
                    this.m_head = this.m_leftIter.nextPath();
                    RDFNode rDFNode = this.m_head.getValue();
                    if (rDFNode instanceof Resource) {
                        this.m_rightIter = ComposePathExpr.this.m_right.evaluate((Resource)rDFNode);
                    } else {
                        this.checkRightIter();
                    }
                } else {
                    this.m_rightIter = null;
                }
            }
        }
    }
}

