/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import com.hp.hpl.jena.n3.N3JenaWriterCommon;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;

public class N3JenaWriterTriples
extends N3JenaWriterCommon {
    public static final int colWidth = 8;

    protected void writeModel(Model model) {
        this.alwaysAllocateBNodeLabel = true;
        StmtIterator stmtIterator = model.listStatements();
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            String string = this.formatResource(statement.getSubject());
            this.out.print(string);
            this.padCol(string);
            this.out.print(minGapStr);
            String string2 = this.formatProperty(statement.getPredicate());
            this.out.print(string2);
            this.padCol(string2);
            this.out.print(minGapStr);
            this.out.print(this.formatNode(statement.getObject()));
            this.out.println(" .");
        }
        stmtIterator.close();
    }

    private void padCol(String string) {
        if (string.length() < 8) {
            this.out.print(N3JenaWriterTriples.pad(8 - string.length()));
        }
    }
}

