/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.TreeQueryPlan;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.HashSet;
import java.util.Iterator;

public class SimpleTreeQueryPlan
implements TreeQueryPlan {
    private Graph pattern;
    private Graph target;

    public SimpleTreeQueryPlan(Graph graph, Graph graph2) {
        this.target = graph;
        this.pattern = graph2;
    }

    public Graph executeTree() {
        GraphMem graphMem = new GraphMem();
        HashSet hashSet = SimpleTreeQueryPlan.getRoots(this.pattern);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.handleRoot(graphMem, (Node)iterator.next(), new HashSet());
        }
        return graphMem;
    }

    private Iterator findFromTriple(Graph graph, Triple triple) {
        return graph.find(this.asPattern(triple.getSubject()), this.asPattern(triple.getPredicate()), this.asPattern(triple.getObject()));
    }

    private Node asPattern(Node node) {
        return node.isBlank() ? null : node;
    }

    private void handleRoot(Graph graph, Node node, HashSet hashSet) {
        ExtendedIterator extendedIterator = this.pattern.find(node, null, null);
        if (!extendedIterator.hasNext()) {
            this.absorb(graph, hashSet);
            return;
        }
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            Iterator iterator = this.findFromTriple(this.target, triple);
            while (iterator.hasNext()) {
                Triple triple2 = (Triple)iterator.next();
                hashSet.add(triple2);
                this.handleRoot(graph, triple.getObject(), hashSet);
            }
        }
    }

    private void absorb(Graph graph, HashSet hashSet) {
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            graph.add((Triple)iterator.next());
        }
        hashSet.clear();
    }

    public static HashSet getRoots(Graph graph) {
        HashSet<Node> hashSet = new HashSet<Node>();
        ExtendedIterator extendedIterator = GraphUtil.findAll(graph);
        while (extendedIterator.hasNext()) {
            hashSet.add(((Triple)extendedIterator.next()).getSubject());
        }
        ExtendedIterator extendedIterator2 = GraphUtil.findAll(graph);
        while (extendedIterator2.hasNext()) {
            hashSet.remove(((Triple)extendedIterator2.next()).getObject());
        }
        return hashSet;
    }
}

