/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.GraphMatcher;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.shared.AddDeniedException;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.shared.ClosedException;
import com.hp.hpl.jena.shared.DeleteDeniedException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.Iterator;
import java.util.List;

public class DBReifierGraph
implements Graph {
    protected List m_specializedGraphs = null;
    protected GraphRDB m_parent = null;

    public DBReifierGraph(GraphRDB graphRDB, List list) {
        this.m_parent = graphRDB;
        this.m_specializedGraphs = list;
    }

    public void add(Triple triple) {
        throw new AddDeniedException("cannot add to DB reifier", triple);
    }

    public void delete(Triple triple) {
        throw new DeleteDeniedException("cannot delete from a DB reifier", triple);
    }

    public int size() {
        this.checkUnclosed();
        int n = 0;
        Iterator iterator = this.m_specializedGraphs.iterator();
        while (iterator.hasNext()) {
            SpecializedGraph specializedGraph = (SpecializedGraph)iterator.next();
            n += specializedGraph.tripleCount();
        }
        return n;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private void checkUnclosed() {
        if (this.m_specializedGraphs == null) {
            throw new ClosedException("this DB Reifier has been closed", this);
        }
    }

    public boolean contains(Triple triple) {
        this.checkUnclosed();
        SpecializedGraph.CompletionFlag completionFlag = this.newComplete();
        Iterator iterator = this.m_specializedGraphs.iterator();
        while (iterator.hasNext()) {
            SpecializedGraph specializedGraph = (SpecializedGraph)iterator.next();
            boolean bl = specializedGraph.contains(triple, this.newComplete());
            if (!bl && !completionFlag.isDone()) continue;
            return bl;
        }
        return false;
    }

    protected SpecializedGraph.CompletionFlag newComplete() {
        return new SpecializedGraph.CompletionFlag();
    }

    public boolean contains(Node node, Node node2, Node node3) {
        return this.contains(new Triple(node, node2, node3));
    }

    public ExtendedIterator find(TripleMatch tripleMatch) {
        this.checkUnclosed();
        ExtendedIterator extendedIterator = new NiceIterator();
        SpecializedGraph.CompletionFlag completionFlag = this.newComplete();
        Iterator iterator = this.m_specializedGraphs.iterator();
        while (iterator.hasNext()) {
            SpecializedGraph specializedGraph = (SpecializedGraph)iterator.next();
            ExtendedIterator extendedIterator2 = specializedGraph.find(tripleMatch, completionFlag);
            extendedIterator = extendedIterator.andThen(extendedIterator2);
            if (!completionFlag.isDone()) continue;
            break;
        }
        return extendedIterator;
    }

    public PrefixMapping getPrefixMapping() {
        return this.m_parent.getPrefixMapping();
    }

    public TransactionHandler getTransactionHandler() {
        return this.m_parent.getTransactionHandler();
    }

    public void close() {
        this.m_specializedGraphs = null;
        this.m_parent = null;
    }

    public GraphEventManager getEventManager() {
        throw new BrokenException("DB reifiers do not yet implement getEventManager");
    }

    public boolean dependsOn(Graph graph) {
        return this.m_parent.dependsOn(graph);
    }

    public QueryHandler queryHandler() {
        return new SimpleQueryHandler(this);
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        return this.m_parent.getBulkUpdateHandler();
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public Reifier getReifier() {
        throw new JenaException("DB Reifier graphs have no reifiers");
    }

    public ExtendedIterator find(Node node, Node node2, Node node3) {
        return this.find(Triple.createMatch(node, node2, node3));
    }

    public boolean isIsomorphicWith(Graph graph) {
        return graph != null && GraphMatcher.equals(this, graph);
    }

    public int capabilities() {
        return 0;
    }

    public String toString() {
        return GraphBase.toString("DBReifier ", this);
    }
}

