/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.propertyEditor;

import com.bbn.openmap.util.propertyEditor.FilePropertyEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MultiDirectoryPropertyEditor
extends FilePropertyEditor {
    protected JTextField textField = new JTextField(15);
    protected char pathSeparator;

    public MultiDirectoryPropertyEditor() {
        this.button = new JButton("Add");
        this.setPathSeparator(';');
    }

    public void setPathSeparator(char c) {
        this.pathSeparator = c;
    }

    public char getPathSeparator() {
        return this.pathSeparator;
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = this.getFileChooser();
        int returnVal = chooser.showDialog(null, "Select");
        if (returnVal == 0) {
            String newFilename = chooser.getSelectedFile().getAbsolutePath();
            newFilename = this.cleanUpName(newFilename);
            this.append(newFilename);
            this.firePropertyChange();
        }
    }

    public Component getCustomEditor() {
        this.button.addActionListener(this);
        JPanel jp = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        jp.setLayout(gridbag);
        c.weightx = 1.0;
        c.fill = 2;
        gridbag.setConstraints(this.textField, c);
        jp.add(this.textField);
        c.weightx = 0.0;
        c.anchor = 13;
        c.fill = 0;
        gridbag.setConstraints(this.button, c);
        jp.add(this.button);
        return jp;
    }

    public JFileChooser getFileChooser() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(true);
        return chooser;
    }

    public void append(String addPath) {
        String currentPath = this.textField.getText();
        if (currentPath.equals("")) {
            this.setValue(addPath);
        } else {
            this.setValue(currentPath.concat(";" + addPath));
        }
    }

    public void setValue(Object string) {
        if (!(string instanceof String)) {
            return;
        }
        this.textField.setText((String)string);
    }

    public String getAsText() {
        return this.textField.getText();
    }
}

