/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.propertyEditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import javax.swing.JButton;
import javax.swing.JFileChooser;

public class FilePropertyEditor
extends PropertyEditorSupport
implements ActionListener {
    JButton button = new JButton("Select file...");

    public boolean supportsCustomEditor() {
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = this.getFileChooser();
        int returnVal = chooser.showDialog(null, "Select");
        if (returnVal == 0) {
            String newFilename = chooser.getSelectedFile().getAbsolutePath();
            newFilename = this.cleanUpName(newFilename);
            this.button.setText(newFilename);
            this.firePropertyChange();
        }
    }

    protected String cleanUpName(String name) {
        return name.replace('\\', '/');
    }

    public Component getCustomEditor() {
        this.button.addActionListener(this);
        return this.button;
    }

    public JFileChooser getFileChooser() {
        return new JFileChooser(this.getLastLocation());
    }

    public void setValue(Object someObj) {
        if (someObj instanceof String) {
            this.button.setText((String)someObj);
        }
    }

    public String getAsText() {
        return this.button.getText();
    }

    public String getLastLocation() {
        String substring;
        String currentLocation = this.getAsText();
        int sepChar = 47;
        int lastSepIndex = currentLocation.lastIndexOf(sepChar);
        currentLocation = currentLocation.equals("") || lastSepIndex == -1 ? null : (substring = currentLocation.substring(0, lastSepIndex));
        return currentLocation;
    }
}

