/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.Environment;
import com.bbn.openmap.InformationDelegator;
import com.bbn.openmap.event.InfoDisplayEvent;
import com.bbn.openmap.util.Debug;
import edu.stanford.ejalbert.BrowserLauncher;
import java.applet.Applet;
import java.applet.AppletContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;

public class WebBrowser {
    Process proc = null;
    InformationDelegator info = null;
    boolean oldWay = false;

    protected String generateLaunchCmd(String url) {
        return Environment.get("openmap.WebBrowser") + " " + url;
    }

    protected String writeFileAndGenerateURL(String text) {
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("openmap", ".html", new File(Environment.get("openmap.TempDirectory")));
            tmpFile.deleteOnExit();
            FileOutputStream fs = new FileOutputStream(tmpFile);
            PrintWriter out = new PrintWriter(fs);
            out.println(text);
            out.close();
            String urlString = tmpFile.toURL().toString();
            Debug.output("WebBrowser: created " + urlString);
            return urlString;
        }
        catch (SecurityException se) {
            Debug.error("WebBrowser.writeAndGenerateURL: " + se);
        }
        catch (IOException ioe) {
            Debug.error("WebBrowser.writeAndGenerateURL: " + ioe);
        }
        this.postErrorMessage("Cannot write to temp file:" + (tmpFile != null ? tmpFile.getAbsolutePath() : "unknown"));
        return null;
    }

    protected void sendTo(String url) {
        if (!this.oldWay) {
            try {
                BrowserLauncher.openURL(url);
            }
            catch (IOException ioe) {
                Debug.error("WebBrowser caught IOException loading webpage (" + url.toString() + ")\n" + ioe.getMessage());
            }
            return;
        }
        String arch = Environment.get("os.arch");
        String osname = Environment.get("os.name");
        if (Environment.isApplet()) {
            try {
                Applet applet = Environment.getApplet();
                AppletContext ac = applet.getAppletContext();
                ac.showDocument(new URL(url), "otherFrame");
            }
            catch (MalformedURLException e) {
                System.err.println("WebBrowser.sendTo: " + e);
                this.postErrorMessage("Cannot show document: " + Environment.get("line.separator") + e);
            }
            return;
        }
        String cmd = arch.equals("x86") ? Environment.get("openmap.WebBrowser") + " " + url : Environment.get("openmap.WebBrowser") + " -remote OpenURL(" + url + ")";
        try {
            Debug.message("www", "WebBrowser.sendTo: " + cmd);
            Runtime.getRuntime().exec(cmd).waitFor();
        }
        catch (IOException e) {
            System.err.println("WebBrowser.sendTo: " + e);
            this.postErrorMessage("Cannot start WebBrowser: " + Environment.get("line.separator") + e);
        }
        catch (InterruptedException f) {
            System.err.println("WebBrowser.sendTo: interrupted");
        }
    }

    public void setInfoDelegator(InformationDelegator info) {
        this.info = info;
    }

    public void launch(String urlString) {
        String launchCmd = null;
        if (this.oldWay && this.proc == null && !Environment.isApplet()) {
            try {
                launchCmd = this.generateLaunchCmd(urlString);
                Debug.message("www", "WebBrowser.launch: " + launchCmd);
                this.proc = Runtime.getRuntime().exec(launchCmd);
            }
            catch (IOException e) {
                System.err.println("WebBrowser.launch: " + e);
                this.postErrorMessage("Cannot start WebBrowser: " + Environment.get("line.separator") + "\"" + launchCmd + "\"");
            }
        } else {
            this.sendTo(urlString);
        }
    }

    private void postErrorMessage(String message) {
        this.info.requestMessage(new InfoDisplayEvent(this, message));
    }

    public void writeAndLaunch(String text) {
        String cmd = null;
        if (this.oldWay && this.proc == null && !Environment.isApplet()) {
            try {
                cmd = this.generateLaunchCmd(this.writeFileAndGenerateURL(text));
                this.proc = Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                System.err.println("WebBrowser.writeAndLaunch: " + e);
                this.postErrorMessage("Cannot start WebBrowser: " + Environment.get("line.separator") + "\"" + cmd + "\"");
            }
        } else {
            this.sendTo(this.writeFileAndGenerateURL(text));
        }
    }

    public void exitValue() {
        if (this.proc == null) {
            return;
        }
        try {
            this.proc.exitValue();
            Debug.message("www", "WebBrowser.exitValue: WebBrowser died");
            this.proc = null;
        }
        catch (IllegalStateException e) {
        }
        catch (IllegalThreadStateException f) {}
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.out.println("Give WebBrowser a URL, and it'll launch it.");
            System.exit(0);
        }
        String url = argv[0];
        try {
            BrowserLauncher.openURL(url);
        }
        catch (IOException ioe) {
            Debug.error("WebBrowser caught IOException loading webpage (" + url.toString() + ")\n" + ioe.getMessage());
        }
    }
}

