/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.util.Debug;
import javax.swing.SwingUtilities;

public abstract class SwingWorker {
    private Object value;
    private Thread thread;

    public void setValue(Object sv) {
        this.value = sv;
    }

    public void setThread(Thread t) {
        this.thread = t;
        if (this.thread != null) {
            this.thread.start();
        }
    }

    public abstract Object construct();

    public void finished() {
    }

    public void interrupt() {
        Thread t = this.thread;
        if (t != null) {
            t.interrupt();
        }
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() {
        while (true) {
            Thread t;
            SwingWorker swingWorker = this;
            synchronized (swingWorker) {
                t = this.thread;
                if (t == null) {
                    return this.value;
                }
            }
            try {
                t.join();
            }
            catch (InterruptedException e) {
            }
        }
    }

    public void execute() {
        final Runnable doFinished = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SwingWorker swingWorker = SwingWorker.this;
                synchronized (swingWorker) {
                    try {
                        SwingWorker.this.value = SwingWorker.this.construct();
                    }
                    catch (Exception e) {
                        e.printStackTrace(Debug.err);
                        SwingWorker.this.value = null;
                    }
                    SwingWorker.this.thread = null;
                }
                SwingUtilities.invokeLater(doFinished);
            }
        };
        this.thread = new Thread(doConstruct);
        this.thread.start();
    }
}

