/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import java.awt.Point;
import java.awt.geom.Point2D;

public class DataBounds {
    protected Point2D min;
    protected Point2D max;

    public DataBounds() {
    }

    public DataBounds(double minx, double miny, double maxx, double maxy) {
        this.add(minx, miny);
        this.add(maxx, maxy);
    }

    public DataBounds(Point minP, Point maxP) {
        this.add(minP);
        this.add(maxP);
    }

    public Point2D getCenter() {
        if (this.min != null) {
            double minx = this.min.getX();
            double miny = this.min.getY();
            double maxx = this.max.getX();
            double maxy = this.max.getY();
            return new Point2D.Double((minx + maxx) / 2.0, (miny + maxy) / 2.0);
        }
        return null;
    }

    public Point2D getMax() {
        return this.max;
    }

    public Point2D getMin() {
        return this.min;
    }

    public void add(double x, double y) {
        if (this.min == null) {
            this.min = new Point2D.Double(x, y);
            this.max = new Point2D.Double(x, y);
        } else {
            double minx = this.min.getX();
            double miny = this.min.getY();
            double maxx = this.max.getX();
            double maxy = this.max.getY();
            if (minx > x) {
                minx = x;
            }
            if (miny > y) {
                miny = y;
            }
            if (maxx < x) {
                maxx = x;
            }
            if (maxy < y) {
                maxy = y;
            }
            this.min.setLocation(minx, miny);
            this.max.setLocation(maxx, maxy);
        }
    }

    public void add(Point2D point) {
        this.add(point.getX(), point.getY());
    }
}

