/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.coords.UTMPoint;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;

public class MGRSPoint
extends UTMPoint {
    protected static final int NUM_100K_SETS = 6;
    public static final int[] SET_ORIGIN_COLUMN_LETTERS = new int[]{65, 74, 83, 65, 74, 83};
    public static final int[] SET_ORIGIN_ROW_LETTERS = new int[]{65, 70, 65, 70, 65, 70};
    public static final int[] BESSEL_SET_ORIGIN_COLUMN_LETTERS = new int[]{65, 74, 83, 65, 74, 83};
    public static final int[] BESSEL_SET_ORIGIN_ROW_LETTERS = new int[]{76, 82, 76, 82, 76, 82};
    public static final int SET_NORTHING_ROLLOVER = 20000000;
    public static final int ACCURACY_1_METER = 5;
    public static final int ACCURACY_10_METER = 4;
    public static final int ACCURACY_100_METER = 3;
    public static final int ACCURACY_1000_METER = 2;
    public static final int ACCURACY_10000_METER = 1;
    protected int[] originColumnLetters = SET_ORIGIN_COLUMN_LETTERS;
    protected int[] originRowLetters = SET_ORIGIN_ROW_LETTERS;
    public static final int A = 65;
    public static final int I = 73;
    public static final int O = 79;
    public static final int V = 86;
    public static final int Z = 90;
    protected boolean DEBUG = false;
    protected String mgrs;
    protected int accuracy = 5;

    public MGRSPoint() {
        this.DEBUG = Debug.debugging("mgrs");
    }

    public MGRSPoint(String mgrsString) {
        this();
        this.setMGRS(mgrsString);
    }

    public MGRSPoint(MGRSPoint point) {
        this();
        this.mgrs = point.mgrs;
        this.northing = point.northing;
        this.easting = point.easting;
        this.zone_number = point.zone_number;
        this.zone_letter = point.zone_letter;
        this.accuracy = point.accuracy;
    }

    public MGRSPoint(float northing, float easting, int zoneNumber, char zoneLetter) {
        super(northing, easting, zoneNumber, zoneLetter);
    }

    public MGRSPoint(LatLonPoint llpoint) {
        this(llpoint, Ellipsoid.WGS_84);
    }

    public MGRSPoint(LatLonPoint llpoint, Ellipsoid ellip) {
        this();
        MGRSPoint.LLtoMGRS(llpoint, ellip, this);
    }

    public void setMGRS(String mgrsString) {
        try {
            this.mgrs = mgrsString.toUpperCase();
            this.decode(this.mgrs);
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            throw new NumberFormatException("MGRSPoint has bad string: " + mgrsString);
        }
        catch (NullPointerException npe) {
        }
    }

    public String getMGRS() {
        if (this.mgrs == null) {
            this.resolve();
        }
        return this.mgrs;
    }

    public LatLonPoint toLatLonPoint() {
        return this.toLatLonPoint(Ellipsoid.WGS_84, new LatLonPoint());
    }

    public LatLonPoint toLatLonPoint(Ellipsoid ellip) {
        return this.toLatLonPoint(ellip, new LatLonPoint());
    }

    public LatLonPoint toLatLonPoint(Ellipsoid ellip, LatLonPoint llpoint) {
        return MGRSPoint.MGRStoLL(this, ellip, llpoint);
    }

    public String toString() {
        return "MGRSPoint[" + this.mgrs + "]";
    }

    public static LatLonPoint MGRStoLL(MGRSPoint mgrsp, Ellipsoid ellip, LatLonPoint llp) {
        return UTMPoint.UTMtoLL(mgrsp, ellip, llp);
    }

    public static MGRSPoint LLtoMGRS(LatLonPoint llpoint) {
        return MGRSPoint.LLtoMGRS(llpoint, Ellipsoid.WGS_84, new MGRSPoint());
    }

    public static MGRSPoint LLtoMGRS(LatLonPoint llpoint, MGRSPoint mgrsp) {
        return MGRSPoint.LLtoMGRS(llpoint, Ellipsoid.WGS_84, mgrsp);
    }

    public static MGRSPoint LLtoMGRS(LatLonPoint llp, Ellipsoid ellip, MGRSPoint mgrsp) {
        mgrsp = (MGRSPoint)UTMPoint.LLtoUTM(llp, ellip, mgrsp);
        mgrsp.resolve();
        return mgrsp;
    }

    public void setAccuracy(int value) {
        this.accuracy = value;
        this.mgrs = null;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    /*
     * WARNING - void declaration
     */
    protected void decode(String mgrsString) throws NumberFormatException {
        int remainder;
        char testChar;
        if (mgrsString == null || mgrsString.length() == 0) {
            throw new NumberFormatException("MGRSPoint coverting from nothing");
        }
        int length = mgrsString.length();
        String hunK = null;
        Object seasting = null;
        Object snorthing = null;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (!Character.isLetter(testChar = mgrsString.charAt(i))) {
            void var7_8;
            if (i > 2) {
                throw new NumberFormatException("MGRSPoint bad conversion from: " + mgrsString);
            }
            sb.append((char)var7_8);
            ++i;
        }
        this.zone_number = Integer.parseInt(sb.toString());
        if (i == 0 || i + 3 > length) {
            throw new NumberFormatException("MGRSPoint bad conversion from: " + mgrsString);
        }
        this.zone_letter = mgrsString.charAt(i++);
        if (this.zone_letter <= 'A' || this.zone_letter == 'B' || this.zone_letter == 'Y' || this.zone_letter >= 'Z' || this.zone_letter == 'I' || this.zone_letter == 'O') {
            throw new NumberFormatException("MGRSPoint zone letter " + this.zone_letter + " not handled: " + mgrsString);
        }
        hunK = mgrsString.substring(i, i += 2);
        int set = this.get100kSetForZone(this.zone_number);
        float east100k = this.getEastingFromChar(hunK.charAt(0), set);
        float north100k = this.getNorthingFromChar(hunK.charAt(1), set);
        if (this.zone_letter == 'Q' && north100k < 1700000.0f || this.zone_letter >= 'R') {
            north100k += 2000000.0f;
            if (this.DEBUG) {
                Debug.output(" northing rolled over 18, adding 200k to " + north100k);
            }
        }
        if (this.zone_letter == 'S' && north100k < 3000000.0f || this.zone_letter >= 'T') {
            north100k += 2000000.0f;
            if (this.DEBUG) {
                Debug.output(" northing rolled over 36, adding 200k to " + north100k);
            }
        }
        if (this.zone_letter == 'U' && north100k < 5330000.0f || this.zone_letter >= 'V') {
            north100k += 2000000.0f;
            if (this.DEBUG) {
                Debug.output(" northing rolled over 54, adding 200k to " + north100k);
            }
        }
        if (this.zone_letter >= 'X') {
            north100k += 2000000.0f;
            if (this.DEBUG) {
                Debug.output(" northing rolled over 72, adding 200k to " + north100k);
            }
            if (north100k > 9500000.0f) {
                north100k -= 2000000.0f;
                if (this.DEBUG) {
                    Debug.output(" - rolling back to " + north100k);
                }
            }
        }
        if ((remainder = length - i) % 2 != 0) {
            throw new NumberFormatException("MGRSPoint has to have an even number \nof digits after the zone letter and two 100km letters - front \nhalf for easting meters, second half for \nnorthing meters" + mgrsString);
        }
        int sep = remainder / 2;
        float sepEasting = 0.0f;
        float sepNorthing = 0.0f;
        if (sep > 0) {
            if (this.DEBUG) {
                Debug.output(" calculating e/n from " + this.mgrs.substring(i));
            }
            float accuracyBonus = 100000.0f / (float)Math.pow(10.0, sep);
            if (this.DEBUG) {
                Debug.output(" calculated accuracy bonus as  " + accuracyBonus);
            }
            String sepEastingString = mgrsString.substring(i, i + sep);
            if (this.DEBUG) {
                Debug.output(" parsed easting as " + sepEastingString);
            }
            sepEasting = Float.parseFloat(sepEastingString) * accuracyBonus;
            String sepNorthingString = mgrsString.substring(i + sep);
            if (this.DEBUG) {
                Debug.output(" parsed northing as " + sepNorthingString);
            }
            sepNorthing = Float.parseFloat(sepNorthingString) * accuracyBonus;
        }
        this.easting = sepEasting + east100k;
        this.northing = sepNorthing + north100k;
        if (this.DEBUG) {
            Debug.output("Decoded " + mgrsString + " as zone number: " + this.zone_number + ", zone letter: " + this.zone_letter + ", easting: " + this.easting + ", northing: " + this.northing + ", 100k: " + hunK);
        }
    }

    protected void resolve() {
        this.resolve(this.accuracy);
    }

    protected void resolve(int digitAccuracy) {
        StringBuffer sb = new StringBuffer(this.zone_number + "" + this.zone_letter + this.get100kID(this.easting, this.northing, this.zone_number));
        StringBuffer seasting = new StringBuffer(Integer.toString((int)this.easting));
        StringBuffer snorthing = new StringBuffer(Integer.toString((int)this.northing));
        if (this.DEBUG) {
            Debug.output(" Resolving MGRS from easting: " + seasting + " derived from " + this.easting + ", and northing: " + snorthing + " derived from " + this.northing);
        }
        while (digitAccuracy > seasting.length()) {
            seasting.insert(0, '0');
        }
        while (digitAccuracy > snorthing.length()) {
            snorthing.insert(0, '0');
        }
        while (snorthing.length() > 6) {
            snorthing.deleteCharAt(0);
        }
        if (this.DEBUG) {
            Debug.output(" -- modified easting: " + seasting + " and northing: " + snorthing);
        }
        try {
            sb.append(seasting.substring(1, digitAccuracy + 1) + snorthing.substring(1, digitAccuracy + 1));
            this.mgrs = sb.toString();
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.mgrs = null;
        }
    }

    protected int get100kSetForZone(int i) {
        int set = i % 6;
        if (set == 0) {
            set = 6;
        }
        return set;
    }

    protected int[] getOriginColumnLetters() {
        return this.originColumnLetters;
    }

    protected void setOriginColumnLetters(int[] letters) {
        this.originColumnLetters = letters;
    }

    protected int[] getOriginRowLetters() {
        return this.originRowLetters;
    }

    protected void setOriginRowLetters(int[] letters) {
        this.originRowLetters = letters;
    }

    protected String get100kID(float easting, float northing, int zone_number) {
        int set = this.get100kSetForZone(zone_number);
        int setColumn = (int)easting / 100000;
        int setRow = (int)northing / 100000 % 20;
        return this.get100kID(setColumn, setRow, set);
    }

    protected float getEastingFromChar(char e, int set) {
        int[] baseCol = this.getOriginColumnLetters();
        int curCol = baseCol[set - 1];
        float eastingValue = 100000.0f;
        while (curCol != e) {
            if (++curCol == 73) {
                ++curCol;
            }
            if (curCol == 79) {
                ++curCol;
            }
            if (curCol > 90) {
                curCol = 65;
            }
            eastingValue += 100000.0f;
        }
        if (this.DEBUG) {
            Debug.output("Easting value for " + e + " from set: " + set + ", col: " + curCol + " is " + eastingValue);
        }
        return eastingValue;
    }

    protected float getNorthingFromChar(char n, int set) {
        int[] baseRow = this.getOriginRowLetters();
        int curRow = baseRow[set - 1];
        float northingValue = 0.0f;
        while (curRow != n) {
            if (++curRow == 73) {
                ++curRow;
            }
            if (curRow == 79) {
                ++curRow;
            }
            if (curRow > 86) {
                curRow = 65;
            }
            northingValue += 100000.0f;
        }
        if (this.DEBUG) {
            Debug.output("Northing value for " + n + " from set: " + set + ", row: " + curRow + " is " + northingValue);
        }
        return northingValue;
    }

    protected String get100kID(int setColumn, int setRow, int set) {
        if (this.DEBUG) {
            System.out.println("set (" + set + ") column = " + setColumn + ", row = " + setRow);
        }
        int[] baseCol = this.getOriginColumnLetters();
        int[] baseRow = this.getOriginRowLetters();
        int colOrigin = baseCol[set - 1];
        int rowOrigin = baseRow[set - 1];
        if (this.DEBUG) {
            System.out.println("starting at = " + (char)colOrigin + (char)rowOrigin);
        }
        int colInt = colOrigin + setColumn - 1;
        int rowInt = rowOrigin + setRow;
        boolean rollover = false;
        if (colInt > 90) {
            colInt = colInt - 90 + 65 - 1;
            rollover = true;
            if (this.DEBUG) {
                System.out.println("rolling over col, new value: " + (char)colInt);
            }
        }
        if (colInt == 73 || colOrigin < 73 && colInt > 73 || (colInt > 73 || colOrigin < 73) && rollover) {
            ++colInt;
            if (this.DEBUG) {
                System.out.println("skipping I in col, new value: " + (char)colInt);
            }
        }
        if (colInt == 79 || colOrigin < 79 && colInt > 79 || (colInt > 79 || colOrigin < 79) && rollover) {
            ++colInt;
            if (this.DEBUG) {
                System.out.println("skipping O in col, new value: " + (char)colInt);
            }
            if (colInt == 73) {
                ++colInt;
                if (this.DEBUG) {
                    System.out.println("  hit I, new value: " + (char)colInt);
                }
            }
        }
        if (colInt > 90) {
            colInt = colInt - 90 + 65 - 1;
            if (this.DEBUG) {
                System.out.println("rolling(2) col, new value: " + (char)rowInt);
            }
        }
        if (rowInt > 86) {
            rowInt = rowInt - 86 + 65 - 1;
            rollover = true;
            if (this.DEBUG) {
                System.out.println("rolling over row, new value: " + (char)rowInt);
            }
        } else {
            rollover = false;
        }
        if (rowInt == 73 || rowOrigin < 73 && rowInt > 73 || (rowInt > 73 || rowOrigin < 73) && rollover) {
            ++rowInt;
            if (this.DEBUG) {
                System.out.println("skipping I in row, new value: " + (char)rowInt);
            }
        }
        if (rowInt == 79 || rowOrigin < 79 && rowInt > 79 || (rowInt > 79 || rowOrigin < 79) && rollover) {
            ++rowInt;
            if (this.DEBUG) {
                System.out.println("skipping O in row, new value: " + (char)rowInt);
            }
            if (rowInt == 73) {
                ++rowInt;
                if (this.DEBUG) {
                    System.out.println("  hit I, new value: " + (char)rowInt);
                }
            }
        }
        if (rowInt > 86) {
            rowInt = rowInt - 86 + 65 - 1;
            if (this.DEBUG) {
                System.out.println("rolling(2) row, new value: " + (char)rowInt);
            }
        }
        String twoLetter = (char)colInt + "" + (char)rowInt;
        if (this.DEBUG) {
            System.out.println("ending at = " + twoLetter);
        }
        return twoLetter;
    }

    protected void print100kSets() {
        StringBuffer sb = null;
        int set = 1;
        while (set <= 6) {
            System.out.println("-------------\nFor 100K Set " + set + ":\n-------------\n");
            int i = 19;
            while (i >= 0) {
                sb = new StringBuffer(i * 100000 + "\t| ");
                int j = 1;
                while (j <= 8) {
                    sb.append(" " + this.get100kID(j, i, set));
                    ++j;
                }
                sb.append(" |");
                System.out.println(sb);
                --i;
            }
            ++set;
        }
    }

    public static void main(String[] argv) {
        block8: {
            MGRSPoint mgrsp;
            String[] arg;
            Debug.init();
            ArgParser ap = new ArgParser("MGRSPoint");
            ap.add("mgrs", "Print Latitude and Longitude for MGRS value", 1);
            ap.add("latlon", "Print MGRS for Latitude and Longitude values", 2, true);
            ap.add("sets", "Print the MGRS 100k table");
            ap.add("altsets", "Print the MGRS 100k table for the Bessel ellipsoid");
            if (!ap.parse(argv)) {
                ap.printUsage();
                System.exit(0);
            }
            if ((arg = ap.getArgValues("sets")) != null) {
                new MGRSPoint().print100kSets();
            }
            if ((arg = ap.getArgValues("altsets")) != null) {
                mgrsp = new MGRSPoint();
                mgrsp.setOriginColumnLetters(BESSEL_SET_ORIGIN_COLUMN_LETTERS);
                mgrsp.setOriginRowLetters(BESSEL_SET_ORIGIN_ROW_LETTERS);
                mgrsp.print100kSets();
            }
            if ((arg = ap.getArgValues("mgrs")) != null) {
                try {
                    mgrsp = new MGRSPoint(arg[0]);
                    Debug.output(arg[0] + " is " + mgrsp.toLatLonPoint());
                }
                catch (NumberFormatException nfe) {
                    Debug.error(nfe.getMessage());
                }
            }
            if ((arg = ap.getArgValues("latlon")) == null) break block8;
            try {
                float lat = Float.parseFloat(arg[0]);
                float lon = Float.parseFloat(arg[1]);
                LatLonPoint llp = new LatLonPoint(lat, lon);
                MGRSPoint mgrsp2 = MGRSPoint.LLtoMGRS(llp);
                Debug.output(llp + " is " + mgrsp2);
            }
            catch (NumberFormatException nfe) {
                Debug.error("The numbers provided:  " + argv[0] + ", " + argv[1] + " aren't valid");
            }
        }
    }
}

