/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.Cylindrical;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.Debug;
import java.awt.Point;

public class LLXY
extends Cylindrical
implements EqualArc {
    public static final transient String LLXYName = "LLXY";
    public static final transient int LLXYType = 6304;
    protected int hy;
    protected int wx;
    protected float cLon;
    protected float cLat;
    protected float ppd;

    public LLXY(LatLonPoint center, float scale, int width, int height) {
        super(center, scale, width, height, 6304);
    }

    public LLXY(LatLonPoint center, float scale, int width, int height, int type) {
        super(center, scale, width, height, type);
    }

    public String toString() {
        return "LLXY[" + super.toString() + "]";
    }

    protected void computeParameters() {
        Debug.message("proj", "LLXY.computeParameters()");
        super.computeParameters();
        this.hy = this.height / 2;
        this.wx = this.width / 2;
        this.cLon = ProjMath.radToDeg(this.ctrLon);
        this.cLat = ProjMath.radToDeg(this.ctrLat);
        this.ppd = (float)this.world.x / 360.0f;
        float latLimit = 90.0f - (float)this.hy / this.ppd;
        if (this.cLat > latLimit) {
            this.cLat = latLimit;
            this.ctrLon = ProjMath.degToRad(this.cLat);
        } else if (this.cLat < -latLimit) {
            this.cLat = -latLimit;
            this.ctrLon = ProjMath.degToRad(this.cLat);
        }
        if (Debug.debugging("llxy")) {
            Debug.output("LLXY.computeParameters: with center lat:" + this.cLat + ", lon:" + this.cLon + " | width:" + this.width + ", height:" + this.height + " | scale:" + this.scale);
        }
    }

    public float normalize_latitude(float lat) {
        if (lat > 1.5707964f) {
            return 1.5707964f;
        }
        if (lat < -1.5707964f) {
            return -1.5707964f;
        }
        return lat;
    }

    public boolean isPlotable(float lat, float lon) {
        return true;
    }

    public Point forward(LatLonPoint pt, Point p) {
        return this.forward(pt.getLatitude(), pt.getLongitude(), p, false);
    }

    public Point forward(float lat, float lon, Point p) {
        return this.forward(lat, lon, p, false);
    }

    public Point forward(float lat, float lon, Point p, boolean isRadian) {
        if (isRadian) {
            lat = ProjMath.radToDeg(this.normalize_latitude(lat));
            lon = ProjMath.radToDeg(lon);
        } else {
            lat = Length.DECIMAL_DEGREE.fromRadians(this.normalize_latitude(Length.DECIMAL_DEGREE.toRadians(lat)));
        }
        float newLon = Length.DECIMAL_DEGREE.fromRadians(Proj.wrap_longitude(Length.DECIMAL_DEGREE.toRadians(lon - this.cLon)));
        p.x = this.wx + Math.round(newLon * this.ppd);
        p.y = this.hy - Math.round((lat - this.cLat) * this.ppd);
        if (Debug.debugging("llxydetail")) {
            Debug.output("LLXY.forward(lon:" + ProjMath.radToDeg(lon) + ", lat:" + ProjMath.radToDeg(lat) + " isRadian:" + isRadian + ")");
            Debug.output("LLXY.forward   x:" + p.x + ", y:" + p.y + " scale: " + this.scale);
        }
        return p;
    }

    public LatLonPoint inverse(Point pt, LatLonPoint llp) {
        return this.inverse(pt.x, pt.y, llp);
    }

    public LatLonPoint inverse(int x, int y, LatLonPoint llp) {
        llp.setLongitude((float)(x - this.wx) / this.ppd + this.cLon);
        llp.setLatitude((float)(this.hy - y) / this.ppd + this.cLat);
        return llp;
    }

    public String getName() {
        return LLXYName;
    }

    public double getXPixConstant() {
        return (double)this.ppd * 360.0;
    }

    public double getYPixConstant() {
        return (double)this.ppd * 90.0;
    }
}

