/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MoreMath;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.util.ArrayList;

public abstract class Cylindrical
extends Proj {
    protected Point world;
    protected int half_world;

    public Cylindrical(LatLonPoint center, float scale, int width, int height, int type) {
        super(center, scale, width, height, type);
    }

    public String toString() {
        return " world(" + this.world.x + "," + this.world.y + ")" + super.toString();
    }

    protected void computeParameters() {
        this.planetPixelRadius = this.planetRadius * (float)this.pixelsPerMeter;
        this.planetPixelCircumference = (float)Math.PI * 2 * this.planetPixelRadius;
        this.minscale = (float)Math.ceil(this.planetPixelCircumference / 2.1474836E9f);
        if (this.minscale < 1.0f) {
            this.minscale = 1.0f;
        }
        if (this.scale < this.minscale) {
            this.scale = this.minscale;
        }
        this.maxscale = this.planetPixelCircumference / (float)this.width;
        if (this.maxscale < this.minscale) {
            this.maxscale = this.minscale;
        }
        if (this.scale > this.maxscale) {
            this.scale = this.maxscale;
        }
        this.scaled_radius = this.planetPixelRadius / this.scale;
        if (this.world == null) {
            this.world = new Point(0, 0);
        }
        this.world.x = (int)(this.planetPixelCircumference / this.scale);
        this.half_world = this.world.x / 2;
        this.XSCALE_THRESHOLD = (int)(this.planetPixelCircumference / 64000.0f);
        if (Debug.debugging("proj")) {
            Debug.output("Cylindrical.computeParameters(): world.x = " + this.world.x + " half_world = " + this.half_world + " XSCALE_THRESHOLD = " + this.XSCALE_THRESHOLD);
        }
    }

    public void pan(float Az) {
        if (MoreMath.approximately_equal(Math.abs(Az), 180.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width / 2, this.height));
        } else if (MoreMath.approximately_equal(Az, -135.0f, 0.01f)) {
            this.setCenter(this.inverse(0, this.height));
        } else if (MoreMath.approximately_equal(Az, -90.0f, 0.01f)) {
            this.setCenter(this.inverse(0, this.height / 2));
        } else if (MoreMath.approximately_equal(Az, -45.0f, 0.01f)) {
            this.setCenter(this.inverse(0, 0));
        } else if (MoreMath.approximately_equal(Az, 0.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width / 2, 0));
        } else if (MoreMath.approximately_equal(Az, 45.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width, 0));
        } else if (MoreMath.approximately_equal(Az, 90.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width, this.height / 2));
        } else if (MoreMath.approximately_equal(Az, 135.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width, this.height));
        } else {
            super.pan(Az);
        }
    }

    public LatLonPoint getUpperLeft() {
        return this.inverse(0, 0);
    }

    public LatLonPoint getLowerRight() {
        return this.inverse(this.width, this.height);
    }

    public boolean forwardRaw(float[] rawllpts, int rawoff, int[] xcoords, int[] ycoords, boolean[] visible, int copyoff, int copylen) {
        Point temp = new Point();
        int end = copylen + copyoff;
        int i = copyoff;
        int j = rawoff;
        while (i < end) {
            this.forward(rawllpts[j], rawllpts[j + 1], temp, true);
            xcoords[i] = temp.x;
            ycoords[i] = temp.y;
            visible[i] = true;
            ++i;
            j += 2;
        }
        return true;
    }

    protected ArrayList _forwardPoly(float[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        int flag = 0;
        int min = 0;
        int max = 0;
        int xadj = 0;
        int len = rawllpts.length >> 1;
        if (len < 2) {
            return new ArrayList(0);
        }
        if (this.isComplicatedLineType(ltype)) {
            return this.doPolyDispatch(rawllpts, ltype, nsegs, isFilled);
        }
        Point temp = new Point(0, 0);
        int[] xs = new int[len];
        int[] ys = new int[len];
        this.forward(rawllpts[0], rawllpts[1], temp, true);
        int xp = temp.x;
        xs[0] = temp.x;
        ys[0] = temp.y;
        int n = 1;
        int k = 2;
        while (n < len) {
            this.forward(rawllpts[k], rawllpts[k + 1], temp, true);
            xs[n] = temp.x;
            ys[n] = temp.y;
            if (Math.abs(xp - xs[n]) >= this.half_world) {
                min = (flag += xp < xs[n] ? -1 : 1) < min ? flag : min;
                max = flag > max ? flag : max;
                xadj = flag * this.world.x;
            }
            xp = temp.x;
            if (flag != 0) {
                int n2 = n;
                xs[n2] = xs[n2] + xadj;
            }
            ++n;
            k += 2;
        }
        ArrayList<int[]> ret_val = null;
        ret_val = new ArrayList<int[]>(2 + 2 * (max + (min *= -1)));
        ret_val.add(xs);
        ret_val.add(ys);
        int[] altx = null;
        int i = 1;
        while (i <= min) {
            altx = new int[xs.length];
            xadj = i * this.world.x;
            int j = 0;
            while (j < altx.length) {
                altx[j] = xs[j] + xadj;
                ++j;
            }
            ret_val.add(altx);
            ret_val.add(ys);
            ++i;
        }
        int i2 = 1;
        while (i2 <= max) {
            altx = new int[xs.length];
            xadj = -i2 * this.world.x;
            int j = 0;
            while (j < altx.length) {
                altx[j] = xs[j] + xadj;
                ++j;
            }
            ret_val.add(altx);
            ret_val.add(ys);
            ++i2;
        }
        return ret_val;
    }

    private static final void dumpPoly(float[] rawllpts, int[] xs, int[] ys) {
        Debug.output("poly:");
        int i = 0;
        int j = 0;
        while (j < xs.length) {
            System.out.print("[" + ProjMath.radToDeg(rawllpts[i]) + "," + ProjMath.radToDeg(rawllpts[i + 1]) + "]=");
            Debug.output("(" + xs[j] + "," + ys[j] + ")");
            i += 2;
            ++j;
        }
        Debug.output("");
    }

    public void drawBackground(Graphics2D g, Paint paint) {
        g.setPaint(paint);
        this.drawBackground(g);
    }

    public void drawBackground(Graphics g) {
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public String getName() {
        return "Cylindrical";
    }
}

