/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.grid;

import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGrid;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.omGraphics.SinkGraphic;
import com.bbn.openmap.omGraphics.grid.ElevationMBandGenerator;
import com.bbn.openmap.omGraphics.grid.GridData;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;

public class ContourLineGenerator
extends ElevationMBandGenerator {
    protected int lineColor = -65536;
    protected int backColor = 0;

    public OMGraphic generate(OMGrid grid, Projection proj) {
        Debug.message("grid", "ContourLineGenerator: generating OMRaster from grid");
        OMRaster raster = new OMRaster(grid.point1.x, grid.point1.y, grid.width, grid.height, new int[grid.width * grid.height]);
        if (grid.height == 0 || grid.width == 0) {
            Debug.message("grid", "ContourLineGenerator: grid height/width ZERO!");
            return raster;
        }
        GridData gd = grid.getData();
        if (!(gd instanceof GridData.Int)) {
            Debug.message("grid", "SimpleColorGenerator: grid doesn't contain integer data.");
            return SinkGraphic.getSharedInstance();
        }
        int rows = grid.getRows();
        int columns = grid.getColumns();
        int[][] data = ((GridData.Int)gd).getData();
        boolean major = grid.getMajor();
        double y_interval = (double)rows / (double)grid.height;
        double x_interval = (double)columns / (double)grid.width;
        Debug.message("grid", "ContourLineGenerator: y_point_interval = " + y_interval + ", x_point_interval = " + x_interval);
        int[][] values = new int[grid.width][grid.height];
        int x = 0;
        while (x < grid.width) {
            int y = 0;
            while (y < grid.height) {
                int value;
                int post_x = (int)Math.round(x_interval * (double)x);
                int post_y = grid.getRenderType() == 1 ? (int)Math.round(y_interval * ((double)(grid.height - 1) - (double)y)) : (int)Math.round(y_interval * (double)y);
                if (major) {
                    if (post_x >= columns) {
                        post_x = columns - 1;
                    }
                    if (post_y >= rows) {
                        post_y = rows - 1;
                    }
                    value = this.calibratePointValue(data[post_x][post_y]);
                } else {
                    if (post_y >= columns) {
                        post_y = columns - 1;
                    }
                    if (post_x >= rows) {
                        post_x = rows - 1;
                    }
                    value = this.calibratePointValue(data[post_y][post_x]);
                }
                values[x][y] = value;
                if (value != 0) {
                    raster.setPixel(x, y, this.checkData(values, x, y));
                } else {
                    raster.setPixel(x, y, this.backColor);
                }
                ++y;
            }
            ++x;
        }
        raster.generate(proj);
        return raster;
    }

    public int calibratePointValue(int source) {
        return super.calibratePointValue((int)((float)source * 3.2f));
    }

    protected int checkData(int[][] pastValues, int x, int y) {
        int ret = this.backColor;
        int offx = -1;
        while (offx < 1) {
            int offy = -1;
            while (offy < 1) {
                if (offx != 0 && offy != 0) {
                    int check;
                    int checkx = x + offx;
                    int checky = y + offy;
                    if (checkx >= 0 && checky >= 0 && (check = pastValues[checkx][checky]) != 0 && check != pastValues[x][y]) {
                        ret = this.lineColor;
                        return ret;
                    }
                }
                ++offy;
            }
            ++offx;
        }
        return ret;
    }

    public boolean needGenerateToRender() {
        return true;
    }
}

