/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.Projection;
import java.awt.Graphics;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class OMRangeRings
extends OMCircle
implements Serializable {
    protected transient OMCircle[] subCircles = null;
    protected transient OMText[] labels = null;
    public static final int DEFAULT_INTERVAL = 4;
    protected int interval = 4;
    protected Length intervalUnits = null;
    protected DrawingAttributes drawingAttributes = new DrawingAttributes();
    protected OMPoint centerPoint;
    public static final DecimalFormat DEFAULT_FORMAT = new DecimalFormat();
    protected NumberFormat form = DEFAULT_FORMAT;
    protected boolean drawLabels = true;

    public OMRangeRings(float latPoint, float lonPoint, float radius) {
        this(new LatLonPoint(latPoint, lonPoint), radius, Length.DECIMAL_DEGREE, -1);
    }

    public OMRangeRings(float latPoint, float lonPoint, float radius, Length units) {
        this(new LatLonPoint(latPoint, lonPoint), radius, units, -1);
    }

    public OMRangeRings(float latPoint, float lonPoint, float radius, Length units, int nverts) {
        this(new LatLonPoint(latPoint, lonPoint), radius, units, nverts);
    }

    public OMRangeRings(LatLonPoint center, float radius, Length units, int nverts) {
        super(center, radius, units, nverts);
        this.centerPoint = this.createCenterPoint();
        this.form.setMaximumFractionDigits(2);
    }

    protected OMPoint createCenterPoint() {
        return new OMPoint(this.center.getLatitude(), this.center.getLongitude());
    }

    public void setInterval(int interval) {
        this.interval = interval;
        this.setNeedToRegenerate(true);
    }

    public void setInterval(int interval, Length units) {
        this.setInterval(interval);
        this.setIntervalUnits(units);
    }

    public int getInterval() {
        return this.interval;
    }

    public void setIntervalUnits(Length units) {
        this.intervalUnits = units;
        this.setNeedToRegenerate(true);
    }

    public Length getIntervalUnits() {
        return this.intervalUnits;
    }

    public void setDrawLabels(boolean dl) {
        this.drawLabels = dl;
    }

    public boolean getDrawLabels() {
        return this.drawLabels;
    }

    public void setFormat(NumberFormat nf) {
        this.form = nf != null ? nf : DEFAULT_FORMAT;
    }

    public NumberFormat getFormat() {
        return this.form;
    }

    public void setRadius(float radius) {
        this.setRadius(radius, Length.DECIMAL_DEGREE);
    }

    public void setRadius(float radius, Length units) {
        this.radius = units.toRadians(radius);
        this.setNeedToRegenerate(true);
    }

    public OMCircle[] createCircles() {
        OMText[] t;
        OMCircle[] circles;
        if (this.intervalUnits == null) {
            int noUnitInterval = this.interval - 1;
            circles = new OMCircle[noUnitInterval];
            t = new OMText[noUnitInterval];
            int i = 0;
            while (i < noUnitInterval) {
                float rad = (float)(i + 1) * this.radius / (float)(noUnitInterval + 1);
                circles[i] = new OMCircle(this.center, rad, Length.RADIAN, -1);
                String value = i + 1 + "/" + (noUnitInterval + 1);
                t[i] = new OMText(this.center.getLatitude() + Length.DECIMAL_DEGREE.fromRadians(rad), this.center.getLongitude(), value, 1);
                ++i;
            }
        } else {
            String value;
            float realDistanceInterval = this.intervalUnits.toRadians(this.interval);
            int number = (int)(this.radius / realDistanceInterval);
            circles = new OMCircle[number];
            t = new OMText[number + 1];
            int i = 0;
            while (i < number) {
                float rad = (float)(i + 1) * realDistanceInterval;
                circles[i] = new OMCircle(this.center, rad, Length.RADIAN, -1);
                value = this.form.format(this.intervalUnits.fromRadians(rad)) + " " + this.intervalUnits.getAbbr();
                t[i] = new OMText(this.center.getLatitude() + Length.DECIMAL_DEGREE.fromRadians(rad), this.center.getLongitude(), value, 1);
                ++i;
            }
            value = this.form.format(this.intervalUnits.fromRadians(this.radius)) + " " + this.intervalUnits.getAbbr();
            t[i] = new OMText(this.center.getLatitude() + Length.DECIMAL_DEGREE.fromRadians(this.radius), this.center.getLongitude(), value, 1);
        }
        this.labels = t;
        return circles;
    }

    public boolean generate(Projection proj) {
        if (this.getNeedToRegenerate()) {
            this.subCircles = this.createCircles();
        }
        this.centerPoint = this.createCenterPoint();
        this.centerPoint.generate(proj);
        this.setRenderType(1);
        if (this.subCircles != null) {
            int i = 0;
            while (i < this.subCircles.length) {
                this.subCircles[i].generate(proj);
                this.labels[i].generate(proj);
                ++i;
            }
            if (this.labels.length > i) {
                this.labels[i].generate(proj);
            }
        }
        return super.generate(proj);
    }

    public void render(Graphics g) {
        super.render(g);
        this.drawingAttributes.setFrom(this);
        if (this.subCircles != null) {
            int i = this.subCircles.length - 1;
            while (i >= 0) {
                this.drawingAttributes.setTo(this.subCircles[i]);
                this.drawingAttributes.setTo(this.labels[i]);
                this.labels[i].setLinePaint(this.drawingAttributes.getLinePaint());
                this.subCircles[i].render(g);
                if (this.drawLabels) {
                    this.labels[i].render(g);
                }
                --i;
            }
            if (this.labels.length > this.subCircles.length && this.drawLabels) {
                this.drawingAttributes.setTo(this.labels[this.subCircles.length]);
                this.labels[this.subCircles.length].setLinePaint(this.drawingAttributes.getLinePaint());
                this.labels[this.subCircles.length].render(g);
            }
        }
        if (this.centerPoint != null) {
            this.drawingAttributes.setTo(this.centerPoint);
            this.centerPoint.render(g);
        }
    }

    public float distance(int x, int y) {
        float dist = this.normalizeDistanceForLineWidth(super.distance(x, y));
        float tmpDist = this.centerPoint.distance(x, y);
        if (tmpDist < dist) {
            dist = tmpDist;
        }
        return dist;
    }
}

