/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.LineChoice;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class LineChoiceComboBox
implements ActionListener {
    public static final LineChoice ONEPT = new LineChoice(new BasicStroke(1.0f), "Line Width of 1");
    public static final LineChoice THREEPT = new LineChoice(new BasicStroke(3.0f), "Line Width of 3");
    public static final LineChoice FIVEPT = new LineChoice(new BasicStroke(5.0f), "Line Width of 5");
    public static final LineChoice SEVENPT = new LineChoice(new BasicStroke(7.0f), "Line Width of 7");
    public static final LineChoice NINEPT = new LineChoice(new BasicStroke(9.0f), "Line Width of 9");
    public static final LineChoice ELEVENPT = new LineChoice(new BasicStroke(11.0f), "Line Width of 11");
    protected DrawingAttributes drawingAttributes;

    public JComboBox getComboBox(DrawingAttributes da) {
        this.drawingAttributes = da;
        JPanel lineWidthPanel = new JPanel();
        Object[] lineWidths = new Object[]{ONEPT.getIcon(), THREEPT.getIcon(), FIVEPT.getIcon(), SEVENPT.getIcon(), NINEPT.getIcon(), ELEVENPT.getIcon()};
        JComboBox<Object> lineWidthList = new JComboBox<Object>(lineWidths);
        lineWidthList.setToolTipText("Line Width");
        int mWidth = 0;
        int mHeight = 0;
        int i = 0;
        while (i < lineWidths.length) {
            ImageIcon icon = (ImageIcon)lineWidths[i];
            if (icon.getIconWidth() > mWidth) {
                mWidth = icon.getIconWidth();
            }
            if (icon.getIconHeight() > mHeight) {
                mHeight = icon.getIconHeight();
            }
            ++i;
        }
        lineWidthList.setMaximumSize(new Dimension(mWidth + 2, mHeight));
        lineWidthList.setSelectedIndex(LineChoiceComboBox.getLineWidthSelection(da.getStroke()));
        lineWidthList.addActionListener(this);
        return lineWidthList;
    }

    public static int getLineWidthSelection(Stroke stroke) {
        if (stroke == null || !(stroke instanceof BasicStroke)) {
            return 0;
        }
        float lw = ((BasicStroke)stroke).getLineWidth();
        int currentChoice = 0;
        if (lw >= ONEPT.getStroke().getLineWidth() - 1.0f) {
            currentChoice = 0;
        }
        if (lw >= THREEPT.getStroke().getLineWidth() - 1.0f) {
            currentChoice = 1;
        }
        if (lw >= FIVEPT.getStroke().getLineWidth() - 1.0f) {
            currentChoice = 2;
        }
        if (lw >= SEVENPT.getStroke().getLineWidth() - 1.0f) {
            currentChoice = 3;
        }
        if (lw >= NINEPT.getStroke().getLineWidth() - 1.0f) {
            currentChoice = 4;
        }
        if (lw >= ELEVENPT.getStroke().getLineWidth() - 1.0f) {
            currentChoice = 5;
        }
        return currentChoice;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.drawingAttributes == null) {
            return;
        }
        BasicStroke currentStroke = (BasicStroke)this.drawingAttributes.getStroke();
        if (currentStroke == null) {
            this.drawingAttributes.setStroke(new BasicStroke(1.0f));
            return;
        }
        float[] dash = currentStroke.getDashArray();
        float phase = currentStroke.getDashPhase();
        int cap = currentStroke.getEndCap();
        int join = currentStroke.getLineJoin();
        float miterLimit = currentStroke.getMiterLimit();
        float lineWidth = ONEPT.getStroke().getLineWidth();
        JComboBox jcb = (JComboBox)e.getSource();
        int newView = jcb.getSelectedIndex();
        switch (newView) {
            case 1: {
                lineWidth = THREEPT.getStroke().getLineWidth();
                break;
            }
            case 2: {
                lineWidth = FIVEPT.getStroke().getLineWidth();
                break;
            }
            case 3: {
                lineWidth = SEVENPT.getStroke().getLineWidth();
                break;
            }
            case 4: {
                lineWidth = NINEPT.getStroke().getLineWidth();
                break;
            }
            case 5: {
                lineWidth = ELEVENPT.getStroke().getLineWidth();
                break;
            }
            default: {
                lineWidth = ONEPT.getStroke().getLineWidth();
            }
        }
        this.drawingAttributes.setStroke(new BasicStroke(lineWidth, cap, join, miterLimit, dash, phase));
    }
}

