/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicConstants;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

public class GraphicAttributes
extends DrawingAttributes
implements ActionListener,
Serializable,
OMGraphicConstants {
    public static final String lineTypeProperty = "lineType";
    public static final String renderTypeProperty = "renderType";
    protected int lineType = 1;
    protected int renderType = 2;
    protected boolean enableLineTypeChoice = true;
    public static final GraphicAttributes DEFAULT = new GraphicAttributes();

    public GraphicAttributes() {
    }

    public GraphicAttributes(Properties props) {
        super(props);
    }

    public GraphicAttributes(String prefix, Properties props) {
        super(prefix, props);
    }

    public static GraphicAttributes getGADefaultClone() {
        return (GraphicAttributes)DEFAULT.clone();
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        if (props == null) {
            return;
        }
        String realPrefix = prefix != null ? prefix + "." : "";
        this.lineType = LayerUtils.intFromProperties(props, realPrefix + lineTypeProperty, 0);
        this.renderType = LayerUtils.intFromProperties(props, realPrefix + renderTypeProperty, 0);
    }

    public Object clone() {
        GraphicAttributes clone = new GraphicAttributes();
        this.setTo(clone);
        return clone;
    }

    public void setTo(GraphicAttributes clone) {
        super.setTo(clone);
        clone.renderType = this.renderType;
        clone.lineType = this.lineType;
        clone.enableLineTypeChoice = this.enableLineTypeChoice;
    }

    public int getLineType() {
        return this.lineType;
    }

    public void setLineType(int lt) {
        int oldLineType = this.lineType;
        this.lineType = lt == 1 || lt == 3 || lt == 2 ? lt : 0;
        this.propertyChangeSupport.firePropertyChange(lineTypeProperty, oldLineType, this.lineType);
    }

    public int getRenderType() {
        return this.renderType;
    }

    public void setRenderType(int rt) {
        int oldRenderType = this.renderType;
        this.renderType = rt == 2 || rt == 1 || rt == 3 ? rt : 0;
        this.propertyChangeSupport.firePropertyChange(renderTypeProperty, oldRenderType, this.renderType);
    }

    public void setFrom(OMGraphic graphic) {
        super.setFrom(graphic);
        this.lineType = graphic.getLineType();
        this.renderType = graphic.getRenderType();
        this.enableLineTypeChoice = graphic.hasLineTypeChoice();
    }

    public void setTo(OMGraphic graphic) {
        super.setTo(graphic);
        graphic.setLineType(this.lineType);
        graphic.setRenderType(this.renderType);
    }

    public void setEnableLineTypeChoice(boolean value) {
        this.enableLineTypeChoice = value;
    }

    public boolean getEnableLineTypeChoice() {
        return this.enableLineTypeChoice;
    }

    public JMenu getLineTypeMenu() {
        JMenu lineTypeMenu = null;
        if (this.renderType == 1 && this.enableLineTypeChoice) {
            lineTypeMenu = new JMenu("Line Type");
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    String command = ae.getActionCommand();
                    try {
                        GraphicAttributes.this.setLineType(Integer.parseInt(command));
                    }
                    catch (NumberFormatException e) {}
                }
            };
            ButtonGroup group = new ButtonGroup();
            JRadioButtonMenuItem button = new JRadioButtonMenuItem("Great Circle", this.lineType == 3);
            button.setActionCommand(String.valueOf(3));
            group.add(button);
            button.addActionListener(listener);
            lineTypeMenu.add(button);
            button = new JRadioButtonMenuItem("Rhumb", this.lineType == 2);
            button.setActionCommand(String.valueOf(2));
            group.add(button);
            button.addActionListener(listener);
            lineTypeMenu.add(button);
            button = new JRadioButtonMenuItem("Straight", this.lineType == 1);
            button.setActionCommand(String.valueOf(1));
            group.add(button);
            button.addActionListener(listener);
            lineTypeMenu.add(button);
        }
        return lineTypeMenu;
    }
}

