/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.LineChoice;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class DashedLineChoiceComboBox
implements ActionListener {
    public static final LineChoice ONE = new LineChoice(new BasicStroke(3.0f), "Whole");
    public static final LineChoice TWO = new LineChoice(new BasicStroke(3.0f, 0, 0, 10.0f, new float[]{3.0f, 3.0f}, 0.0f), "3/3");
    public static final LineChoice THREE = new LineChoice(new BasicStroke(3.0f, 0, 0, 10.0f, new float[]{6.0f, 6.0f}, 0.0f), "6/6");
    public static final LineChoice FOUR = new LineChoice(new BasicStroke(3.0f, 0, 0, 10.0f, new float[]{10.0f, 5.0f}, 3.0f), "10/5/3");
    public static final LineChoice FIVE = new LineChoice(new BasicStroke(3.0f, 0, 0, 10.0f, new float[]{10.0f, 5.0f, 2.0f, 5.0f}, 3.0f), "10/5/3");
    protected DrawingAttributes drawingAttributes;

    public JComboBox getComboBox(DrawingAttributes da) {
        this.drawingAttributes = da;
        JPanel lineDashPanel = new JPanel();
        Object[] lineDashes = new Object[]{ONE.getIcon(), TWO.getIcon(), THREE.getIcon(), FOUR.getIcon(), FIVE.getIcon()};
        JComboBox<Object> lineDashList = new JComboBox<Object>(lineDashes);
        lineDashList.setToolTipText("Line Dash Pattern");
        int mWidth = 0;
        int mHeight = 0;
        int i = 0;
        while (i < lineDashes.length) {
            ImageIcon icon = (ImageIcon)lineDashes[i];
            if (icon.getIconWidth() > mWidth) {
                mWidth = icon.getIconWidth();
            }
            if (icon.getIconHeight() > mHeight) {
                mHeight = icon.getIconHeight();
            }
            ++i;
        }
        lineDashList.setMaximumSize(new Dimension(mWidth + 2, mHeight));
        lineDashList.setSelectedIndex(DashedLineChoiceComboBox.tryToDetermineStroke(da.getStroke()));
        lineDashList.addActionListener(this);
        return lineDashList;
    }

    public static int tryToDetermineStroke(Stroke stroke) {
        if (stroke == null || !(stroke instanceof BasicStroke)) {
            return 0;
        }
        BasicStroke bs = (BasicStroke)stroke;
        float[] dashArray = bs.getDashArray();
        int currentChoice = 0;
        if (dashArray == null) {
            return currentChoice;
        }
        float[] ta = TWO.getStroke().getDashArray();
        if (ta.length == dashArray.length && dashArray[0] == ta[0] && dashArray[1] == ta[1]) {
            return 1;
        }
        ta = THREE.getStroke().getDashArray();
        if (ta.length == dashArray.length && dashArray[0] == ta[0] && dashArray[1] == ta[1]) {
            return 2;
        }
        ta = FOUR.getStroke().getDashArray();
        if (ta.length == dashArray.length && dashArray[0] == ta[0] && dashArray[1] == ta[1]) {
            return 3;
        }
        ta = FIVE.getStroke().getDashArray();
        if (ta.length == dashArray.length && dashArray[0] == ta[0] && dashArray[1] == ta[1]) {
            return 4;
        }
        return currentChoice;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.drawingAttributes == null) {
            return;
        }
        BasicStroke currentStroke = (BasicStroke)this.drawingAttributes.getStroke();
        if (currentStroke == null) {
            this.drawingAttributes.setStroke(new BasicStroke(1.0f));
            return;
        }
        float lineWidth = currentStroke.getLineWidth();
        int cap = currentStroke.getEndCap();
        int join = currentStroke.getLineJoin();
        float miterLimit = currentStroke.getMiterLimit();
        float[] dash = ONE.getStroke().getDashArray();
        float phase = ONE.getStroke().getDashPhase();
        JComboBox jcb = (JComboBox)e.getSource();
        int newView = jcb.getSelectedIndex();
        switch (newView) {
            case 1: {
                dash = TWO.getStroke().getDashArray();
                phase = TWO.getStroke().getDashPhase();
                break;
            }
            case 2: {
                dash = THREE.getStroke().getDashArray();
                phase = THREE.getStroke().getDashPhase();
                break;
            }
            case 3: {
                dash = FOUR.getStroke().getDashArray();
                phase = FOUR.getStroke().getDashPhase();
                break;
            }
            case 4: {
                dash = FIVE.getStroke().getDashArray();
                phase = FIVE.getStroke().getDashPhase();
                break;
            }
            default: {
                dash = ONE.getStroke().getDashArray();
                phase = ONE.getStroke().getDashPhase();
            }
        }
        this.drawingAttributes.setStroke(new BasicStroke(lineWidth, cap, join, miterLimit, dash, phase));
    }
}

