/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.AreaTable;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.EdgeTable;
import com.bbn.openmap.layer.vpf.LayerGraphicWarehouseSupport;
import com.bbn.openmap.layer.vpf.MutableInt;
import com.bbn.openmap.layer.vpf.NodeTable;
import com.bbn.openmap.layer.vpf.TextTable;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class VPFLayerDCWWarehouse
extends LayerGraphicWarehouseSupport {
    public static final String AreaTypeExcludeProperty = "areaTypeExclude";
    public static final String LineTypeExcludeProperty = "lineTypeExclude";
    public static final String TextTypeExcludeProperty = "textTypeExclude";
    protected int[] areaTypeExcludes = null;
    protected int[] lineTypeExcludes = null;
    protected int[] textTypeExcludes = null;
    protected boolean DEBUG = Debug.debugging("DCW");

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        String list = props.getProperty(realPrefix + AreaTypeExcludeProperty);
        this.areaTypeExcludes = list != null ? this.getNumbersFromPropertyList(list) : this.getNumbersFromPropertyList("0 2");
        if (this.DEBUG) {
            Debug.output("Excluding area types: " + this.areaTypeExcludes);
        }
        if ((list = props.getProperty(realPrefix + LineTypeExcludeProperty)) != null) {
            this.lineTypeExcludes = this.getNumbersFromPropertyList(list);
        }
        if (this.DEBUG) {
            Debug.output("Excluding area types: " + this.lineTypeExcludes);
        }
        if ((list = props.getProperty(realPrefix + TextTypeExcludeProperty)) != null) {
            this.textTypeExcludes = this.getNumbersFromPropertyList(list);
        }
        if (this.DEBUG) {
            Debug.output("Excluding area types: " + this.textTypeExcludes);
        }
    }

    protected int[] getNumbersFromPropertyList(String list) {
        ArrayList<Integer> realList = new ArrayList<Integer>();
        Vector excludes = PropUtils.parseSpacedMarkers(list);
        Iterator it = excludes.iterator();
        while (it.hasNext()) {
            String number = (String)it.next();
            try {
                realList.add(Integer.valueOf(number));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        int[] numbers = null;
        int size = realList.size();
        if (size > 0) {
            numbers = new int[size];
            int count = 0;
            Iterator it2 = realList.iterator();
            while (it2.hasNext()) {
                numbers[count++] = (Integer)it2.next();
            }
        }
        return numbers;
    }

    protected boolean onList(int[] list, int num) {
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                if (num == list[i]) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public List getFeatures() {
        return Collections.EMPTY_LIST;
    }

    public void createArea(CoverageTable covtable, AreaTable areatable, List facevec, LatLonPoint ll1, LatLonPoint ll2, float dpplat, float dpplon) {
        ArrayList ipts = new ArrayList();
        if (this.areaTypeExcludes != null) {
            MutableInt areatype = new MutableInt(-1);
            String descript = covtable.getAreaDescription(facevec, areatype);
            if (this.onList(this.areaTypeExcludes, areatype.value)) {
                return;
            }
        }
        int totalSize = 0;
        try {
            totalSize = areatable.computeEdgePoints(facevec, ipts);
        }
        catch (FormatException f) {
            Debug.output("FormatException in computeEdgePoints: " + f);
            return;
        }
        if (totalSize == 0) {
            return;
        }
        OMPoly py = LayerGraphicWarehouseSupport.createAreaOMPoly(ipts, totalSize, ll1, ll2, dpplat, dpplon, covtable.doAntarcticaWorkaround);
        this.drawingAttributes.setTo(py);
        py.setLinePaint(py.getFillPaint());
        py.setSelectPaint(py.getFillPaint());
        this.graphics.add(py);
    }

    public void createEdge(CoverageTable covtable, EdgeTable edgetable, List edgevec, LatLonPoint ll1, LatLonPoint ll2, float dpplat, float dpplon, CoordFloatString coords) {
        if (this.lineTypeExcludes != null) {
            MutableInt lineType = new MutableInt(-1);
            String desc = covtable.getLineDescription(edgevec, lineType);
            if (this.onList(this.lineTypeExcludes, lineType.value)) {
                return;
            }
        }
        OMPoly py = LayerGraphicWarehouseSupport.createEdgeOMPoly(coords, ll1, ll2, dpplat, dpplon);
        this.drawingAttributes.setTo(py);
        py.setIsPolygon(false);
        this.graphics.add(py);
    }

    public void createText(CoverageTable covtable, TextTable texttable, List textvec, float latitude, float longitude, String text) {
        if (this.textTypeExcludes != null) {
            MutableInt textType = new MutableInt(-1);
            String desc = covtable.getTextDescription(textvec, textType);
            if (this.onList(this.textTypeExcludes, textType.value)) {
                return;
            }
        }
        OMText txt = LayerGraphicWarehouseSupport.createOMText(text, latitude, longitude);
        this.drawingAttributes.setTo(txt);
        this.graphics.add(txt);
    }

    public void createNode(CoverageTable c, NodeTable t, List nodeprim, float latitude, float longitude, boolean isEntityNode) {
        OMPoint pt = LayerGraphicWarehouseSupport.createOMPoint(latitude, longitude);
        this.drawingAttributes.setTo(pt);
        this.graphics.add(pt);
    }
}

