/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.CoverageAttributeTable;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.FeatureClassInfo;
import com.bbn.openmap.layer.vpf.LibrarySelectionTable;
import java.util.Enumeration;
import java.util.Hashtable;

public class DescribeDB {
    public static void println(String s) {
        System.out.println(s);
    }

    public static void println(String s1, String s2) {
        DescribeDB.println(s1 + s2);
    }

    public static void print(String s1, String s2) {
        DescribeDB.print(s1);
        DescribeDB.print(s2);
    }

    public static void print(String s) {
        System.out.print(s);
    }

    public static void main(String[] args) throws FormatException {
        int argsi = 0;
        while (argsi < args.length) {
            String rootpath = args[argsi];
            LibrarySelectionTable lst = new LibrarySelectionTable(rootpath);
            DescribeDB.println("Path to database: " + rootpath);
            DescribeDB.println("Database Name: " + lst.getDatabaseName());
            DescribeDB.println("Database Description: " + lst.getDatabaseDescription());
            String[] libraries = lst.getLibraryNames();
            DescribeDB.print("Database Libraries: ");
            int i = 0;
            while (i < libraries.length) {
                DescribeDB.print(libraries[i], " ");
                ++i;
            }
            DescribeDB.println("");
            DescribeDB.println("");
            int i2 = 0;
            while (i2 < libraries.length) {
                String prefix = libraries[i2] + ":";
                DescribeDB.printLibrary(prefix, lst.getCAT(libraries[i2]));
                DescribeDB.println("");
                ++i2;
            }
            ++argsi;
        }
    }

    public static void printLibrary(String prefix, CoverageAttributeTable cat) {
        if (cat == null) {
            DescribeDB.println(prefix, "Library doesn't exist");
            return;
        }
        DescribeDB.println(prefix);
        String[] coverages = cat.getCoverageNames();
        DescribeDB.println(prefix, "uses " + (cat.isTiledData() ? "tiled" : "untiled") + " data");
        DescribeDB.print(prefix, "Coverage names:");
        int i = 0;
        while (i < coverages.length) {
            DescribeDB.print(coverages[i]);
            DescribeDB.print(" ");
            ++i;
        }
        DescribeDB.println("");
        int i2 = 0;
        while (i2 < coverages.length) {
            DescribeDB.printCoverage(prefix + coverages[i2] + ":", cat, coverages[i2]);
            ++i2;
        }
    }

    public static void printCoverage(String prefix, CoverageAttributeTable cat, String covname) {
        DescribeDB.println(prefix, "Coverage Description: " + cat.getCoverageDescription(covname));
        DescribeDB.println(prefix, "Coverage Topology Level: " + cat.getCoverageTopologyLevel(covname));
        CoverageTable ct = cat.getCoverageTable(covname);
        DescribeDB.print(prefix, "FeatureClassNames: ");
        DescribeDB.println("");
        Hashtable info = ct.getFeatureTypeInfo();
        Enumeration enumeration = info.elements();
        while (enumeration.hasMoreElements()) {
            CoverageTable.FeatureClassRec fcr = (CoverageTable.FeatureClassRec)enumeration.nextElement();
            String tstring = "[unknown] ";
            if (fcr.type == 'T') {
                tstring = "[text feature] ";
            } else if (fcr.type == 'L') {
                tstring = "[edge feature] ";
            } else if (fcr.type == 'A') {
                tstring = "[area feature] ";
            } else if (fcr.type == 'P') {
                FeatureClassInfo fci = ct.getFeatureClassInfo(fcr.feature_class);
                tstring = fci == null ? "[point feature] " : (fci.getFeatureType() == 'E' ? "[entity point feature] " : (fci.getFeatureType() == 'N' ? "[connected point feature] " : "[point feature] "));
            } else if (fcr.type == 'C') {
                tstring = "[complex feature] ";
            }
            DescribeDB.println(prefix, fcr.feature_class + ": " + tstring + fcr.description);
        }
    }
}

